

#DEFPARAMS
_EnvMap = { "Env Map", TEXTURECUBE, "cube"},
_BumpMap = { "Normal Map", TEXTURE2D, "bump" },
_LodLevel = { "cube Mip Level", FLOAT, "3.0"},
#END

#DEFTAG
ShaderName = "CubeTest"
RenderQueue = "Opaque"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_ON, DEPTH_TEST_ON, DEPTH_FUNCTION_LESS }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "light.inc"

struct appdata
{
	float4 vertex : POSITION;
	float3 normal : NORMAL;
	float3 binoraml : BINORMAL;
	float3 tangent : TANGENT;
	float2 uv : TEXCOORD0;
};

struct v2f
{
	float2 uv : TEXCOORD0;
	float4 worldnormal : TEXCOORD1;
	float4 worldtangent : TEXCOORD2;
	float4 worldbinormal : TEXCOORD3;
	float4 vertex : SV_POSITION;
};

sampler2D _BumpMap;
samplerCUBE _EnvMap;
float _LodLevel;

v2f vert(appdata v)
{
	v2f o;
	o.vertex = ObjectToClipPos(v.vertex);
	o.uv = v.uv.xy;
	float3 worldpos = ObjectToWorldPos(v.vertex).xyz;
	o.worldnormal.xyz = ObjectToWorldNormal(v.normal).xyz;
	o.worldtangent.xyz = ObjectToWorldDir(v.tangent).xyz;
	o.worldbinormal.xyz = ObjectToWorldDir(v.binoraml).xyz;

	o.worldnormal.w = worldpos.x;
	o.worldtangent.w = worldpos.y;
	o.worldbinormal.w = worldpos.z;

	return o;
}

float4 frag(v2f i) : SV_Target
{
	// normal world
	float2 bumpUV = i.uv;
	float3 normalTangent = tex2D(_BumpMap, bumpUV).rgb;
	normalTangent.xyz = normalTangent.xyz * 2.0 - 1.0;
	float3 normalWorld = normalTangent.x * i.worldtangent.xyz + normalTangent.y * i.worldtangent.xyz
		+ normalTangent.z * i.worldnormal.xyz;
	normalWorld.xyz = normalize(normalWorld.xyz);

	// reflect dir
	float3 worldPos = float3(i.worldnormal.w, i.worldtangent.w, i.worldbinormal.w);
	float3 reflectDir = WorldReflectionVector(worldPos, normalWorld);
	half4 reflectCol = SAMPLE_TEXCUBE_LOD(_EnvMap, reflectDir, _LodLevel);

	reflectCol.xyz = reflectCol.xyz * reflectCol.w * 6.0;

	return float4(reflectCol.xyz, 1.0);
}
ENDCG
#END
