

#DEFPARAMS
_MainTex = { "main Color", TEXTURE2D, "maintex" },
_Input = { "input", VEC3, "0.0,1.0,255.0"},
_Output = { "output", VEC2, "0.0,255.0"},
#END

#DEFTAG
ShaderName = "LevelAdjust"
RenderQueue = "POSTEFFECT"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_ON, DEPTH_TEST_ON, DEPTH_FUNCTION_LESS }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag

struct appdata
{
	float4 vertex : POSITION;
	float2 uv : TEXCOORD0;
};

struct v2f
{
	float2 uv : TEXCOORD0;
	float4 vertex : SV_POSITION;
};

sampler2D _MainTex;
float3 _Input;
float2 _Output;

v2f vert(appdata v)
{
	v2f o;
	o.vertex = v.vertex;
	o.uv = v.uv.xy;

	return o;
}

float4 frag(v2f i) : SV_Target
{
  // sample the texture
	float4 mainColor = tex2D(_MainTex, i.uv);
  float diff = _Input.z - _Input.x;
  float outdiff = _Output.y - _Output.x;
  float exponent = 1.0/_Input.y;
  
  float r = mainColor.r*255.0;
  float g = mainColor.g*255.0;
  float b = mainColor.r*255.0;
 
  //r通道
  r = max(0.0, r - _Input.x);
  r = saturate(pow(r / diff, exponent));
  r = (r * outdiff + _Output.x)/255.0;
 
  //g通道
  g = max(0.0, g - _Input.x);
  g = saturate(pow(g / diff, exponent));
  g = (g * outdiff + _Output.x)/255.0;
 
  //b通道
  b = max(0.0, b - _Input.x);
  b = saturate(pow(b / diff, exponent));
  b = (b * outdiff + _Output.x)/255.0;
  
  mainColor = float4(r,g,b,mainColor.a);
	return mainColor;
}
ENDCG
#END
