

#DEFPARAMS
_MainTex = { "main Color", TEXTURE2D, "maintex" },
_Bounds1 = { "bounds1", VEC3, "0.79,0.81,0.8"},
_Bounds2 = { "bounds2", VEC3, "0.99,1.0,1.0"},
_TexelWidth = { "texel Width", FLOAT , "0.004166667"},
#END

#DEFTAG
ShaderName = "Glitch"
RenderQueue = "Transparent"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_ON, DEPTH_TEST_ON, DEPTH_FUNCTION_LESS }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag

struct appdata
{
	float4 vertex : POSITION;
	float2 uv : TEXCOORD0;
};

struct v2f
{
	float2 uv : TEXCOORD0;
	float4 vertex : SV_POSITION;
};

sampler2D _MainTex;
float _TexelWidth;
float3 _Bounds1;
float3 _Bounds2;

v2f vert(appdata v)
{
	v2f o;
	o.vertex = v.vertex;
	o.uv = v.uv.xy;

	return o;
}

float4 frag(v2f i) : SV_Target
{
// sample the texture
	float2 uv = i.uv;
	float texelSize = _TexelWidth;
	if(uv.y > _Bounds1.x && uv.y < _Bounds2.y)
	{
  	if (uv.y < _Bounds1.y)
		{
    	uv.x += texelSize * (cos(abs(uv.y - _Bounds1.z) * 314.0) + 1.0) * 0.5;
    }
		else if (uv.y > _Bounds2.x)
		{
      uv.x += texelSize * (cos(abs(uv.y - _Bounds2.z) * 314.0) + 1.0) * 0.5;
    }
  }
	float4 mainColor = tex2D(_MainTex, uv);
	return mainColor;
}
ENDCG
#END
