

#DEFPARAMS
_MainTex = { "main tex", TEXTURE2D, "white" },
_MainColor = {"main color", COLOR, "1.0,1.0,1.0,1.0"},
_BumpMap = { "Normal Map", TEXTURE2D, "bump" },
_EnvMap = { "Env Map", TEXTURE2D, "black"},
_FresnelPower = { "Fresnel Power", FLOAT, "10"},
_FresnelBase = {"Fresnel Base", FLOAT, "0.9"},
_Cutoff = {"Cut Off", FLOAT, "1.0"},
_Opacity = {"Opacity", FLOAT, "0.3"},
_ReflectCol = {"Reflect Color", COLOR, "0.8,0.8,1.0,1.0"},
_ReflectStrength = { "Reflect Strength", FLOAT, "7.5" },
_MainUVScale = {"Main UV Scale", VEC2, "0.1,0.1"},
_BumpUVScale = {"Bump UV Scale", VEC2, "0.001,0.001"}
#END

#DEFTAG
ShaderName = "IceSphere"
RenderQueue = "Transparent+1"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_BLEND, SRC_ALPHA, ONE_MINUS_SRC_ALPHA, ONE, ONE }
DRAW_MODE = { CULL_FACE_BACK, DEPTH_MASK_OFF, DEPTH_TEST_ON, DEPTH_FUNCTION_LESS }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "light.inc"

struct appdata
{
	float4 vertex : POSITION;
	float3 normal : NORMAL;
	float3 binoraml : BINORMAL;
	float3 tangent : TANGENT;
	float2 uv : TEXCOORD0;
};

struct v2f
{
	float2 uv : TEXCOORD0;
	float4 worldnormal : TEXCOORD1;
	float4 worldtangent : TEXCOORD2;
	float4 worldbinormal : TEXCOORD3;
	float4 vertex : SV_POSITION;
};

sampler2D _MainTex;
sampler2D _BumpMap;
sampler2D _EnvMap;
float _FresnelPower;
float _FresnelBase;
float _Cutoff;
float _Opacity;
float4 _ReflectCol;
float _ReflectStrength;
float2 _MainUVScale;
float2 _BumpUVScale;

float4 _MainColor;

v2f vert(appdata v)
{
	v2f o;
	o.vertex = ObjectToClipPos(v.vertex);
	o.uv = v.uv.xy;
	float3 worldpos = ObjectToWorldPos(v.vertex).xyz;
	o.worldnormal.xyz = ObjectToWorldNormal(v.normal).xyz;
	o.worldtangent.xyz = ObjectToWorldDir(v.tangent).xyz;
	o.worldbinormal.xyz = ObjectToWorldDir(v.binoraml).xyz;

	o.worldnormal.w = worldpos.x;
	o.worldtangent.w = worldpos.y;
	o.worldbinormal.w = worldpos.z;

	return o;
}

float4 frag(v2f i) : SV_Target
{
	// sample the texture
	float2 mainUV = i.uv * _MainUVScale;
	float4 mainColor = tex2D(_MainTex, mainUV) * _MainColor;

	// normal world
	float2 bumpUV = i.uv * _BumpUVScale;
	float3 normalTangent = tex2D(_BumpMap, bumpUV).rgb;
	normalTangent.xyz = normalTangent.xyz * 2.0 - 1.0;
	float3 normalWorld = normalTangent.x * i.worldtangent.xyz + normalTangent.y * i.worldtangent.xyz
		+ normalTangent.z * i.worldnormal.xyz;
	normalWorld.xyz = normalize(normalWorld.xyz);

	// reflect dir
	float3 worldPos = float3(i.worldnormal.w, i.worldtangent.w, i.worldbinormal.w);
	float3 reflectDir = WorldReflectionVector(worldPos, normalWorld);

	reflectDir.xyz = normalize(reflectDir.xyz);
	float m = 2.0 * sqrt(reflectDir.x * reflectDir.x + reflectDir.y * reflectDir.y + (reflectDir.z + 1.0) * (reflectDir.z + 1.0));
    float sphereUV = reflectDir.xy / m + 0.5;
	half4 reflectCol = tex2D(_EnvMap, sphereUV) * mainColor.w;

//	half4 reflectCol = SAMPLE_TEXCUBE(_EnvMap, reflectDir) * mainColor.w;

	float3 viewDirWorld = WorldViewDir(worldPos);
	half dotNV = dot(normalWorld, viewDirWorld);
	half fresnel = saturate(1.0 - dotNV);
	fresnel = pow(fresnel, _FresnelPower);
	fresnel = _FresnelBase + (1.0 - _FresnelBase) * fresnel;

	float4 outColor;
	outColor.xyz = mainColor.xyz * (1.0 - fresnel) + reflectCol * fresnel;
	outColor.xyz = outColor.xyz * _ReflectCol.xyz * _ReflectStrength;
	outColor.w = (_Cutoff > mainColor.a ? mainColor.a + _Opacity : 0.0);

	return outColor;
//	return float4(reflectCol.xyz, 1.0);
}
ENDCG
#END
