

#include "common.inc"

#ifndef SHADOW_INC
#define SHADOW_INC

float DepthBias(float3 worldNorm)
{
	float3 lightDirWS = float3(CAMERA_VIEW[2][0], CAMERA_VIEW[2][1], CAMERA_VIEW[2][2]);
	lightDirWS = normalize(lightDirWS);
	float shadowCos = dot(worldNorm.xyz, lightDirWS.xyz);
	float shadowSin = abs(shadowCos);
	float normalBias = 0.03 * shadowSin;
	return normalBias;
}

float4 ApplyShadowBias(float4 clipPos)
{
    float shadowBias = LIGHT_PARAM.x;
	clipPos.z += (shadowBias / clipPos.w);
	return clipPos;
}

#ifdef DirLight
float GetShadowAtten(float4 shadowCoord)
{
    shadowCoord.xyz /= shadowCoord.w;
	const float radius = 0.002;
	float2 curCoord = shadowCoord.xy;
	float4 offRadius0 = curCoord.xyxy + float4(-0.1658961, 0.98614317, 0.8875289, 0.14930651) * radius;
	float4 offRadius1 = curCoord.xyxy + float4(0.13271689, -0.78891462, -0.69030023, -0.1161273) * radius;
	float4 shadowTex;
    float shadowOutMask;
	float in_OrigDepth = shadowCoord.z;

	shadowTex.x = (tex2D( TEXTURE_SHADOW_DEPTH, offRadius0.xy ).x < in_OrigDepth ? 0.0 : 1.0);
    shadowTex.y = (tex2D( TEXTURE_SHADOW_DEPTH, offRadius0.zw ).x < in_OrigDepth ? 0.0 : 1.0);
    shadowTex.z = (tex2D( TEXTURE_SHADOW_DEPTH, offRadius1.xy ).x < in_OrigDepth ? 0.0 : 1.0);
    shadowTex.w = (tex2D( TEXTURE_SHADOW_DEPTH, offRadius1.zw ).x < in_OrigDepth ? 0.0 : 1.0);
    shadowOutMask = dot(shadowTex, float4(0.0625, 0.0625, 0.0625, 0.0625));

	offRadius0 = curCoord.xyxy + float4(-0.35084891, 0.35623729, 0.46310851, 0.45610359) * radius;
    offRadius1 = curCoord.xyxy + float4(0.070169792, -0.071247473, -0.2493661, -0.24559429) * radius;
    shadowTex.x = (tex2D( TEXTURE_SHADOW_DEPTH, offRadius0.xy ).x < in_OrigDepth ? 0.0 : 1.0);
    shadowTex.y = (tex2D( TEXTURE_SHADOW_DEPTH, offRadius0.zw ).x < in_OrigDepth ? 0.0 : 1.0);
    shadowTex.z = (tex2D( TEXTURE_SHADOW_DEPTH, offRadius1.xy ).x < in_OrigDepth ? 0.0 : 1.0);
    shadowTex.w = (tex2D( TEXTURE_SHADOW_DEPTH, offRadius1.zw ).x < in_OrigDepth ? 0.0 : 1.0);
    shadowOutMask += dot(shadowTex, float4(0.0625, 0.0625, 0.0625, 0.0625));

	offRadius0 = curCoord.xyxy + float4(0.055099439, 0.2438525, 0.78032809, -0.1763182) * radius;
    offRadius1 = curCoord.xyxy + float4(-0.198358, -0.87786913, -0.9754101, 0.2203977) * radius;
    shadowTex.x = (tex2D( TEXTURE_SHADOW_DEPTH, offRadius0.xy ).x < in_OrigDepth ? 0.0 : 1.0);
    shadowTex.y = (tex2D( TEXTURE_SHADOW_DEPTH, offRadius0.zw ).x < in_OrigDepth ? 0.0 : 1.0);
    shadowTex.z = (tex2D( TEXTURE_SHADOW_DEPTH, offRadius1.xy ).x < in_OrigDepth ? 0.0 : 1.0);
    shadowTex.w = (tex2D( TEXTURE_SHADOW_DEPTH, offRadius1.zw ).x < in_OrigDepth ? 0.0 : 1.0);
    shadowOutMask += dot(shadowTex, float4(0.0625, 0.0625, 0.0625, 0.0625));

	offRadius0 = curCoord.xyxy + float4(0.4280726, 0.73433912, 0.25917849, -0.15108439) * radius;
    offRadius1 = curCoord.xyxy + float4(-0.3273496, -0.56155342, -0.1727857, 0.100723) * radius;
    shadowTex.x = (tex2D( TEXTURE_SHADOW_DEPTH, offRadius0.xy ).x < in_OrigDepth ? 0.0 : 1.0);
    shadowTex.y = (tex2D( TEXTURE_SHADOW_DEPTH, offRadius0.zw ).x < in_OrigDepth ? 0.0 : 1.0);
    shadowTex.z = (tex2D( TEXTURE_SHADOW_DEPTH, offRadius1.xy ).x < in_OrigDepth ? 0.0 : 1.0);
    shadowTex.w = (tex2D( TEXTURE_SHADOW_DEPTH, offRadius1.zw ).x < in_OrigDepth ? 0.0 : 1.0);
    shadowOutMask += dot(shadowTex, float4(0.0625, 0.0625, 0.0625, 0.0625));
	return shadowOutMask;
}
#else
float GetShadowAtten(float4 worldCoord)
{
    float4 shadowCoord = mul(LIGHT_CAMERA_PROJECTION, mul(LIGHT_CAMERA_VIEW, worldCoord));
    shadowCoord.xyz /= shadowCoord.w;
	shadowCoord.xyz = shadowCoord.xyz * 0.5 + 0.5;

	const float radius = 0.002;
	float2 curCoord = shadowCoord.xy;
	float4 offRadius0 = curCoord.xyxy + float4(-0.1658961, 0.98614317, 0.8875289, 0.14930651) * radius;
	float4 offRadius1 = curCoord.xyxy + float4(0.13271689, -0.78891462, -0.69030023, -0.1161273) * radius;
	float4 shadowTex;
    float shadowOutMask;
	float in_OrigDepth = shadowCoord.z;

	shadowTex.x = (tex2D( TEXTURE_SHADOW_DEPTH, offRadius0.xy ).x < in_OrigDepth ? 0.0 : 1.0);
    shadowTex.y = (tex2D( TEXTURE_SHADOW_DEPTH, offRadius0.zw ).x < in_OrigDepth ? 0.0 : 1.0);
    shadowTex.z = (tex2D( TEXTURE_SHADOW_DEPTH, offRadius1.xy ).x < in_OrigDepth ? 0.0 : 1.0);
    shadowTex.w = (tex2D( TEXTURE_SHADOW_DEPTH, offRadius1.zw ).x < in_OrigDepth ? 0.0 : 1.0);
    shadowOutMask = dot(shadowTex, float4(0.0625, 0.0625, 0.0625, 0.0625));

	offRadius0 = curCoord.xyxy + float4(-0.35084891, 0.35623729, 0.46310851, 0.45610359) * radius;
    offRadius1 = curCoord.xyxy + float4(0.070169792, -0.071247473, -0.2493661, -0.24559429) * radius;
    shadowTex.x = (tex2D( TEXTURE_SHADOW_DEPTH, offRadius0.xy ).x < in_OrigDepth ? 0.0 : 1.0);
    shadowTex.y = (tex2D( TEXTURE_SHADOW_DEPTH, offRadius0.zw ).x < in_OrigDepth ? 0.0 : 1.0);
    shadowTex.z = (tex2D( TEXTURE_SHADOW_DEPTH, offRadius1.xy ).x < in_OrigDepth ? 0.0 : 1.0);
    shadowTex.w = (tex2D( TEXTURE_SHADOW_DEPTH, offRadius1.zw ).x < in_OrigDepth ? 0.0 : 1.0);
    shadowOutMask += dot(shadowTex, float4(0.0625, 0.0625, 0.0625, 0.0625));

	offRadius0 = curCoord.xyxy + float4(0.055099439, 0.2438525, 0.78032809, -0.1763182) * radius;
    offRadius1 = curCoord.xyxy + float4(-0.198358, -0.87786913, -0.9754101, 0.2203977) * radius;
    shadowTex.x = (tex2D( TEXTURE_SHADOW_DEPTH, offRadius0.xy ).x < in_OrigDepth ? 0.0 : 1.0);
    shadowTex.y = (tex2D( TEXTURE_SHADOW_DEPTH, offRadius0.zw ).x < in_OrigDepth ? 0.0 : 1.0);
    shadowTex.z = (tex2D( TEXTURE_SHADOW_DEPTH, offRadius1.xy ).x < in_OrigDepth ? 0.0 : 1.0);
    shadowTex.w = (tex2D( TEXTURE_SHADOW_DEPTH, offRadius1.zw ).x < in_OrigDepth ? 0.0 : 1.0);
    shadowOutMask += dot(shadowTex, float4(0.0625, 0.0625, 0.0625, 0.0625));

	offRadius0 = curCoord.xyxy + float4(0.4280726, 0.73433912, 0.25917849, -0.15108439) * radius;
    offRadius1 = curCoord.xyxy + float4(-0.3273496, -0.56155342, -0.1727857, 0.100723) * radius;
    shadowTex.x = (tex2D( TEXTURE_SHADOW_DEPTH, offRadius0.xy ).x < in_OrigDepth ? 0.0 : 1.0);
    shadowTex.y = (tex2D( TEXTURE_SHADOW_DEPTH, offRadius0.zw ).x < in_OrigDepth ? 0.0 : 1.0);
    shadowTex.z = (tex2D( TEXTURE_SHADOW_DEPTH, offRadius1.xy ).x < in_OrigDepth ? 0.0 : 1.0);
    shadowTex.w = (tex2D( TEXTURE_SHADOW_DEPTH, offRadius1.zw ).x < in_OrigDepth ? 0.0 : 1.0);
    shadowOutMask += dot(shadowTex, float4(0.0625, 0.0625, 0.0625, 0.0625));
	return shadowOutMask;
}
#endif

#ifdef ShadowOn
	#ifdef DirLight
		#define SHADOW_COORDS(idx1) float4 _ShadowCoord : TEXCOORD##idx1;
		#define TRANSFER_SHADOW(o, vertex) float4 lightCoordBuiltin = mul(LIGHT_CAMERA_PROJECTION, mul(LIGHT_CAMERA_VIEW, ObjectToWorldPos(vertex)));\
						o##._ShadowCoord.xyz = lightCoordBuiltin.xyz * 0.5 + 0.5;\
						o##._ShadowCoord.w = 1.0
		#define SHADOW_ATTEN(o) GetShadowAtten(o##._ShadowCoord)
	#elif SpotLight
	    #define SHADOW_COORDS(idx1) float4 _ShadowCoord : TEXCOORD##idx1;
		#define TRANSFER_SHADOW(o, vertex) float4 lightCoordBuiltin = ObjectToWorldPos(vertex);\
						o##._ShadowCoord.xyz = lightCoordBuiltin;\
						o##._ShadowCoord.w = 1.0
		#define SHADOW_ATTEN(o) GetShadowAtten(o##._ShadowCoord)
	#else
		#define SHADOW_COORDS(idx1) 
		#define TRANSFER_SHADOW(o, vertex) float4 lightCoordBuiltin = float4(1.0, 1.0, 1.0, 1.0)
		#define SHADOW_ATTEN(o) 1.0
	#endif
#else
    #define SHADOW_COORDS(idx1)
	#define TRANSFER_SHADOW(o, vertex) float4 lightCoordBuiltin = float4(1.0, 1.0, 1.0, 1.0)
	#define SHADOW_ATTEN(o) 1.0
#endif

#endif
