
#include "functions/brdf.function"

//anisotropy direction map sampling
#SHADER_DEFINE AnisotropySampling

    FUNCTION_INPUT =
    {
				{ TEXTURE_ANISOTROPY,						NONE,			TEXTURE2D,		"anisMap" },
        //可以加一个各向异性角度值
				{ ATTRIBUTE_COORDNATE0,			MEDIUM,		VEC2,					"in_Coordinate" },
    }

    FUNCTION_OUTPUT =
    {
        { ANI_DIRECTION,					LOW,			VEC3,					"direction" },
    }

#SHADER_CODE
    vec3 direction = normalize(texture2D(anisMap, mod(in_Coordinate , vec2(1.0))).xyz* 2.0 - 1.0);
#END_CODE
#END_DEFINE


#SHADER_DEFINE PBRLightingCloth
    FUNCTION_INPUT =
    {
				{ TANGENTSPACE_NORMAL,			LOW,			VEC3,			"in_Normal" },
				{ LIGHT_GIVEN_DIRECTION,		MEDIUM,			VEC3,			"in_LightDirection" },
				{ WORLDSPACE_VIEWDIRECTION,		LOW,			VEC3,			"in_ViewDirection"},
				{ ALBEDO_COLOR,					LOW,			VEC4,			"albedo" },
				{ ROUGHNESS_VALUE,				HIGH,			FLOAT,			"roughness" },
				{ LIGHT_COLOR, 					MEDIUM,			VEC3,			"in_LightColor"},
				{ Base_Reflectivity,			LOW,			VEC3,			"F0"},
        { UNIFORM_FUZZ_COLOR,			MEDIUM,		VEC3,					"fuzzColor"},
    }

    FUNCTION_OUTPUT =
    {
				{ LIGHTING_DIFFUSE,				LOW,			VEC3,			"out_Diffuse" },
				{ LIGHTING_SPECULAR,			LOW,			VEC3,			"out_Specular" },
				{ TANGENTSPACE_NORMAL,			LOW,			VEC3,			"vNormal" },
				{ WORLDSPACE_VIEWDIRECTION,		LOW,			VEC3,			"vView"},
    }

#SHADER_CODE

// light output
	vec3 out_Diffuse;
	vec3 out_Specular;

	vec3 vNormal = normalize(in_Normal);
	//Naming Error. The view direction is in tangent space.
	float length = sqrt(dot(in_ViewDirection,in_ViewDirection));
	length = 1.0/length;
	vec3 vView=in_ViewDirection*length;
	vec3 vLight = normalize(-in_LightDirection);
	vec3 vHalf = normalize(vView + vLight);

	//float NdotV = saturate( abs( dot(vNormal, vView) ) + 1e-5 );
  float NdotV = max(dot(vNormal, vView), 0.0);
	float NdotL = max(dot(vNormal, vLight), 0.0);
	float NdotH = max( dot(vNormal, vHalf) , 0.0 );
{		
	float D;
	//------------------------------------------
	{	
		//Cloth - Asperity Scattering - Inverse Beckmann Layer
		//no anisotropy
		//unreal adopts POW4, mapping α = roughness2 results in a more perceptually linear change
		float alpha = roughness * roughness;
		D = D_InvGGX( alpha * alpha, NdotH );
	}
	//------------------------------------------
	
	//Like Ashikhmin, we dropped the geometry term
	//float G = 1.0;
	//introduce vis term here. Vis = G/denominator
	//We replace the traditional microfacet BRDF denominator with a smoother version. 
	float vis = Vis_Cloth( NdotV, NdotL );
	vec3 F;
	//------------------------------------------
	{
		float VdotH = max(dot(vHalf, vView), 0.0);
		F = F_Schlick( fuzzColor, VdotH );
	}
	//------------------------------------------
		
	vec3 kD = vec3(1.0) - F;
	out_Diffuse  = Diffuse_Lambert( albedo.rgb ) * kD * in_LightColor * NdotL;
	out_Specular = D * vis * F * in_LightColor * NdotL;
}
#END_CODE
#END_DEFINE


#SHADER_DEFINE PBRLightingClothAnis
    FUNCTION_INPUT =
    {
				{ TANGENTSPACE_NORMAL,			LOW,			VEC3,			"in_Normal" },
				{ LIGHT_GIVEN_DIRECTION,		MEDIUM,			VEC3,			"in_LightDirection" },
				{ WORLDSPACE_VIEWDIRECTION,		LOW,			VEC3,			"in_ViewDirection"},
				{ ALBEDO_COLOR,					LOW,			VEC4,			"albedo" },
				{ ROUGHNESS_VALUE,				HIGH,			FLOAT,			"roughness" },
				{ LIGHT_COLOR, 					MEDIUM,			VEC3,			"in_LightColor"},
				{ Base_Reflectivity,			LOW,			VEC3,			"F0"},
				{ UNIFORM_ANISOTROPY,			HIGH,			FLOAT,			"anisotropy" },
				{ UNIFORM_FUZZ_COLOR,			MEDIUM,		VEC3,					"fuzzColor"},
        { ANI_DIRECTION,	LOW,			VEC3,			"anisDirection" },
    }

    FUNCTION_OUTPUT =
    {
				{ LIGHTING_DIFFUSE,				LOW,			VEC3,			"out_Diffuse" },
				{ LIGHTING_SPECULAR,			LOW,			VEC3,			"out_Specular" },
				{ TANGENTSPACE_NORMAL,			LOW,			VEC3,			"vNormal" },
				{ WORLDSPACE_VIEWDIRECTION,		LOW,			VEC3,			"vView"},
    }

#SHADER_CODE

// light output
	vec3 out_Diffuse;
	vec3 out_Specular;

	vec3 vNormal = normalize(in_Normal);
	//Naming Error. The view direction is in tangent space.
	float length = sqrt(dot(in_ViewDirection,in_ViewDirection));
	length = 1.0/length;
	vec3 vView=in_ViewDirection*length;
	vec3 vLight = normalize(-in_LightDirection);
	vec3 vHalf = normalize(vView + vLight);

	float NdotV = max(dot(vNormal, vView), 0.0);
	float NdotL = max(dot(vNormal, vLight), 0.0);

{		
	float D;
	//------------------------------------------
	{
		//Anisotropic specular GGX NDF [Burley]
		//https://google.github.io/filament/Filament.md.html#about/authors 4.10.1
		float alpha = roughness * roughness;
    float NdotH = dot(vNormal, vHalf);

		float HdotX = dot(vHalf, anisDirection);
		float HdotY = dot(vHalf, normalize(cross(vNormal,anisDirection)));
    
      //float HdotX = dot(vHalf, vec3(anisDirection,0.0));
      //float HdotY = dot(vHalf, vec3(-anisDirection.y,anisDirection.x,0.0));
    
		float mx = alpha;
		float my = mix(0, mx, max(1.0f - anisotropy, 0.001));
		D = D_GGXaniso(mx, my, NdotH, HdotX, HdotY);
		//D = D_InvGGXaniso(mx, my, NdotH, HdotX, HdotY);
		//D = D_InvGGX( alpha * alpha, NdotH );
	}
	//------------------------------------------
	
	//Like Ashikhmin, we dropped the geometry term
	//float G = 1.0;
	//introduce vis term here. Vis = G/denominator
	//We replace the traditional microfacet BRDF denominator with a smoother version. 
	float vis = Vis_Cloth( NdotV, NdotL );
	vec3 F;
	//------------------------------------------
	{
		float VdotH = max(dot(vHalf, vView), 0.0);
		F = F_Schlick( F0, VdotH );
	}
	//------------------------------------------
		
	vec3 kD = vec3(1.0) - F;
	out_Diffuse  = Diffuse_Lambert( albedo.rgb ) * kD * in_LightColor * NdotL;
	out_Specular = D * vis * F * in_LightColor * NdotL;
}
#END_CODE
#END_DEFINE

#SHADER_DEFINE PBRLightingClothShadow
    FUNCTION_INPUT =
    {
		{ TANGENTSPACE_NORMAL,			LOW,			VEC3,			"in_Normal" },
		{ LIGHT_GIVEN_DIRECTION,		MEDIUM,			VEC3,			"in_LightDirection" },
		{ WORLDSPACE_VIEWDIRECTION,		LOW,			VEC3,			"in_ViewDirection"},
		{ ALBEDO_COLOR,					LOW,			VEC4,			"albedo" },
		{ ROUGHNESS_VALUE,				HIGH,			FLOAT,			"roughness" },
		{ LIGHT_COLOR, 					MEDIUM,			VEC3,			"in_LightColor"},
		{ Base_Reflectivity,			LOW,			VEC3,			"F0"},
		{ UNIFORM_FUZZ_COLOR,			MEDIUM,		VEC3,					"fuzzColor"},
		{ SHADOWMAP_COLOR,				HIGH,	VEC4,		"in_TransparentColor" },
    }

    FUNCTION_OUTPUT =
    {
		{ LIGHTING_DIFFUSE,				LOW,			VEC3,			"out_Diffuse" },
		{ LIGHTING_SPECULAR,			LOW,			VEC3,			"out_Specular" },
		{ TANGENTSPACE_NORMAL,			LOW,			VEC3,			"vNormal" },
		{ WORLDSPACE_VIEWDIRECTION,		LOW,			VEC3,			"vView"},
    }

#SHADER_CODE

// light output
	vec3 out_Diffuse;
	vec3 out_Specular;

	vec3 vNormal = normalize(in_Normal);
	//Naming Error. The view direction is in tangent space.
	float length = sqrt(dot(in_ViewDirection,in_ViewDirection));
	length = 1.0/length;
	vec3 vView=in_ViewDirection*length;
	vec3 vLight = normalize(-in_LightDirection);
	vec3 vHalf = normalize(vView + vLight);

	//float NdotV = saturate( abs( dot(vNormal, vView) ) + 1e-5 );
	float NdotV = max(dot(vNormal, vView), 0.0);
	float NdotL = max(dot(vNormal, vLight), 0.0);
	float NdotH = max( dot(vNormal, vHalf) , 0.0 );
{		
	float D;
	//------------------------------------------
	{	
		//Cloth - Asperity Scattering - Inverse Beckmann Layer
		//no anisotropy
		//unreal adopts POW4, mapping α = roughness2 results in a more perceptually linear change
		float alpha = roughness * roughness;
		D = D_InvGGX( alpha * alpha, NdotH );
	}
	//------------------------------------------
	
	//Like Ashikhmin, we dropped the geometry term
	//float G = 1.0;
	//introduce vis term here. Vis = G/denominator
	//We replace the traditional microfacet BRDF denominator with a smoother version. 
	float vis = Vis_Cloth( NdotV, NdotL );
	vec3 F;
	//------------------------------------------
	{
		float VdotH = max(dot(vHalf, vView), 0.0);
		F = F_Schlick( fuzzColor, VdotH );
	}
	//------------------------------------------
  
  vec3 newLightColor = mix(in_LightColor,in_TransparentColor.xyz,in_TransparentColor.a);
	vec3 kD = vec3(1.0) - F;
	out_Diffuse  = Diffuse_Lambert( albedo.rgb ) * kD * newLightColor * NdotL;
	out_Specular = D * vis * F * newLightColor * NdotL;
	//out_Diffuse  = Diffuse_Lambert( albedo.rgb ) * kD * (in_LightColor * in_TransparentColor.xyz * 2.0) * NdotL;
	//out_Specular = D * vis * F * (in_LightColor * in_TransparentColor.xyz * 2.0) * NdotL;
}
#END_CODE
#END_DEFINE
