//////////////////////////////////////////////////////////////////////////////////////
//
//						The Bohge Engine License (BEL)
//
//	Copyright (c) 2011-2014 Peng Zhao
//
//	Permission is hereby granted, free of charge, to any person obtaining a copy
//	of this software and associated documentation files (the "Software"), to deal
//	in the Software without restriction, including without limitation the rights
//	to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
//	copies of the Software, and to permit persons to whom the Software is
//	furnished to do so, subject to the following conditions:
//
//	The above copyright notice and this permission notice shall be included in 
//	all copies or substantial portions of the Software. And the logo of 
//	Bohge Engine shall be displayed full screen for more than 3 seconds 
//	when the software is started. Copyright holders are allowed to develop 
//	game edit based on Bohge Engine, The edit must be released under the MIT 
//	open source license if it is going to be published. In no event shall 
//	copyright holders be prohibited from using any code of Bohge Engine 
//	to develop any other analogous game engines.
//
//	THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
//	IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
//	FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
//	AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
//	LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
//	OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
//
//////////////////////////////////////////////////////////////////////////////////////





#SHADER_DEFINE Texture2DSampling

	FUNCTION_INPUT = 
	{
		{ TEXTURE_DIFFUSE,		NONE,	TEXTURE2D,	"in_DiffuseTexture" },
		{ ATTRIBUTE_COORDNATE0,	MEDIUM,	VEC2,		"in_Coordinate" },
	}

	FUNCTION_OUTPUT = 
	{
		{ SURFACE_COLOR,	LOW,	VEC4,		"out_TextureColor" },
	}
	
#SHADER_CODE
    lowp vec4 out_TextureColor = texture2D( in_DiffuseTexture, in_Coordinate );
#END_CODE
#END_DEFINE


#SHADER_DEFINE CombineTexture2DSampling

	FUNCTION_INPUT = 
	{
		{ TEXTURE_DIFFUSE,		NONE,	TEXTURE2D,	"in_DiffuseTexture" },
		{ TEXTURE_OPACITY,		NONE,	TEXTURE2D,	"in_OpacityTexture" },
		{ ATTRIBUTE_COORDNATE0,	MEDIUM,	VEC2,		"in_Coordinate" },
	}

	FUNCTION_OUTPUT = 
	{
		{ SURFACE_COLOR,	LOW,	VEC4,		"out_TextureColor" },
	}
	
#SHADER_CODE
	lowp vec4 out_TextureColor;
	out_TextureColor.rgb = texture2D( in_DiffuseTexture, in_Coordinate ).rgb;
	out_TextureColor.a = texture2D( in_OpacityTexture, in_Coordinate ).r;
	//lowp vec4 out_TextureColor = vec4( in_Coordinate , 0.0, 1.0 );
#END_CODE
#END_DEFINE


#SHADER_DEFINE DepthMapSampling

	FUNCTION_INPUT = 
	{
		{ TEXTURE_SHADOW_DEPTH,		NONE,	TEXTURE2D,	"in_DepthMap" },
		{ LIGHTSPACE_COORD,	HIGH,	VEC4,		"in_LightVertexCoordinate" }
	}

	FUNCTION_OUTPUT = 
	{
		{ LIGHTSPACE_DEPTH,     HIGH, FLOAT,  "out_ShadowDepth"}
	}
	
#SHADER_CODE
	highp float out_ShadowDepth = texture2D( in_DepthMap, in_LightVertexCoordinate.xy ).z;
#END_CODE
#END_DEFINE

#SHADER_DEFINE DepthMapSamplingLinear

	FUNCTION_INPUT = 
	{
		{ TEXTURE_SHADOW_DEPTH,		NONE,	TEXTURE2D,	"in_DepthMap" },
		{ LIGHTSPACE_COORD,	HIGH,	VEC4,		"in_LightVertexCoordinate" },
		{ ATTRIBUTE_COORDNATE0,	MEDIUM,	VEC2,		"in_Coordinate" },
	}

	FUNCTION_OUTPUT = 
	{
		{ SURFACE_COLOR,				LOW,	VEC4,		"out_DepthVec" },
	}
	
#SHADER_CODE
	lowp vec4 out_DepthVec = texture2D( in_DepthMap, in_LightVertexCoordinate.xy );
#END_CODE
#END_DEFINE



#SHADER_DEFINE ReflectionTexture2DSampling

	FUNCTION_INPUT =
	{
		{ TEXTURE_REFLECTION,		NONE,	TEXTURE2D,	"in_ReflectionTexture" },
		{ ATTRIBUTE_COORDNATE0,	MEDIUM,	VEC2,		"in_Coordinate" },
	}

	FUNCTION_OUTPUT =
	{
		{ SURFACE_COLOR,	LOW,	VEC4,		"out_TextureColor" },
	}

	#SHADER_CODE
	lowp vec4 out_TextureColor = texture2D(in_ReflectionTexture, in_Coordinate);
	#END_CODE
	#END_DEFINE
	
 #SHADER_DEFINE TransparentMapSamplingLinear

	FUNCTION_INPUT = 
	{
		{ LIGHTSPACE_COORD,	HIGH,	VEC4,		"in_LightVertexCoordinate" },
		{ TEXTURE_TRANSPARENT_SHADOW,  NONE, TEXTURE2D, "in_TransparentMap"},
	}

	FUNCTION_OUTPUT = 
	{
		{ SHADOWMAP_COLOR,      HIGH, VEC4,   "out_TransparentColor"},
	}
	
#SHADER_CODE
	highp vec4  out_TransparentColor = texture2D( in_TransparentMap, in_LightVertexCoordinate.xy );
#END_CODE
#END_DEFINE


