#include "functions/blendmode.function"
#SHADER_DEFINE EyeBeautyQuadVertex

	FUNCTION_INPUT = 
	{
		{ ATTRIBUTE_POSITION, 		HIGH,	VEC4,	"in_Position" },
		{ ATTRIBUTE_COORDNATE0,     HIGH,   VEC2,   "in_TexCooridate"},
	}
	FUNCTION_OUTPUT =
	{
		{ ATTRIBUTE_COORDNATE0,     HIGH,    VEC2,       "out_TexCooridate" },
    { BASE_COORNIDATE,			    MEDIUM,	VEC2,		"Out_Coordinate2" },
	}

#SHADER_CODE
  gl_Position = vec4(in_Position.x,in_Position.y,0.0,1.0);
  vec2 out_TexCooridate = in_TexCooridate;
  //将顶点坐标转换为纹理坐标
  mediump float x = (in_Position.x + 1.0) / 2.0;
  mediump float y = 1.0 - (in_Position.y + 1.0) / 2.0;
  mediump vec2 Out_Coordinate2 = vec2(x,y);
#END_CODE
#END_DEFINE

#SHADER_DEFINE EyeBeautyQuadFragment

    FUNCTION_INPUT =
    {
        { TEXTURE_DIFFUSE,          NONE,    TEXTURE2D,  	"inputImageTexture" },
        { TEXTURE_BASE,             NONE,    TEXTURE2D,   "inputBaseTexture" },
        { TEXTURE_MASK,             NONE,    TEXTURE2D,   "inputMaskTexture" },
        { ATTRIBUTE_COORDNATE0,     HIGH,    VEC2,         	"textureCoordinate"},
        { BASE_COORNIDATE,			  MEDIUM,	VEC2,		"in_Coordinate2" },
        { BLEND_MODE,               HIGH,    FLOAT,         "blendMode"},
        { BLEND_OPACITY,            HIGHT,   FLOAT,         "opacity"},
        

    }

#SHADER_CODE
    vec4 texDiffuseColor = texture2D(inputImageTexture, textureCoordinate);
    vec4 baseColor = texture2D(inputBaseTexture,vec2(in_Coordinate2.x,1.0-in_Coordinate2.y));
    vec3 sourceRGB = vec3(texDiffuseColor.r,texDiffuseColor.g,texDiffuseColor.b);
    vec3 baseRGB = vec3(baseColor.r,baseColor.g,baseColor.b);

    vec4 maskColor = texture2D(inputMaskTexture, vec2(in_Coordinate2.x,1.0-in_Coordinate2.y));//fbo传入 y反向
    
    vec3 blendR = vec3(0.0,0.0,0.0);
    int iBlendMode = int(blendMode);  //转换成int类型
    
    if( opacity >= 1.0 ){
      blendR = blend( iBlendMode, baseRGB, sourceRGB );
    }else{
      blendR = blend( iBlendMode, baseRGB, sourceRGB, opacity );
    }
    
    gl_FragColor = vec4(blendR,texDiffuseColor.a*maskColor.r); 
	//gl_FragColor = vec4(maskColor.r,0.0,0.0,1.0);
#END_CODE
#END_DEFINE