//////////////////////////////////////////////////////////////////////////////////////
//
//						The Bohge Engine License (BEL)
//
//	Copyright (c) 2011-2014 Peng Zhao
//
//	Permission is hereby granted, free of charge, to any person obtaining a copy
//	of this software and associated documentation files (the "Software"), to deal
//	in the Software without restriction, including without limitation the rights
//	to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
//	copies of the Software, and to permit persons to whom the Software is
//	furnished to do so, subject to the following conditions:
//
//	The above copyright notice and this permission notice shall be included in 
//	all copies or substantial portions of the Software. And the logo of 
//	Bohge Engine shall be displayed full screen for more than 3 seconds 
//	when the software is started. Copyright holders are allowed to develop 
//	game edit based on Bohge Engine, The edit must be released under the MIT 
//	open source license if it is going to be published. In no event shall 
//	copyright holders be prohibited from using any code of Bohge Engine 
//	to develop any other analogous game engines.
//
//	THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
//	IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
//	FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
//	AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
//	LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
//	OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
//
//////////////////////////////////////////////////////////////////////////////////////





#SHADER_DEFINE EmitterColor

	FUNCTION_INPUT = 
	{
		{ ATTRIBUTE_EMITTER_COLOR,		MEDIUM,	VEC4,	"in_ParticleColor" },
    { BEZIER_OUTPUT,	LOW,	VEC4,		"in_Bezier" },
	}

	FUNCTION_OUTPUT = 
	{
		{ PARTICLE_COLOR,		MEDIUM,	VEC4,	"out_ParticleColor" },
	}

#SHADER_CODE
  vec4 out_ParticleColor = in_ParticleColor;
#END_CODE
#END_DEFINE

#SHADER_DEFINE BezierCurveColor

	FUNCTION_INPUT = 
	{
    { ATTRIBUTE_EMITTER_LIFE,	HIGH,	FLOAT,	"in_Life" },
		{ EMITTER_AGE,				    HIGH,	FLOAT,	"in_Age" },
    { BEZIER_COLOR_ONE,       LOW,  VEC4,   "in_control_color_1"},
    { BEZIER_COLOR_TWO,       LOW,  VEC4,   "in_control_color_2"},
    { BEZIER_COLOR_THREE,       LOW,  VEC4,   "in_control_color_3"},
    { BEZIER_COLOR_FOUR,       LOW,  VEC4,   "in_control_color_4"},
	}

	FUNCTION_OUTPUT = 
	{
    { PARTICLE_COLOR,		MEDIUM,	VEC4,	"out_ParticleColor" },
	}
	
#SHADER_CODE
    vec4 in_ControlColor1 = in_control_color_1;
    vec4 in_ControlColor2 = in_control_color_2;
    vec4 in_ControlColor3 = in_control_color_3;
    vec4 in_ControlColor4 = in_control_color_4;
    float ct = in_Age / in_Life;
    float ct2 = ct * ct;
    float one_minus_ct = 1.0 - ct;
    float one_minus_ct2 = one_minus_ct * one_minus_ct;
    vec4 out_ParticleColor = in_ControlColor1 * one_minus_ct2 * one_minus_ct + in_ControlColor2 * 3.0 * ct * one_minus_ct2 + in_ControlColor3 * 3.0 * ct2 * one_minus_ct + in_ControlColor4 * ct2 * ct;
#END_CODE
#END_DEFINE

#SHADER_DEFINE CosineCurveColor

	FUNCTION_INPUT = 
	{
    { ATTRIBUTE_EMITTER_LIFE,	HIGH,	FLOAT,	"in_Life" },
		{ EMITTER_AGE,				    HIGH,	FLOAT,	"in_Age" },
    { ATTRIBUTE_EMITTER_COLOR, HIGH, VEC4,   "in_color"},
    { COSINE_COLOR_PERIOD_COUNT,    LOW,  FLOAT,   "in_ColorPeriodCnt"},
	}

	FUNCTION_OUTPUT = 
	{
    { PARTICLE_COLOR,		MEDIUM,	VEC4,	"out_ParticleColor" },
	}
	
#SHADER_CODE

    float ct = in_Age / in_Life;
    vec4 out_ParticleColor = in_color * cos(ct * in_ColorPeriodCnt * 2.0 * 3.1415926);
    out_ParticleColor = (out_ParticleColor + 1.0) * 0.5;
#END_CODE
#END_DEFINE