#SHADER_DEFINE AddBlendFilterVertex

	FUNCTION_INPUT = 
	{
		{ ATTRIBUTE_POSITION, 			HIGH,	VEC4,		"in_Position" },
		{ ATTRIBUTE_COORDNATE0, 		HIGH,	VEC2,		"in_TexCooridate"},
	}
	FUNCTION_OUTPUT =
	{
		{ ATTRIBUTE_COORDNATE0,			HIGH,	VEC2,		"out_SceneCooridate" },
    { ATTRIBUTE_COORDNATE1,			HIGH,	VEC2,		"out_SceneCooridate2" },
	}

#SHADER_CODE
    gl_Position = in_Position;
    vec2 out_SceneCooridate = in_TexCooridate.xy;
    vec2 out_SceneCooridate2 = vec2(in_TexCooridate.x, 1.0 - in_TexCooridate.y);
#END_CODE
#END_DEFINE


#SHADER_DEFINE AddBlendFilterFragment  

	FUNCTION_INPUT = 
	{
		{ MIX_TEXTURE, 			  NONE,	TEXTURE2D,		"Tex"}, 
		{ TEXTURE_DIFFUSE,		NONE,	TEXTURE2D,		"uniCurrentTexture" },
		{ ATTRIBUTE_COORDNATE0, 		HIGH,	VEC2,		"out_SceneCooridate"},
    { ATTRIBUTE_COORDNATE1,			HIGH,	VEC2,		"out_SceneCooridate2" },
    { AlPHA,			HIGH,	FLOAT,		"alpha" },
  }

#SHADER_CODE

 
     vec4 textureColor = texture2D(uniCurrentTexture, out_SceneCooridate);  
     vec4 textureColor2 = texture2D(Tex, out_SceneCooridate2);
     gl_FragColor = vec4(mix(textureColor.rgb,textureColor2.rgb,alpha), textureColor.w);

#END_CODE
#END_DEFINE