local SequenceAnimation = require "apolloutility.sequenceanimation"
local basedetect = require "videodecet.basevideodetect";
local apollonode = require "apolloutility.apollonode"
local renderqueue = require "apolloutility.renderqueue"
local Faceinfo = require "videodecet.faceinfo";
local Actioninfo = require "videodecet.actioninfo";
local defiend = require "apolloutility.defiend"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local venuscore = require "venuscore"
local likeapp = require "likeapp"


local g_w = 184;
local g_h = 368;
local testvidesize = {184, 368}

local videodecet = {}
setmetatable(videodecet, basedetect);

function videodecet:Initialize(imagedoc, imagefile, pointfile)
  --新帧回调
  self.newframecallback = {}
  setmetatable(self.newframecallback, {__mode = "v"})

  apolloengine.ShaderEntity.POINT_COLOR = 
    apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,
      "POINT_COLOR");
    
  self.animation = SequenceAnimation(defiend.blit_material_path);
  renderqueue:Before(self.animation)
  self.animation:Play(imagedoc, imagefile, nil, 30, true, 1,true);
  
  local pr = apollonode.PointNode();
  pr:CreateResource(
    14,
    mathfunction.vector4(0,1,0,1),
    "comm:documents/material/pointrender.material");
  renderqueue:Before(pr);
  self.pointrender = pr;  
  
  
  
end


function videodecet:GetCurrentFrame()
  return  self.animation:GetCurrentTexture();
end

function videodecet:AddNewframeCallback(func)
  table.insert(self.newframecallback, func);
end

local function _toRelativeCoordinates(pixel_x, pixel_y)
  return pixel_x / 24 * 2 - 1, 1 - pixel_y / 46 * 2;
end

function videodecet:Update(def)
  local _, frame = self.animation:Update(def);
  if self.currentbodypoints~=nil then
    local pr = self.pointrender;
    local bodyvectors = {}
    for i=1, 14 do
      table.insert(bodyvectors, { _toRelativeCoordinates(self.currentbodypoints[i][1], self.currentbodypoints[i][2]) });
    end      
    pr:Update(bodyvectors);
  end
end

function videodecet:SetTexture(tex)
end

--得到当前的人脸信息
function videodecet:GetFaces()
  return nil;
end

function videodecet:UpdateKeypoints(idx,keypoint)
end

function videodecet:GetActions()
  return nil;
end

function videodecet:ActiveActions(actions)
  likeapp.AI:ActiveActions(actions)
end

function videodecet:SetBodyPoints(points)
  self.currentbodypoints = points;
end


function videodecet:GetBodyPoints()
  return self.currentbodypoints;
end

function videodecet:GetVideoSize()
  return testvidesize;
end

--得到当前的视屏纹理
function videodecet:GetVideoTexture()
  return self.animation:GetCurrentTexture();
end

return videodecet;