local SequenceAnimation = require "apolloutility.sequenceanimation"
local basedetect = require "videodecet.basevideodetect";
local apollonode = require "apolloutility.apollonode"
local renderqueue = require "apolloutility.renderqueue"
local Faceinfo = require "videodecet.faceinfo";
local Actioninfo = require "videodecet.actioninfo";
local defiend = require "apolloutility.defiend"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local faceseg = require "videodecet.faceseg"
local videocapture = require "videocapture"
local venuscore = require "venuscore"
local likeapp = require "likeapp"
--local mlsofa = require "mlsofa"
--local mlcnnseg = require "mlcnnseg"
local videodefined = require"videodecet.defined"
local vc = require "venuscore"
local cnnseg = require "videodecet.cnnseg"
local maxfacecount = 3;
local keypointcount = 106;
local videodecet = {}
local bitop = require "bit"
setmetatable(videodecet, basedetect);
  

function videodecet:TryOpenCamera()
  if not self.capture then
    self.capture = videocapture.AsyncVideoCapture();
    local resolution = apolloengine.Framework:GetResolution();
    self.capture:open(resolution, 0);
    if self.capture:isOpened() then
      return true;
    end
    ERROR("fail to open the camera!");
    return false;
  end
  return self.capture:isOpened();
end

function videodecet:Initialize(imagedoc, imagefile, pointfile)

  self.isShowDebugPoint = true ;

  -- 在加载完成贴纸时候,再设置到faceseg打开或者关闭检测项目
  self.stickerActions = {} ;

  --新帧回调
  self.newframecallback = {}
  setmetatable(self.newframecallback, {__mode = "v"})

  apolloengine.ShaderEntity.POINT_COLOR = 
    apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,
      "POINT_COLOR");
    
  self.yuv_ts = self.capture:read();
  local asize = self.yuv_ts:GetSize();
  self.size = {asize:x(), asize:y()};
  self.capturetexture = apolloengine.TextureEntity();
  self.capturetexture:PushMetadata(
    apolloengine.TextureBufferMetadata(
      apolloengine.TextureEntity.TU_WRITE,
      1, false,
      apolloengine.TextureEntity.TW_CLAMP_TO_EDGE,
      apolloengine.TextureEntity.TW_CLAMP_TO_EDGE,
      apolloengine.TextureEntity.TF_LINEAR,
      apolloengine.TextureEntity.TF_LINEAR,
      self.yuv_ts));
  self.capturetexture:CreateResource();
  apolloengine.DeviceResource:PushDeviceResource(
      apolloengine.DeviceResource.DEVICE_CAPTURE,
      self.capturetexture);
  self.render = apollonode.QuadNode();
  self.render:CreateResource(defiend.blit_material_path, false);
  self.render:SetParameter(
    apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
    self.capturetexture);

  renderqueue:Prev(self.render);

  self.actioninfos = {}
  self.pointrenders = {}  
  for i=1, maxfacecount do
    local pr = apollonode.PointNode();
    pr:CreateResource(
      keypointcount,
      mathfunction.vector4(0,1,0,1),
      "comm:documents/material/pointrender.material");
    pr:SetShow(false);
    renderqueue:Prev(pr);
    table.insert(self.pointrenders, pr);
  end
  self.cnnSegMark  =false;


end



function videodecet:ShowKeypoint(isshow)
  
end

function videodecet:SetCnnSegMark(mark)
  self.cnnSegMark = mark;
  cnnseg:SetCnnSegMark(mark);
end

function videodecet:AddNewframeCallback(func)
  table.insert(self.newframecallback, func);
end

function videodecet:_UpdateActions()


  if faceseg:GetSegmentMark(videodefined.detectType.HandClassify) then
    local handData = faceseg:GetSegKeypointArray(videodefined.detectType.HandClassify)
    if handData ~= nil and handData:Size() > 1 then -- Size==1 只有头部,代表没有有效手势
      local header  = handData:Get(1);
      local handNums = header:x();
      --LOG("handNums "..handNums)
      if( (handData:Size()-1) == handNums * 4 ) then

        local personID = 1

        for i = 2, handNums*4 , 4 do

          local actions = self.actioninfos[personID]; -- bvt不区分人 暂时把手势分布在各个人动作中
          if actions == nil then
            actions = {}
            table.insert(self.actioninfos, actions);
          end
          personID = personID + 1 ;


          local handinfo = handData:Get( i );
          local handId = handinfo:x();
          local handAction = handinfo:y();
          local handRectXY = handData:Get( i + 1 );
          local handRectWH  = handData:Get( i + 2 );
          local handCenterXY = handData:Get( i + 3 );


          local ai = Actioninfo(self.size);
          ai:PushActionID(handAction);
          ai:PushCenter( handCenterXY:x(), handCenterXY:y() );
          ai:PushRect( handRectXY:x(), handRectXY:y(), handRectXY:x()+handRectWH:x(), handRectXY:y()+handRectWH:y());
          table.insert(actions, ai);

        end
      else
        ERROR("Size Not Match handNums="..tostring(handNums).." handData="..tostring(handData:Size()))
      end
      --elseif handData ~= nil then
      --  WARNING("HandSize is  "..handData:Size() );
    end

  end
end

function videodecet:_UpdateLandmark()

  if faceseg:GetSegmentMark(videodefined.detectType.Face) then

    -- 人脸检测
    faceseg:GetSegKeypointArray(videodefined.detectType.Face)

    -- 整理数据
    local count = faceseg:GetCount(videodefined.detectType.Face,0);
    --LOG("_UpdateLandmark count "..tostring(count) );
    for i=1, count do
      local landmark = faceseg:GetData(
              videodefined.detectType.Face, i,
              videodefined.MLDataType.FACE_LANDMARK
      );
      local pry = faceseg:GetData(
              videodefined.detectType.Face, i,
              videodefined.MLDataType.FACE_ANGULAR
      );

      local forehead = faceseg:GetData(
              videodefined.detectType.Face, i,
              videodefined.MLDataType.FACE_FOREHEAD
      );

      local fi = Faceinfo(self.size);

      --更新人脸106点
      for j=1, #landmark, 2 do
        fi:PushKeypoint(landmark[j], landmark[j+1]);
      end
      --更新人头姿态
      fi:PushRotation(pry[1], pry[2], pry[3])
      table.insert(self.faces, fi);

      --更新额头关键点
      for j=1, #forehead, 2 do
        fi:PushForeheadLandmark(forehead[j], forehead[j+1]);
      end

      --更新人脸动态表情动作
      local actions = {}
      table.insert(self.actioninfos, actions);
      local rect = faceseg:GetData(
              videodefined.detectType.Face, i,
              videodefined.MLDataType.FACE_RECT
      );
      local rawarray = faceseg:GetData(
              videodefined.detectType.Face, i,
              videodefined.MLDataType.FACE_ACTION
      );
      for _, aid in ipairs(rawarray) do
        local ai = Actioninfo(self.size);
        ai:PushActionID(aid);
        ai:PushCenter((rect[1] + rect[3]) / 2, (rect[2] + rect[4]) / 2);
        ai:PushRect(rect[1], rect[2], rect[3], rect[4]);
        table.insert(actions, ai);
      end      
    end


  end
end


function videodecet:Update(def)
  if self.capture:hasNextFrame() then
    self.faces = {}
    self.actioninfos = {}
    self.yuv_ts = self.capture:read();

    self.capturetexture:ChangeTextureBuffer(self.yuv_ts);
    --self.sofa:Update(self.yuv_ts); -- ???


    faceseg:Initialize(self.size[1], self.size[2]);
    faceseg:Update(self.yuv_ts,def);

    -- 获取人脸点
    self:_UpdateLandmark();

    -- 如果需要手势分类 设置手势动作
    self:_UpdateActions();


    if self.faces and self.isShowDebugPoint then
      for i=1, #self.pointrenders do
        local pr = self.pointrenders[i];
        local fi = self.faces[i];
        if fi then
          pr:SetShow(true);
          pr:Update(fi:GetKeypointArray());
        else
          pr:SetShow(false);
        end
      end
    else
      for i=1, #self.pointrenders do
      local pr = self.pointrenders[i];
      pr:SetShow(false);
    end
    end

    for _, func in ipairs(self.newframecallback) do
      func();
    end
    return true;
  end
  return false;
end

function videodecet:SetTexture(tex)
end

--得到当前的人脸信息
function videodecet:GetFaces()
  return self.faces;
end

function videodecet:GetPixelFacekeypointArray()
  local keypointarray = mathfunction.vector2array();
  local count = faceseg:GetCount(videodefined.detectType.Face,0);
  for i=1, count do
    local landmark = faceseg:GetData(
            videodefined.detectType.Face, i,
            videodefined.MLDataType.FACE_LANDMARK
    );
    for j=1, #landmark, 2 do
      keypointarray:PushBack(mathfunction.vector2(landmark[j], landmark[j+1]));
    end
  end
  return keypointarray;
end

--得到当前的视屏纹理
function videodecet:GetVideoTexture()
  return self.capturetexture;
end



function videodecet:ActiveActions(actions)
  LOG("actions " .. #actions )
  for _ , value in pairs(actions) do
    LOG("value ".. tostring(value) )
    table.insert(self.stickerActions,value)
  end
end

--加载玩素材之后 根据素材的配置 启动相关检测
function videodecet:launchDetectFlag()

  local actions = self.stickerActions ;



    LOG("actions "..#actions);
    local newAction = {}
    for key, value in pairs(actions) do
      local handDetectFlag = bitop.band(value,videodefined.handActionType) ;
      local faceDynamicExpressDetectFlag = bitop.band(value,videodefined.faceDynamicExpressType)
      LOG("value = "..value..", hand = "..handDetectFlag..", face = "..faceDynamicExpressDetectFlag );
      if handDetectFlag ~= 0 then
        LOG("Hand Detect ON");
        faceseg:SetSegMark(videodefined.detectType.HandClassify,true);
      elseif faceDynamicExpressDetectFlag ~= 0 then
        LOG("Face Detect ON");
        faceseg:SetSegMark(videodefined.detectType.Face,true);
      else --过滤掉所有的手势动作
        table.insert(newAction,value);
      end
    end

    if #newAction ~= 0 then
      --likeapp.AI:ActiveActions(newAction);
      ERROR("ActiveActions actions lost ");
    else
      WARNING("ActiveActions actions filter none callback");
    end



end


--释放素材时候 清理所有的检测标记
function videodecet:resetDetectFlag()
  self.stickerActions = {} ;
  faceseg:SetSegMark(videodefined.detectType.HandClassify,false);
  faceseg:SetSegMark(videodefined.detectType.Face,false);
end


function videodecet:GetActions()
  return self.actioninfos;
end

function videodecet:SetShow(isShow)
  --if self.isShowBaseVideo ~= isShow then
  --  self.isShowBaseVideo = isShow;
  --  self.node:SetShow(isShow);
  --end
end


function videodecet:SetDebugPointShow(isShow)
  self.isShowDebugPoint = isShow ;
end

function videodecet:GetVideoSize()
  return self.size;
end

function videodecet:GetVideoFrame()
  return self.yuv_ts;
end

function videodecet:PushNewFaceLandMark()
  local newFaceLandMarks = {};
  local index = 1 ;
  local faces = self:GetFaces();
  for _, face in pairs(faces) do
    local keypointArray = face:GetKeypointArray();
    for _, one in pairs(keypointArray) do
      local x, y = face:toAbsoluteCoordinates(one);
      newFaceLandMarks[index]   = x;
      newFaceLandMarks[index+1] = y;
      index = index + 2 ;
    end
  end
  likeapp.AI:PushNewFaceLandMark(newFaceLandMarks);
end

return videodecet;
