
local cnnsegcls=nil;
if _PLATFORM_WINDOWS then
  cnnsegcls= require"videodecet.androidcnnseg" 
elseif _PLATFORM_ANDROID then
  cnnsegcls =  require"videodecet.androidcnnseg"
elseif _PLATFORM_IOS then
  cnnsegcls =  require"videodecet.androidcnnseg"
end

local cnnseg={}
local cnnsegment=cnnsegcls();
local servicecallbacks = {};
local serviceobjs={};
setmetatable(servicecallbacks, {__mode = "v"}) --弱引用 
setmetatable(serviceobjs, {__mode = "v"}) --弱引用 
cnnseg.cnnsegmark = false;
function cnnseg:RegisterCnnSegJudgeFunc(obj,func)
  table.insert(servicecallbacks,func);
  table.insert(serviceobjs,obj);
end

function cnnseg:Initialize(w,h)
    
  if(not self.cnnsegmark)
  then
    return;
  end
  --cnnsegment.cnnSegMark = true;
  if (cnnsegment.cnnsegInit == false) 
  then
     cnnsegment:InitCnnSeg(w, h);
  end
    
end


function cnnseg:IsInitialize()
  return cnnsegment.cnnsegInit;
end

function cnnseg:SetCnnSegMark(mark)
   self.cnnsegmark = mark;
   cnnsegment.cnnSegMark = mark;
end


function cnnseg:GetSegmentMark(mark)
  
   if(self.cnnsegmark==nil)
   then
     return false;
   else
     return self.cnnsegmark;
   end
 
end

function cnnseg:Update(ts,def)

  if(not self.cnnsegmark)
  then
    return;
  end
  self.ts = ts;
  self.def =def;
  cnnsegment:startNewUpdate();
end

function cnnseg:OnResizeView(w,h)
  
 --[[ if(not self.cnnsegmark)
  then
    return;
  end]]
  cnnsegment:OnResizeView(w,h);
end


function cnnseg:RunSeg()
  
  if(not self.cnnsegmark)
  then
    return;
  end
  
  local len =#servicecallbacks;
  local res = false;
  for i=1,len do
    --if(servicecallbacks[i].NeedBackGroundSplit)
    if(servicecallbacks[i] and serviceobjs[i] )
    then
     -- res=servicecallbacks[i]:NeedBackGroundSplit();
     res =servicecallbacks[i](serviceobjs[i]);
    end
    if(res==true)
    then
      break;
    end
  end
  if(res==true)
  then
    cnnsegment:startNewUpdate();
    self:GetSegTexture();
  end
  
end

function cnnseg:GetSegTexture()
  
  if(not self.cnnsegmark)
  then
    return nil;
  end
  
  if (cnnsegment.cnnsegInit == true) 
  then
    local ts = self.ts;
    local def = self.def;
    local cnnsegtexture = cnnsegment:Update(ts,def);
    return cnnsegtexture;
  end
  return nil;
  
end

return cnnseg;