local SequenceAnimation = require "apolloutility.sequenceanimation"
local ImageService = require "apolloutility.texturereader"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local stringsplit = require "stringsplit"
local venuscore = require "venuscore"
local Object = require "classic"


local actioninfo = Object:extend();

local function _toRelativeCoordinates(res, pixel_x, pixel_y)
  return pixel_x / res[1] * 2 - 1, (res[2] - pixel_y) / res[2] * 2 - 1;
end

function actioninfo:new(vidoesize)
  self.size = vidoesize;
  self.actionid = 0;
end

function actioninfo:PushActionID(id)
  self.actionid = id;
end

function actioninfo:PushCenter(pixel_x, pixel_y)
  local x,y = _toRelativeCoordinates(self.size, pixel_x, pixel_y);
  self.center = {x,y};
end

function actioninfo:PushRect(pixel_left,pixel_top,pixel_right,pixel_bottom)
  local l,t = _toRelativeCoordinates(self.size, pixel_left,pixel_top);
  local r,b = _toRelativeCoordinates(self.size, pixel_right,pixel_bottom);
  self.rect = {l,t,r,b};
end

function actioninfo:GetRect()
  return self.rect;
end

function actioninfo:GetCenter()
  return self.center;
end

function actioninfo:GetActionID()
  return self.actionid;
end


return actioninfo;