local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local venuscore = require "venuscore"
require "venusdebug"
require "utility"
local venusjson = require "venusjson"
local beholder = require "superme3d.observer"
local defined = require "superme3d.defined"
local SkeletonLoader = require "superme3d.model.skeletonloader"
local MeshLoader = require "superme3d.model.meshloader"
local NodeManager = require "superme3d.model.nodemanager"
local MaterialManager = require "superme3d.model.materialmanager"
local BackgrondLoader = require "superme3d.background.backgroundloader"

local superme3D = {}

function superme3D:Initialize(maincamera)
  --初始化时加载默认部件
  self:LoadDefaultUnit();
  beholder.trigger(defined.Event.ON_INITIALIZE); 
end

--加载默认部件
function superme3D:LoadDefaultUnit()
  --1. 加载一个默认的光溜溜的模型
  --2. 加载一套默认骨骼和所有的动画
  --[[
  local defaultMesh = defined.DefaultMesh;
  if defaultMesh then
    self:LoadResource(defaultMesh .. "/config.json");
  end
  --]]
  --local defaultSkeleton = defined.DefaultSkeleton;
  --if defaultSkeleton then
    --self:_LoadSkeleton(defaultSkeleton .. "/config.json");
  --end

end


--每次加载模型
function superme3D:LoadResource(resourcePath)
  local res = true;
  local pathDir= string.match(resourcePath, "(.+)/[^/]*%.%w+$");
  venuscore.IFileSystem:SetResourcePath(pathDir .. "/"); --设置资源目录
  local config = venusjson.LaodJsonFile(resourcePath);
  local s3d = config.Superme3D;
  local version = s3d.Version;
  beholder.trigger(defined.Event.ON_RESOURCE_VERSION,version); --传递版本号
  
  --本素材所包含的所有mesh
  local modelItemList = s3d.Items;
  if modelItemList then
    local modelItemListCnt = #modelItemList;
    for i = 1, modelItemListCnt do
      local modelItem = modelItemList[i];
      beholder.trigger(defined.Event.ON_RESOURCE_MODEL_ITEM,modelItem); --传递一个部件
    end
  end
  if res == false then  --如果加载失败了，把自己卸载掉
    self:ReleaseResource();
  end
  
  return res;
end

function superme3D:LoadBackground(resourcePath)
  local res = true;
  local pathDir= string.match(resourcePath, "(.+)/[^/]*%.%w+$");
  venuscore.IFileSystem:SetResourcePath(pathDir .. "/"); --设置资源目录
  local config = venusjson.LaodJsonFile(resourcePath);
  local s3d = config.Superme3D;
  local version = s3d.Version;
  beholder.trigger(defined.Event.ON_RESOURCE_VERSION,version); --传递版本号
  
  local background = s3d.Background;
  if background then
    beholder.trigger(defined.Event.ON_RESOURCE_BACKGROUND,background);
  end
  
  return res;
  
end

function superme3D:LoadSkeleton(needIK)
    local defaultSkeleton = defined.DefaultSkeleton;
    if defaultSkeleton then
      self:_LoadSkeleton(defaultSkeleton .. "/config.json",needIK);
    end
end

function superme3D:_LoadSkeleton(resourcePath,needIK)
  local res = true;
  local pathDir= string.match(resourcePath, "(.+)/[^/]*%.%w+$");
  beholder.trigger(defined.Event.ON_RESOURCE_ROOTPATH,pathDir);--传递资源根目录
  local config = venusjson.LaodJsonFile(resourcePath);
  local s3d = config.Superme3D;
  local version = s3d.Version;
  beholder.trigger(defined.Event.ON_RESOURCE_VERSION,version); --传递版本号
  local skeletonConfig = s3d.Skeleton;
  beholder.trigger(defined.Event.ON_RESOURCE_SKELETON,skeletonConfig,needIK);
  return true;
end

function superme3D:Update(def,pos3d)
  beholder.trigger(defined.Event.ON_UPDATE,{def,pos3d});
end


function superme3D:ReleaseResource()
  beholder.trigger(defined.Event.ON_RELEASE_RESOURCE); --释放资源
  beholder.reset();
  collectgarbage();
end

function superme3D:GetNodeMgr()
 return NodeManager;
end

return superme3D;