
local apollonode = require "apolloutility.apollonode"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"


local SkinedRenderNode = apollonode.TransNode:extend();

function SkinedRenderNode:new()
  self.isShow = nil;
  self.subNodes = {};
  self.skinComponents = {};
  SkinedRenderNode.super.new(self);
end

function SkinedRenderNode:AttachNode(node)
  table.insert(self.subNodes,node);
  SkinedRenderNode.super.AttachNode(self,node);
end

function SkinedRenderNode:SetSkeleton(skeletonNodeInfo)
  for i = 1, #self.subNodes do
    local meshNode = self.subNodes[i];
    local skinCom = meshNode:CreateComponent(apolloengine.Node.CT_SKIN);
    skinCom:SetHasScale(skeletonNodeInfo[1]);
    skinCom:SetSkeletonComponent(skeletonNodeInfo[2].skeleton);
    table.insert(self.skinComponents,skinCom);
  end
end


function SkinedRenderNode:SetShow(isShow)
  local nodeCnt = #self.subNodes;
  for i = 1, nodeCnt do
    local node = self.subNodes[i];
    node:SetShow(isShow);
  end
end

function SkinedRenderNode:SetLocalScale()
  local nodeCnt = #self.subNodes;
  for i = 1, nodeCnt do
    local node = self.subNodes[i];
    --node:SetLocalScale(mathfunction.vector3(0.1,0.1,0.1));
  end
end



function SkinedRenderNode:Update(def)
  local nodesCnt = #self.subNodes;
  for i = 1, nodesCnt do
    local meshNode = self.subNodes[i];
    meshNode:Update(def);
  end
  
  
end

return SkinedRenderNode;