local apolloengine = require "apolloengine"
local venuscore = require "venuscore"
local venusjson = require "venusjson"
local mathfunction = require "mathfunction"
local defined = require "superme3d.defined"
local beholder = require "superme3d.observer"
local utility = require "superme3d.utility"
local meshnode = require "superme3d.model.meshnode"
local apollonode = require "apolloutility.apollonode"
local skeletonnode = require "superme3d.model.skeletonnode"
local Object = require "classic"



local SkeletonLoader = {}


--加载mesh
function SkeletonLoader:Initialize()
  self.rootPath = nil;
  self.modelPathList = nil;
  self.OnParseRootPathEvent = nil;
  self.OnParseSkeleton = nil;
  self.OnReleaseResourceEvent = nil;
  
  --注册监听事件
  self:RegisterEvents();

end

function SkeletonLoader:RegisterEvents()
  self.OnParseResourceRootPathEvent = utility:CreateInovation(self,self.ParseRootpath);
  self.OnParseSkeleton = utility:CreateInovation(self,self.ParseSkeleton);
  self.OnReleaseResourceEvent = utility:CreateInovation(self,self.ReleaseResource);
  
  beholder.observe(defined.Event.ON_RESOURCE_ROOTPATH,self.OnParseResourceRootPathEvent);
  beholder.observe(defined.Event.ON_RESOURCE_SKELETON,self.OnParseSkeleton);
  beholder.observe(defined.Event.ON_RELEASE_RESOURCE,self.OnReleaseResourceEvent);
end

function SkeletonLoader:ParseRootpath(rootPath)
  self.rootPath = rootPath;
end

--得到骨骼路径
function SkeletonLoader:_GetSkeletonPath(nameConfig)
  local skeletonPath = self.rootPath .. "/" .. nameConfig;
  return skeletonPath;
end

function SkeletonLoader:_GetSkeletonType(typeConfig)
  local skeletonType = typeConfig.hasscale and 0 or 1;
  return skeletonType;
end

function SkeletonLoader:_GetAnimationList(animationConfig)
  local animationCnt = #animationConfig;
  local animationList = {};
  for i = 1, animationCnt do
    local animationInfo = animationConfig[i];
    local animationName = animationInfo.name;
    local frameCnt = animationInfo.framecount;
    local animationPath = self.rootPath .. "/" .. animationName;
    table.insert(animationList,{animationPath,frameCnt});
  end
  return animationList;
end

function SkeletonLoader:ParseSkeleton(skeletonConfig,needIK)
  if skeletonConfig then
    local nameConfig = skeletonConfig.name;
    local typeConfig = skeletonConfig.scale;
    --local animationConfig = skeletonConfig.animation;
    
    local skeletonPath = self:_GetSkeletonPath(nameConfig);
    local skeletonType = self:_GetSkeletonType(typeConfig);
    --local animationList = self:_GetAnimationList(animationConfig);
    local bonenames = skeletonConfig.bonenames;
    local twistnames = skeletonConfig.twistnames;

    local ikcfg = nil;
    if needIK then
      ikcfg = skeletonConfig.ikconfig
    end
    
    self:LoadSkeleton(skeletonPath,skeletonType,bonenames,twistnames,ikcfg );
      --,animationList
  end
end

--[[
function SkeletonLoader:OnParseSkeleton(skeletonConfig)
  if skeletonConfig then
    local modelIndex = skeletonConfig.ModelIndex;
    local modelPath = self.modelPathList[modelIndex];
    if modelPath == nil then
      ERROR("Model Index error!");
    else
      local skeletonName = skeletonConfig.SkeletonName;
      local skeletonTypeStr = skeletonConfig.SkeletonType;
      local animationInfoList = skeletonConfig.Animiation;
      local skeletonFullPath = self:_GetSkeletonPath(modelPath,skeletonName);
      local skeletonType = self:_GetSkeletonType(skeletonTypeStr);
      local animationList = self:_GetAnimationList(animationInfoList);
      
      self:LoadSkeleton(skeletonFullPath,skeletonType,animationList);
    end
  end
end
]]--

function SkeletonLoader:LoadSkeleton(skeletonPath, skeletonType,bonenames,twistnames,ikconfig)
    --, animationList
   
  if skeletonPath then
    local skeletonNode = skeletonnode();
    skeletonNode:SetPoseEstimateBoneNames(bonenames)
    skeletonNode:SetBoneTwist(twistnames)
    skeletonNode:CreateResource(skeletonPath,skeletonType,nil,{});
    skeletonNode:Stop();  --默认不播放动画
    skeletonNode:SetLoop(true);  --循环播放
    
    if ikconfig == nil then            
      skeletonNode:BindPose();
    end
    
    local skeletonNode2 = nil;
    local eventData = {}
    if ikconfig then
      for i=1,#ikconfig.ikjoints do
         skeletonNode:CreateJoint(ikconfig.ikjoints[i][1], ikconfig.ikjoints[i][2],ikconfig.ikjoints[i][3],ikconfig.ikjoints[i][4],ikconfig.ikjoints[i][5], ikconfig.ikjoints[i][6], ikconfig.ikjoints[i][7], false);  
      end
      
      for i=1,#ikconfig.ikeffectors do
        skeletonNode:CreateEffector(ikconfig.ikeffectors[i]);
      end
      
      for i=1,#ikconfig.ikroots do
        skeletonNode:SetRootJoint(ikconfig.ikroots[i]);
      end
      
      for i=1, #ikconfig.iklink do
        skeletonNode:LinkJoints(ikconfig.iklink[i][1],  ikconfig.iklink[i][2]);
      end
  
      skeletonNode:BuildKinematics();
    
      skeletonNode2 = skeletonnode();
      skeletonNode2:SetPoseEstimateBoneNames(bonenames)
      skeletonNode2:SetBoneTwist(twistnames)
      skeletonNode2:CreateResource(skeletonPath,skeletonType,nil,{});
      skeletonNode2:Stop();  --默认不播放动画
      skeletonNode2:SetLoop(true);  --循环播放
      skeletonNode2:BindPose();
      
    end
    
    eventData = {skeletonType == 0 and true or false, skeletonNode,skeletonNode2};
    beholder.trigger(defined.Event.ON_CREATE_SKELETON_FINISHED,eventData);
  end
end


function SkeletonLoader:ReleaseResource()
  self.rootPath = nil;
  self.modelPathList = nil;
  self.OnParseRootPathEvent = nil;
  self.OnParseModelPathListEvent = nil;
  self.OnParseSkeleton = nil;
  self.OnReleaseResourceEvent = nil;
end


SkeletonLoader:Initialize();

return SkeletonLoader;


