local apollonode = require "apolloutility.apollonode"
local apolloengine = require "apolloengine"
local venuscore = require "venuscore"
local mathfunction = require "mathfunction"
local defined = require "superme3d.defined"
local beholder = require "superme3d.observer"
local utility = require "superme3d.utility"
local Object = require "classic"


local MaterialManager = {}

--增加脚本路径
function MaterialManager:_AddScriptPath(pathDir)
  
  --local gamepath = venuscore.IFileSystem:PathAssembly("root:lightgame");
  --gamepath = (gamepath.."/?.lua;")..(gamepath.."/?/?.lua;")..(gamepath.."/?/init.lua;");
  --gamepath ="E:/faceDeformationDev/master/algo_video_facecute/lightgame/sticker/..";
  --gamepath = (gamepath.."/?.lua;");
  self.originPackagePath = package.path;
  local gamepath=venuscore.IFileSystem:PathAssembly(pathDir);
  gamepath=gamepath.."/?.lua;";
  package.path =gamepath.. package.path;
end

--删除脚本路径
function MaterialManager:_RemoveScriptPath()  
  if self.originPackagePath then
    package.path = self.originPackagePath;
  end    
end

function MaterialManager:Initialize()
  self.rootPath = nil;
  self.modelPathList = nil;

  --注册监听事件
  self:RegisterEvents();
end

function MaterialManager:RegisterEvents()
  self.OnParseResourceRootPathEvent = utility:CreateInovation(self,self.ParseRootpath);
  self.OnParseModelPathListEvent = utility:CreateInovation(self,self.ParseModelPathList);
  self.OnCreateMaterialEvent = utility:CreateInovation(self,self.AssignMaterial);

  beholder.observe(defined.Event.ON_RESOURCE_ROOTPATH,self.OnParseResourceRootPathEvent);
  beholder.observe(defined.Event.ON_RESOURCE_MODEL_LIST,self.OnParseModelPathListEvent);
  beholder.observe(defined.Event.ON_CREATE_MATERIAL,self.OnCreateMaterialEvent);
end

function MaterialManager:ParseRootpath(rootPath)
  self.rootPath = rootPath;
end

function MaterialManager:ParseModelPathList(modelPathList)
  self.modelPathList = modelPathList;
end

function MaterialManager:GetMaterialPath(materialtype)
  local materialPath = defined.Materials[materialtype];
  if materialPath == nil then
    materialPath = defined.Materials["Simple"];  --默认采用Smple材质
  end
  --for test
  materialPath = defined.Materials["Default"];
  return materialPath;
end

function MaterialManager:GetMaterialCreator(materialType)
  local creator = defined.Materials[materialType];
  if creator == nil then
    creator = defined.Materials["Default"];  --默认采用Smple材质
  end
  return creator;
end


function MaterialManager:SetupTexture(meshnode,textureList)
  local textureListCnt = #textureList;
  for i = 1, textureListCnt do
    local textureUnit = textureList[i];
    local slotName = textureUnit.Slot;
    local slotValue = textureUnit.Name;
    local wrapMode = apolloengine.TextureEntity.TW_REPEAT;
    if textureUnit.Wrap~=nil then wrapMode = textureUnit.Wrap end
      
    local ps = apolloengine.IMaterialSystem:GetParameterSlot(slotName);
    if ps == apolloengine.ShaderEntity.SLOT_ERROR then  --需要创建slot
      ps = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,slotName);
    end
    --得到纹理路径
    local texturePath = venuscore.IFileSystem:PathAssembly("ress:" .. slotValue);
    if textureUnit.Mipmap then      
      meshnode:PushTextureMetadataUsingMipmap(ps,texturePath,wrapMode);
    else
      meshnode:PushTextureMetadata(ps,texturePath,wrapMode);
    end
  end
end


function MaterialManager:SetupUniform(meshNode,uniformList)
  local uniformListCnt = #uniformList;
  for i = 1, uniformListCnt do
    local uniformUnit = uniformList[i];
    local slotName = uniformUnit.Slot;
    local slotValue = uniformUnit.Value;
    --处理数据类型
    local apoloValue = nil;
    local valueCompomentCnt = #slotValue;
    if valueCompomentCnt == 1 then
      apoloValue = mathfunction.vector1(slotValue[1]);
    elseif valueCompomentCnt == 2 then
      apoloValue = mathfunction.vector2(slotValue[1],slotValue[2]);
    elseif valueCompomentCnt == 3 then
      apoloValue = mathfunction.vector3(slotValue[1],slotValue[2],slotValue[3]);
    elseif valueCompomentCnt == 4 then
      apoloValue = mathfunction.vector4(slotValue[1],slotValue[2],slotValue[3],slotValue[4]);
    end
    local ps = apolloengine.IMaterialSystem:GetParameterSlot(slotName);
    if ps == apolloengine.ShaderEntity.SLOT_ERROR then  --需要创建slot
      ps = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,slotName);
    end
    meshNode:SetupUniforms(ps,apoloValue);
  end
end


--赋值材质
function MaterialManager:AssignMaterial(nodeMaterial)
  local meshNode = nodeMaterial[1];
  local materialInfo = nodeMaterial[2];
  
  local materialType = materialInfo.Type;
  local materialCreatorScript = self:GetMaterialCreator(materialType);  
  local materialPath = self:GetMaterialPath(materialType); --得到材质文件路径
  local textureList = materialInfo.Textures;  --需要用到的纹理
  local uniformList = materialInfo.Uniforms;  --需要用到的uniform
  
 -- if materialInfo.Transparent then
  --  meshNode : SetShadowCaster(false);
 -- end
  --调用外面创建材质的脚本
  local func,errorstr = loadfile(venuscore.IFileSystem:PathAssembly(materialCreatorScript));
  if not errorstr then
    local materialCreator = func();
    materialCreator:SetupMaterial(meshNode);
  end
  
  --允许外部设置Uniform
  if textureList ~= nil then
    self:SetupTexture(meshNode,textureList);
  end
  if uniformList ~= nil then
    self:SetupUniform(meshNode,uniformList);
  end
end



function MaterialManager:ReleaseResource()
  self.rootPath = nil;
  self.modelPathList = nil;
end

MaterialManager:Initialize();

return MaterialManager;


