local apolloengine = require "apolloengine"
local venuscore = require "venuscore"
local venusjson = require "venusjson"
local mathfunction = require "mathfunction"
local defined = require "superme3d.defined"
local beholder = require "superme3d.observer"
local utility = require "superme3d.utility"
local meshnode = require "superme3d.model.meshnode"
local bulletnode = require "superme3d.model.bulletnode"
local apollonode = require "apolloutility.apollonode"
local Object = require "classic"



local Bulletloader = {}


function Bulletloader:RegisterEvents()
	self.OnCreatePhysicsEvent = utility:CreateInovation(self,self.LoadPhysics);
	self.OnParseResourceRootPathEvent = utility:CreateInovation(self,self.ParseRootpath);

	beholder.observe(defined.Event.ON_CREATE_PHYSICS,self.OnCreatePhysicsEvent);
	beholder.observe(defined.Event.ON_RESOURCE_ROOTPATH,self.OnParseResourceRootPathEvent);  
end


function Bulletloader:Initialize()
	self:RegisterEvents();
end

function Bulletloader:ParseRootpath(rootPath)
	self.rootPath = rootPath;
end

function Bulletloader:_GetBUlletPath(nameConfig)
	local bulletPath = self.rootPath .. "/" .. nameConfig;
	return bulletPath;
end


function Bulletloader:LoadPhysics(bulletConfig, mesh)
	if bulletConfig then 
		local bulletPath = self:_GetBUlletPath(bulletConfig);
		local node = bulletnode();
		node:Initialize(bulletPath, mesh);
		beholder.trigger(defined.Event.ON_CREATE_BULLET_FINISHED,node);
	end
end



Bulletloader:Initialize();

return Bulletloader;


