local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local venuscore = require "venuscore"
local Object = require "classic"
local pupildefined = require "pupil.pupildefined"


local PupilRender = Object:extend();

function PupilRender:new(maxpontcount)
  self.node = apolloengine.Node();
  self.render = self.node:CreateComponent(apolloengine.Node.CT_RENDER);
  self.vertexstream = apolloengine.VertexStream();

  self.vertexstream:SetVertexType(apolloengine.ShaderEntity.ATTRIBUTE_POSITION,
    apolloengine.VertexBufferEntity.DT_FLOAT,
    apolloengine.VertexBufferEntity.DT_HALF_FLOAT,4);
   self.vertexstream:SetVertexType(apolloengine.ShaderEntity.ATTRIBUTE_COORDNATE0,
		apolloengine.VertexBufferEntity.DT_FLOAT,
		apolloengine.VertexBufferEntity.DT_HALF_FLOAT,
		2);
  self.vertexstream:ReserveBuffer(maxpontcount * 3);
  
  self.indexstream = apolloengine.IndicesStream(); 
  self.indexstream:SetIndicesType(apolloengine.IndicesBufferEntity.IT_UINT16);
  self.indexstream:ReserveBuffer(maxpontcount * 3);
 
 
  --顶点数据
  for i=1, maxpontcount * 3 do
    self.vertexstream:PushVertexData(apolloengine.ShaderEntity.ATTRIBUTE_POSITION, mathfunction.vector4(0,0,0,0));
    self.vertexstream:PushVertexData(apolloengine.ShaderEntity.ATTRIBUTE_COORDNATE0,mathfunction.vector2(0.0,0.0));
    self.indexstream:PushIndicesData(i - 1);
  end  

  
  --材质元数据
  --self:SetupMaterial(alphamode);
  --self.render:PushMetadata(
  --  apolloengine.RenderObjectMaterialMetadata(
  --    apolloengine.PathMetadata(material)));
  
  --顶点流元数据
  self.render:PushMetadata(
		apolloengine.RenderObjectMeshMetadate( 
			apolloengine.RenderComponent.RM_TRIANGLES,
      --apolloengine.RenderComponent.RM_POINTS,
      apolloengine.ReferenceVertexMetadata(        
        apolloengine.VertexBufferEntity.MU_DYNAMIC,--使用可以修改的显存区域
        self.vertexstream),
      apolloengine.ReferenceIndicesMetadata(
        apolloengine.VertexBufferEntity.MU_STATIC,--使用不可修改的显存区域
        self.indexstream)));
  --self.render:CreateResource();
end

function PupilRender:SetupMaterial(alphamode)

  local vertexShaderParts = {"QuadPositionShader","Base2DCoordinate","VertexOutput"};
  local fragmentShaderParts = {"Texture2DSampling","FragmentOutput"};
  local material_begin = string.format(pupildefined.pupil_material_begin, alphamode or pupildefined.defualt_alpha_mode);
    
  local materialsrc = material_begin .. "\nVERTEX_SHADER = {\n";
  for _,  vertexpart in pairs(vertexShaderParts) do
    materialsrc = materialsrc .. "\"" .. vertexpart .. "\",\n";
  end
  materialsrc = materialsrc .. "}\n";
  materialsrc = materialsrc .. "FRAGMENT_SHADER = {\n";
  for _, fragmentpart in pairs(fragmentShaderParts) do
    materialsrc = materialsrc .. "\"" .. fragmentpart .. "\",\n";
  end
  materialsrc = materialsrc .. "}\n";
  materialsrc = materialsrc .. pupildefined.pupil_material_end;
    
  self.render:PushMetadata(
    apolloengine.RenderObjectMaterialMetadata(
      apolloengine.StringBufferMetadata(materialsrc)));
  self.render:CreateResource();
end


function PupilRender:SetShow(isshow)
  if isshow then
    self.render:SetRenderProperty(apolloengine.RenderComponent.RP_SHOW);
  else
    self.render:EraseRenderProperty(apolloengine.RenderComponent.RP_SHOW);
  end  
end

function PupilRender:SetSequence(s)
  self.render:SetSequence(s);
end

function PupilRender:SetParameter(slot,value)
  self.render:SetParameter(slot,value);
end


--更新顶点流
function PupilRender:Update(points)
  local vertexarray,texcoordarray = self:MakeTriangelArray(points);
  local newpoint =  mathfunction.vector4(0, 0, 0, 1);
  local newtex = mathfunction.vector2(0,0);
  local index_vertex = self.vertexstream:GetAttributeIndex(apolloengine.ShaderEntity.ATTRIBUTE_POSITION);
  local index_tex = self.vertexstream:GetAttributeIndex(apolloengine.ShaderEntity.ATTRIBUTE_COORDNATE0);
  for i=1, #vertexarray do
    local point = vertexarray[i];
    local tex = texcoordarray[i];
    newpoint:Set(point[1], point[2], 0, 1);
    newtex:Set(tex[1],tex[2]);
    self.vertexstream:ChangeVertexDataWithAttributeFast(
      index_vertex,
      i,
      newpoint);
    self.vertexstream:ChangeVertexDataWithAttributeFast(
      index_tex,
      i,
      newtex);
  end
  self.vertexstream:SetReflushInterval(1, #vertexarray);
  self.render:ChangeVertexBuffer(self.vertexstream);
  self.render:SetDrawCount(#vertexarray);
end

function PupilRender:MakeTriangelArray(pointarray)
  local vertexarray = {};
  local texcoordarray = {};
  local minx = 10000;
  local maxx = -10000;
  local miny = 10000;
  local maxy = -10000;
  
  --顶点坐标
  local cnt = #pointarray - 1;  --三角形个数
  for i = 1,cnt do
    local point = pointarray[i];
    if minx > point[1] then
      minx = point[1];
    end
    if maxx < point[1] then
      maxx = point[1];
    end
    if miny > point[2] then
      miny = point[2];
    end
    if maxy < point[2] then
      maxy = point[2];
    end
    table.insert(vertexarray,pointarray[i]); 
    table.insert(vertexarray,pointarray[cnt + 1]);
    if i ~= cnt then
      table.insert(vertexarray,pointarray[i + 1]);
    else
      table.insert(vertexarray,pointarray[1]);
    end
  end
  
  --纹理坐标
  for i = 1, #vertexarray do
    local point = vertexarray[i];
    local x = point[1];
    local y = point[2];
    local texx = (x - minx) / (maxx - minx);
    local texy = 1.0 - (y - miny) / (maxy - miny);
    table.insert(texcoordarray,{texx,texy});
  end
  
  return vertexarray,texcoordarray;
end

return PupilRender;