local venuscore = require "venuscore"

--if _KRATOSEDITOR then
--  local path = venuscore.IFileSystem:PathAssembly("scrs:fakelikeapp.lua");
--  local f = loadfile(path);
--  package.preload["likeapp"] = f
--end

local particleupdateservice = require "apolloutility.apollonode.asyncparticle.particleupdateservice"
local textureloader = require "apolloutility.asynctexture.textureloader"
local asynctexture = require "apolloutility.asynctexture.asynctexture"
_USE_MiCRO_SHAPING = false;
local facelift;
--[[if _USE_MiCRO_SHAPING then
  facelift = require "apolloutility.posteffect.facelift.faceliftMicroShaping"
else
  facelift = require "beauty.newfacelift"
end]]--
local GestureAnimation = require "gesturemagic.gestureanimation"
local renderqueue = require "apolloutility.renderqueue"
local pbrlighting = require "apolloutility.pbrlighting"
local scenetimerender = require "apolloutility.scenetimerender"
local apollonode = require "apolloutility.apollonode"
local emptyimage = require "apolloutility.emptyimage"
local blendshape = require "emoji.emoji"
local lightgame = require "lightgame.lightgame"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local videodecet = require "videodecet"
local facecute = require "facecute"
local filter = require "filter"
local pupil = require "pupil.pupilmanager"
local likeapp = require "likeapp"
local soundplayer = require "soundplayer"
local faceinfo = require "videodecet.faceinfo";
require "utility"
local faceseg = require "videodecet.faceseg"
local posture = require "facecute.estimates.transposture";
--local avatar = require "avatar.avatartest"
local photomood = require "photomood.photomoodmanager"
local biugo = require "biugo.biugomanager"
local stylishFilter = require "stylish_filter.stylish_filters"
local vj = require "venusjson"
local nefelivfx = require "nefelivfx"
local blingeffect = require "blingbling.blingbling"
local lineeffect = require "lineeffect.line"
local videodefined = require"videodecet.defined"
--local editorscene = require "editorscene.editorscenemanager"
local editorscene = require "editorscene.editorscenemanager"
local editormakeup = require "editorscene.editormakeupmanager"
local makeup = require"beauty.facecute_makeup"
local AsyncImageLoader = require "apolloutility.async_image_loader.async_image_loader"
local facedefined = require "facecute.facechange.facedefined"
local detectmagic = require "newmagic.detectmagic"
local venusjson = require "venusjson"
--local verbo = require("jit.v")
--verbo.start()

--暂时关闭JIT防止JIT失败导致的效率下降
if _PLATFORM_ANDROID or _PROFILER then
  jit.off();
  jit.flush();
  LOG("turn off jit")
end

if _PLATFORM_WINDOWS then
  collectgarbage("setpause",200);
  collectgarbage("setstepmul",3000);
end

local LAYER_MAKE_UP   = renderqueue.CAMERA_LAYER_FIRST + 1
local LAYER_FACE_LIFT = renderqueue.CAMERA_LAYER_FIRST + 2
local LAYER_SHARPEN = renderqueue.CAMERA_LAYER_FIRST + 3
local LAYER_STYLISH = renderqueue.CAMERA_LAYER_FIRST + 4

local main = {}

if _KRATOSEDITOR then
  main._Agent = main;
else  
  g_callbackhandle = main;
  gMain = main
  
  --初始化回调
  main.servicecallbacks = {}
  main.callbackindex = 1;
  setmetatable(main.servicecallbacks, {__mode = "v"}) --弱引用 
  --以下为固定接口
  function main:RegisterCallback(func)
    local index = self.callbackindex;
    self.callbackindex = self.callbackindex + 1;
    self.servicecallbacks[index] = func;
    return self._Agent, index;
  end

  function main:CallbackFunction(index, ...)
    --_COROUTINES_ON();
    local func = self.servicecallbacks[index];
    local res = true;
    if func then
      res = func(...);
    end
    --_COROUTINES_OFF();
    return res;
  end
  
  function main:Exec(command)
    local f = load("return gMain:" .. command)
    if f == nil then
        return false
    end
    return f()
  end
end

function main:Timespan()
  local now = venuscore.ITimerSystem:GetTimevalue();
  local def = now - self.begintime;
  self.begintime = now;

  self.cumtime = self.cumtime + def;
  self.fps = self.fps + 1;
  if self.cumtime > 5 then
    local fps = self.fps / self.cumtime;
    self.fps = 0;
    self.cumtime = 0;
    LOG("logic fps "..fps);
  end
  return def;
end

function main:OnResizeView(x,y,w,h)
  facecute:OnResizeView(w,h);
  if facelift ~= nil then
  	facelift:OnResizeView(w,h)
  end
end

function main:PreloadingMaterial()
  self.preloadservice = venuscore.IServicesSystem:Create("apolloutility.preloadservice");
  self.preloadservice:Loading();
end

--size,video表示视屏纹理尺寸和id,size为table
function main:Initialize()
  --_COROUTINES_ON();
  self.isloaded = false;
  --初始化服务回掉注册体系
  
  textureloader:Initialize();
  --self:PreloadingMaterial();
  self:_CreateCameras(
    0.01, 20,
    mathfunction.vector3(0,0,0),
		mathfunction.vector3(0,0,-1),
		mathfunction.vector3(0,1,0));

  emptyimage:Initialize();
  pbrlighting:Initialize();--对PBR材质中的贴图的slot进行初始化
  scenetimerender:Initialize();
  renderqueue:Initialize(self.maincamera);
  videodecet:Initialize("docs:base/","%04d.jpg", "point.txt");
  facecute:Initialize(self.maincamera);
  lightgame:Initialize(self.maincamera);  
  filter:Initialize(self.maincamera); 
  biugo:Initialize(self.maincamera);
  pupil:Initialize(self.maincamera);
  photomood:Initialize(self.maincamera);
  particleupdateservice:Initialize();
  blendshape:Initialize();
  stylishFilter:Initialize(LAYER_STYLISH);
  nefelivfx:Initialize(renderqueue.CAMERA_LAYER_LAST);
  blingeffect:Initialize(LAYER_STYLISH)
  lineeffect:Initialize(LAYER_STYLISH)
  editorscene:Initialize(self.maincamera);
  editormakeup:Initialize(LAYER_MAKE_UP);
  makeup:Initialize(LAYER_MAKE_UP);
  detectmagic:Initialize();
  if _PLATFORM_WINDOWS then
    --self:FacecuteLoadResource("E:/work/facecute_project/TestResource/currentscene/scene.json");
    --self:SetMakeupForType(facedefined.makeupType.cosmetic,"E:/work/facecute_project/TestResource/currentscene/scene.json");
    --self:SetMakeupForType(facedefined.makeupType.editorlip,"E:/work/facecute_project/TestResource/currentscene/scene.json");
    --self:FacecuteLoadResource("test:facecute/zhaiyuejietwo/zhaiyuejietwo.json");
    --self:FacecuteLoadResource("docs:facecute/football/football.json");
    --self:FacecuteLoadResource("test:facecute/zhai/zhai.json");
    --self:FacecuteLoadResource("G:/photo_mood_material/100036/cutme.json");
    --self:FacecuteLoadResource("docs:jisu_gao/cutme.json");
    --self:FacecuteLoadResource("docs:facecute/shemenB_low/shemenB.json");
    --self:FacecuteLoadResource("test:facecute/koubikong/koubikong.json");
    --self:FacecuteLoadResource("test:nefelivfx/displace.json");
    --self:FacecuteLoadResource("docs:facecute/dedormationccq/dedormationccq.json");
    --self:FacecuteLoadResource("docs:facecute/Captain/Captain.json");
    --self:FacecuteLoadResource("docs:facecute/hudieB/hudieB.json");
    --self:FacecuteLoadResource("docs:facecute/mafazC/mafazC.json");
    --self:FacecuteLoadResource("test:facecute/LeiSheYan/LeiSheYan.json");
    --self:FacecuteLoadResource("docs:facecute/Jianjiaoji/Jianjiaoji.json");
    --self:FacecuteLoadResource("docs:haircolor(1)/haircolor/haircolor.json");
    --self:FacecuteLoadResource("docs:cutme_lyric1/cutme.json");
    --self:FacecuteLoadResource("test:miku/miku.json");
    --self:LoadStylishFilter("docs:soft_light_3/soft_light_3.json");
    --self:FacecuteLoadResource("docs:lightgame/model_animation_kbk/model_animation_kbk.json");
    --self:FacecuteLoadResource("G:/algo_video_facecute/lightgame/sticker/sticker.json");
    --self:FacecuteLoadResource("G:/algo_venus_editor_facecute/algo_video_facecute_editor/assets/test_resource/lightgame/model_animation_kbk/model_animation_kbk.json");
    --self:FacecuteLoadResource("G:/algo_video_facecute/lightgame/manipulate_snow/manipulate_snow.json");
    --self:FacecuteLoadResource("G:/algo_video_facecute/lightgame/manipulate_snowstorm/manipulate_snowstorm.json");
    --self:FacecuteLoadResource("G:/algo_video_facecute/lightgame/manipulate_rain/manipulate_rain.json");
    --self:FacecuteLoadResource("G:/algo_venus_editor_facecute/algo_video_facecute_editor/assets/test_resource/lightgame/manipulate_flower/manipulate_flower.json");
    --self:FacecuteLoadResource("G:/algo_video_facecute/lightgame/manipulate_flower_test/manipulate_flower_test.json");
    --self:FacecuteLoadResource("E:/facecute-master/algo_video_facecute/filter/dolly/dolly.json");
    --self:FacecuteLoadResource("E:/facecute-master/algo_video_facecute/filter/ripple/ripple.json");
    --self:FacecuteLoadResource("E:/facecute-master/algo_video_facecute/filter/dolly/dolly.json");
    --self:FacecuteLoadResource("E:/facecute-master/algo_video_facecute/filter/ripple/ripple.json");
    self:FacecuteLoadResource("test:jisu_gao/cutme.json");
    --self:FacecuteLoadResource("test:liveportrait/config.json");
    --self:FacecuteLoadResource("test:girlHead/config.json");
	  --测试使用 强制打开人脸检测 (放在facecute后面)
    faceseg:SetSegMark(videodefined.detectType.Face,true)
  else
    --asynctexture.SetMaxfps(15);
  end
  
  apolloengine.Framework:AddSynchronizeUpdateCallback(self._Agent, "SyncUpdate");--添加同步更新
  
  self.running = false;

  self.begintime = venuscore.ITimerSystem:GetTimevalue();
  self.cumtime = 0;
  self.fps = 0;  

  --瘦脸是否开启
  self.faceliftopen = false;
  self.faceliftloading = false;
  
  --磨皮是否开启 
  self.skinsmoothopen = false;
  self.skinsmoothloading = false;
  --美白是否开启
  self.skinbrightopen = false;
  self.skinbrightloading = false;
  
  --是否有美妆
  self.ismakeup = false;
  self.isedimakeup = false;
  --self:SetMakeupForType(facedefined.makeupType.cosmetic,"E:/work/facecute_project/TestResource/currentscene/scene.json");
  --self:SetMakeupForType(facedefined.makeupType.editorlip,"E:/work/facecute_project/TestResource/currentscene1/scene.json");
  LOG("initialize done");
  

  _PROFILER_START();
  --_COROUTINES_OFF();
  return true;
end

function main:_CreateCameras(near, far, pos, lookat, up)
  self.maincamera = apollonode.CameraNode();--新建摄像机
  --self.maincamera:CreatePerspectiveProjection(near, far);
  self.maincamera:SetName("MainCamera")
  self.maincamera:CreateRealCameraProjection(near, far);--设置摄像机
  self.maincamera:LookAt(pos, lookat, up);
  self.maincamera:Recalculate();--手动更新矩阵
  self.maincamera:SetClearColor(mathfunction.Color(0.0,1.0,1.0,1));
  self.maincamera:Activate();--激活主摄像机
end

--设置摄像机FBO
function main:AttachRenderTarget(fbo, texture)
  LOG("platform android, fbo:"..fbo);
  self.rendertarget = apolloengine.RenderTargetEntity();--创建一个FBO
  self.rendertarget:PushMetadata(--设置FBO格式
          apolloengine.RenderTargetResourceMetadata(
                  apolloengine.RenderTargetEntity.RT_RENDER_TARGET_2D,
                  apolloengine.Framework:GetResolution(),--分辨率
                  fbo));
  self.outputtexture = self.rendertarget:MakeTextureAttachment(
          apolloengine.RenderTargetEntity.TA_COLOR_0);--增加color0纹理
  self.outputtexture:PushMetadata(--创建纹理
          apolloengine.TextureResourceMetadata(
                  apolloengine.Framework:GetResolution(),
                  texture));
  self.rendertarget:CreateResource();
  self.maincamera:AttachRenderTarget(self.rendertarget);    
  return true ; 
end

--设置摄像机采集图片尺寸和id
function main:SetVideoTexture(size, video)
  videodecet:SetTexture(size, video);
  apolloengine.DeviceResource:PushDeviceResource(
    apolloengine.DeviceResource.DEVICE_CAPTURE,
    videodecet:GetVideoTexture());

  collectgarbage();
  apolloengine.Framework:ForceClear();

  return true;
end

function main:SetMaskVideoTexture(texid,size)
  biugo:SetMaskVideoTexture(texid,size);
  photomood:SetMaskVideoTexture(texid,size);
  return true;
end

function main:DoMorph(indiceslist, showtimelist, transtimelist)
  return biugo:DoMorph(indiceslist, showtimelist, transtimelist);
end

function main:UpdateMuglifeMaterial()
  return biugo:UpdateMuglifeMaterial();
end

function main:SetLyric(lyricTextureID,lyricColor,lyricDuration,lyricSize,lyricPosition,isNew)
  photomood:SetLyric(lyricTextureID,lyricColor,lyricDuration,lyricSize,lyricPosition,isNew);
  return true;
end

function main:SetQuotation(lyricTextureID,lyricColor,lyricDuration,lyricSize,lyricPosition,isNew)
  photomood:SetQuotation(lyricTextureID,lyricColor,lyricDuration,lyricSize,lyricPosition,isNew);
  return true;
end


function main:ShowLyric(isShow)
  photomood:ShowLyric(isShow);
  return true;
end

function main:ClearLyric()
  photomood:ClearLyric();
  return true;
end

function main:ShowQuotation(isShow)
  photomood:ShowQuotation(isShow);
  return true;
end

function main:ClearQuotation()
  photomood:ClearQuotation();
  return true;
end

--重置detectmagic 漫画效果(回到第一阶段)
function main:ResetStickerEffect()
  return detectmagic:ResetStickerEffect();
end

--重置detectmagic时间线 倒计时类型的漫画贴纸
function main:ResetTimeline()
  return detectmagic:ResetTimeline();
end


function main:ThreadExit()
    LOG("[ThreadExit] collectgarbage start");
    textureloader:Clear();
    collectgarbage();
    LOG("[ThreadExit] collectgarbage end");
    return true ;
end


function main:GetStickerResult()
  return lightgame:GetStickerResult();
end

function main:OnRecordStart()
  lightgame:OnRecordStart();
  filter:OnRecordStart();
  stylishFilter:OnRecordStart()
  editorscene:OnRecordStart()
  return true;
end

function main:OnRecordStop()
  lightgame:OnRecordStop();
  return true;
end

--加载换脸配置表
function main:FacecuteLoadResource(path)
  _COROUTINES_ON();
  videodecet:resetDetectFlag();
  local res =
    facecute:LoadConfig(path)
    and lightgame:LoadConfig(path)
    and filter:LoadConfig(path)
    and pupil:LoadConfig(path)
    and photomood:LoadConfig(path)
    and biugo:LoadConfig(path)
    and blendshape:LoadConfig(path)
    and editorscene:LoadConfig(path)
    and detectmagic:LoadConfig(path)
  res = nefelivfx:LoadConfig(path) or res
  if res then
    particleupdateservice:AsyncUpdate();    
  end
  self.isloaded = res;
  videodecet:launchDetectFlag();
  collectgarbage();
  _COROUTINES_OFF();
  return self.isloaded;
end
--释放换脸资源
function main:FacecuteUnloadResource()
  --_COROUTINES_ON();
  self.isloaded = false;
  asynctexture.Wait();
  videodecet:resetDetectFlag();
  facecute:ReleaseResource();
  lightgame:ReleaseResource();
  filter:ReleaseResource();
  pupil:ReleaseResource();
  photomood:ReleaseResource();
  biugo:ReleaseResource();
  blendshape:ReleaseResource();
  nefelivfx:ReleaseResource();
  editorscene:ReleaseResource();
  detectmagic:ReleaseResource();
  renderqueue:Clear(renderqueue.CAMERA_LAYER_ZERO, renderqueue.CAMERA_LAYER_LAST)
  makeup:UpdateMakeupLayer();
  asynctexture.Clear();
  particleupdateservice:Clear();
  venuscore.IFileSystem:SetResourcePath("");
  collectgarbage();
  apolloengine.Framework:ForceClear();
  --_COROUTINES_OFF();
  
  self:UpdateMakeup();
  return true;
end


function main:_Running()
  _COROUTINES_ON();
  --local def = self:Timespan();
  --soundplayer.ResetVolume();
  local def = self.def;
  local cnnsegMark = faceseg and faceseg:GetSegmentMark() or false;
  if(not cnnsegMark ) 
  then
     videodecet:Update(def);
  end
  
  if self.isMakeup or self.isloaded then
    posture:Reset();
  end

  if self.isMakeup then
    makeup:Update(def);
  end
  
  if self.isedimakeup then
    editormakeup:Update(def);
  end

  --avatar:Update(def);
  if self.isloaded and not self.running then--and likeapp.AI:RefreshedRawarray() then
    --if(soundplayer.ResetVolume) then
    --  soundplayer.ResetVolume();
    --end
    self.running = true;
    --posture:Reset();
    facecute:Update(def,self.maincamera);
    blendshape:Update(def);
    lightgame:Update(def);
    filter:Update(def);
    pupil:Update(def);
    biugo:Update(def);
    photomood:Update(def);
    nefelivfx:Update(def)
    editorscene:Update(def);
    detectmagic:Update(def);
    particleupdateservice:AsyncUpdate();
    self.running = false;
  end
  stylishFilter:Update(def)
  blingeffect:Update()
  lineeffect:Update()
  _PROFILER_UPDATE();
  _COROUTINES_OFF();
end

function main:Ontime()
  self:_Running();
end

function main:Update() 
  self:_Running();
end

function main:SyncUpdate()
  --_COROUTINES_ON();
  local def = self:Timespan();
  self.def = def;
  local cnnsegMark = faceseg and faceseg:GetSegmentMark() or false;
  --  LOG("cnnsegMark = "..tostring(cnnsegMark).." self.runningsync = "..tostring(self.runningsync))
  if(not self.runningsync)
  then
      self.runningsync = true;  -- androidvideodetect -- faceseg --facecnndetect--mldetection--C++Obj
                                --                               --haircnnseg--mlseg--C++Obj
      if cnnsegMark then        -- 有检测模块被使能 -- 检测106,动态表情,手势
        videodecet:Update(def); -- faceseg 根据mask来确定 mldetection是否检测
        faceseg:RunSegment();   -- faceseg 根据mask并且 facecnndetect/haircnnseg 根据servicecallbacks存在并回调返回ture才检测
      end
      self.runningsync = false;
  end  
  self:_Running();
  --_COROUTINES_OFF();
end

function main:EnablePostEffect(enable)
  if enable == true then
    if not self.post then
      self.post = self.maincamera:CreatePostEffect();
      self.post:CreateResource("comm:script/apolloengine/posteffect/pdenoise.lua")
    else
      self.post:Enable();
    end    
  else
    if self.post then
      self.post:Disable()
    end    
  end
  collectgarbage();
  apolloengine.Framework:ForceClear();
  return true;
end


function main:SetFaceliftLevel(eyecoef,facecoef,chincoef,isNew)
  LOG("SetFaceliftLevel " .. string.format("%f %f %f", eyecoef,facecoef,chincoef))
  self.eyecoef = eyecoef;
  self.facecoef = facecoef;
  self.chincoef = chincoef;
  if not self.faceliftloading then --这个修改是解决服务重入导致facelift多次初始化的问题
    if self.faceliftopen == false then
      if isNew and isNew == true then
        LOG("hit new facelift")
        facelift = require "beauty.newfacelift"
      else
        LOG("hit old facelift")
        facelift = require "apolloutility.posteffect.facelift.facelift"
      end 
      self.faceliftopen = true;
      self.faceliftloading = true;
      renderqueue:Activate(LAYER_FACE_LIFT)
      facelift:Initialize(renderqueue:GetCamera(LAYER_FACE_LIFT));
      facelift:setWarpLevel(self.eyecoef,self.facecoef,self.chincoef);
      videodecet:AddNewframeCallback(facelift:NewframeCallback());
      self.faceliftloading = false;
    else
      facelift:setWarpLevel(self.eyecoef,self.facecoef,self.chincoef);
    end
	return true
  else
    LOG("skip")
	return false
  end
  return true;
end

function main:InitFaceLift(isNew)
    if isNew and isNew == true then
      facelift = require "beauty.newfacelift"
    else
      facelift = require "apolloutility.posteffect.facelift.facelift"
    end
    renderqueue:Activate(LAYER_FACE_LIFT)
    facelift:Initialize(renderqueue:GetCamera(LAYER_FACE_LIFT))
    if _USE_MiCRO_SHAPING then
      facelift:setWarpLevel(1 ,0.000001);
    else
      facelift:setWarpLevel(0,0,0);
    end
    videodecet:AddNewframeCallback(facelift:NewframeCallback())
    self.faceliftopen = true
    return true
end

function main:ReleaseFaceLift()
  videodecet:RemoveNewframeCallback(facelift:GetNewframeCallback())
  facelift:Release()
  renderqueue:Deactivate(LAYER_FACE_LIFT)
  self.faceliftopen = false
  collectgarbage();
  apolloengine.Framework:ForceClear();
  return true
end

function main:SetParameterOfFaceLift(eyecoef, facecoef, chincoef)
    if not self.faceliftopen then
      return false
    end
    facelift:setWarpLevel(eyecoef, facecoef, chincoef);
    return true
end

function main:SetParameterOfFaceLiftEye(eyecoef)
    if not self.faceliftopen then
      return false
    end
    facelift:setEyeParam(eyecoef);
    return true
end

function main:SetParameterOfFaceLiftFace(facecoef)
    if not self.faceliftopen then
      return false
    end
    facelift:setFaceParam(facecoef);
    return true
end

function main:SetParameterOfFaceLiftChin(facecoef)
    if not self.faceliftopen then
      return false
    end
    facelift:setChinParam(facecoef);
    return true
end

function main:SetShowFaceLift(show)
  if not self.faceliftopen then
    return false
  end
  if show then
    facelift:Enable()
  else
    facelift:Disable()
  end
  return true
end

--[[
function main:SetSkinSmoothLevel(param)
  LOG("SetSkinSmoothLevel");
  if not self.skinsmoothloading then
    if self.skinsmoothopen == false then
      self.skinsmoothopen = true;
      self.skinsmoothloading = true;
      self.smoothskin = apollonode.PostEffect(); 
      self.smoothskin:CreateResource("scrs:beauty/beauty_smooth.lua");
      self.smoothskin:RegisterParameter("intensity")
      self.smoothskin["intensity"](self.smoothskin, param)
      renderqueue:GetCamera(renderqueue.CAMERA_LAYER_FIRST):AttachPostEffect(self.smoothskin)
      renderqueue:Activate(renderqueue.CAMERA_LAYER_FIRST)
      self.skinsmoothloading = false;
    else
      self.smoothskin["intensity"](self.smoothskin, param)
    end
    return true
  else
    LOG("skip")
    return false
  end
  return true;
end

function main:InitSkinSmooth()
    LOG("InitSkinSmooth");
    self.smoothskin = apollonode.PostEffect(); 
    self.smoothskin:CreateResource("scrs:beauty/beauty_smooth.lua");
    self.smoothskin:RegisterParameter("intensity")
    self.smoothskin["intensity"](self.smoothskin, 0.0)
    renderqueue:GetCamera(renderqueue.CAMERA_LAYER_FIRST):AttachPostEffect(self.smoothskin)
    renderqueue:Activate(renderqueue.CAMERA_LAYER_FIRST)
    self.skinsmoothopen = true;
    self.skinsmoothstatus = true;
    return true
end

function main:SetParameterOfSkinSmooth(param)
    LOG("SetParameterOfSkinSmooth param:"..param);
    if not self.skinsmoothopen then
      return false
    end
    self.smoothskin["intensity"](self.smoothskin, param/100)
    
    if param == 0 and self.skinsmoothstatus then
      self.smoothskin:Disable()
      self.skinsmoothstatus = false;
      return true;
    elseif param ~= 0 and not self.skinsmoothstatus then
      self.smoothskin:Enable()
      self.skinsmoothstatus = true;
      return true;
    end
    
    return true
end

function main:SetShowSkinSmooth(show)
  if not self.skinsmoothopen then
    return false
  end
  if show then
    self.smoothskin:Enable()
  else
    self.smoothskin:Disable()
  end
  return true
end

function main:ReleaseSkinSmooth()
    if self.smoothskin == nil then
        return true
    end
    renderqueue:Deactivate(renderqueue.CAMERA_LAYER_FIRST)
    renderqueue:GetCamera(renderqueue.CAMERA_LAYER_FIRST):DetachPostEffect(self.smoothskin)
    self.smoothskin = nil
    return true
end


function main:SetSkinBrightLevel(param)
  LOG("SetSkinBrightLevel");
  if not self.skinbrightloading then --这个修改是解决服务重入导致facelift多次初始化的问题
    if self.skinbrightopen == false then
      self.skinbrightopen = true;
      self.skinbrightloading = true;
      self.brightskin = apollonode.PostEffect(); 
      self.brightskin:CreateResource("comm:script/apolloutility/posteffect/skinbright.lua");
      self.brightskin:RegisterParameter("intensity")
      self.brightskin["intensity"](self.brightskin, param)
      renderqueue:GetCamera(renderqueue.CAMERA_LAYER_FIRST):AttachPostEffect(self.brightskin)
      renderqueue:Activate(renderqueue.CAMERA_LAYER_FIRST)
      self.skinbrightloading = false;
    else
      self.brightskin["intensity"](self.brightskin, param)
    end
    return true
  else
    LOG("skip")
    return false
  end
  return true;
end


function main:InitSkinBright()
    LOG("InitSkinBright");
    self.brightskin = apollonode.PostEffect(); 
    self.brightskin:CreateResource("comm:script/apolloutility/posteffect/skinbright.lua");
    self.brightskin:RegisterParameter("intensity")
    self.brightskin["intensity"](self.brightskin, 0.0)
    renderqueue:GetCamera(renderqueue.CAMERA_LAYER_FIRST):AttachPostEffect(self.brightskin)
    renderqueue:Activate(renderqueue.CAMERA_LAYER_FIRST)
    self.skinbrightopen = true;
    self.skinbrightstatus = true;
    return true
end

function main:SetParameterOfSkinBright(param)
    LOG("SetParameterOfSkinBright param:"..param);
    if not self.skinbrightopen then
      return false
    end
    self.brightskin["intensity"](self.brightskin, param/100)
    
    if param == 0 and self.skinbrightstatus then
      self.brightskin:Disable()
      self.skinbrightstatus = false;
      return true;
    elseif param ~= 0 and not self.skinbrightstatus then
      self.brightskin:Enable()
      self.skinbrightstatus = true;
      return true;
    end
    
    return true
end

function main:SetShowSkinBright(show)
  if not self.skinbrightopen then
    return false
  end
  if show then
    self.brightskin:Enable()
  else
    self.brightskin:Disable()
  end
  return true
end


function main:ReleaseSkinBright()
    if self.brightskin == nil then
        return true
    end
    renderqueue:Deactivate(renderqueue.CAMERA_LAYER_FIRST)
    renderqueue:GetCamera(renderqueue.CAMERA_LAYER_FIRST):DetachPostEffect(self.brightskin)
    self.brightskin = nil
    return true
end
]]--


function main:InitSharpen()
    if self.sharpen ~= nil then
        return true
    end
    self.sharpen = renderqueue:GetCamera(LAYER_SHARPEN):CreatePostEffect();
    if self.sharpen:CreateResource("comm:script/apolloengine/posteffect/laplacesharp.lua") then
      self.sharpen:RegisterParameter("sharpStrength")
      self.sharpen["sharpStrength"](self.sharpen, mathfunction.vector1(0))
      renderqueue:Activate(LAYER_SHARPEN)
    else
      self.sharpen = nil
    end
    return true
end

function main:ReleaseSharpen()
    if self.sharpen == nil then
        return true
    end
    renderqueue:Deactivate(LAYER_SHARPEN)
    renderqueue:GetCamera(LAYER_SHARPEN):DeletePostEffect(self.sharpen)
    self.sharpen = nil
    return true
end

function main:SetParameterOfSharpen(strength)
    if self.sharpen ~= nil then
        self.sharpen["sharpStrength"](self.sharpen, mathfunction.vector1(strength))
        return true
    end
    return false
end

function main:SetShowSharpen(show)
  if self.sharpen == nil then
    return false
  end
  if show then
    self.sharpen:Enable()
  else
    self.sharpen:Disable()
  end
  return true
end

function main:LoadStylishFilter(path)
    LOG("LoadStylishFilter")
    if self.stylishFilterLoaded then
      self:UnloadStylishFilter()
    end
    local res = false
    renderqueue:Activate(LAYER_STYLISH)
    res = stylishFilter:LoadConfig(path) or res
    res = blingeffect:LoadConfig(path) or res
    res = lineeffect:LoadConfig(path) or res
    if res then
        self.stylishFilterLoaded = true
    else
        self.stylishFilterLoaded = false
        renderqueue:Deactivate(LAYER_STYLISH)
    end
    return true
end

function main:UnloadStylishFilter()
    LOG("UnloadStylishFilter")
    stylishFilter:ReleaseResource()
    blingeffect:ReleaseResource()
    lineeffect:ReleaseResource()
    self.stylishFilterLoaded = false
    renderqueue:Deactivate(LAYER_STYLISH)
    collectgarbage()
    return true
end

function main:SetShowStylishFilter(show)
    if not self.stylishFilterLoaded then
        return false
    end
    stylishFilter:SetShow(show)
    blingeffect:SetShow(show)
    lineeffect:SetShow(show)
    return true
end

function main:SetDebugPointShow(isShow)
  if _PLATFORM_WINDOWS then
    videodecet:SetDebugPointShow(isShow)
  else
    WARNING("only windows support SetDebugPointShow ");
  end
end


-- FIXME(hhl) DEBUG ONLY +++
function main:switchHandSignal(useBVT)
  ERROR("main:switchHandSignal = "..tostring(useBVT));
  videodecet:switchHandSignal(useBVT);
end
-- FIXME(hhl) DEBUG ONLY ---


function main:GetNewFaceLandMark()
    return videodecet:GetNewFaceLandMark();
end

function main:SetElapsedTime(def)
  biugo:SetElapsedTime(def);
  return true;
end

--加载美妆
function main:SetMakeupForType(makeuptype,path)
  LOG("SetMakeup Type:"..makeuptype.." Path:"..path);
  
  local rootconfig = venusjson.LaodJsonFile(path);
  if rootconfig.scene then
    editormakeup:LoadConfig(path,makeuptype,rootconfig)
    if self.isedimakeup == false then
      renderqueue:Activate(LAYER_MAKE_UP)
    end
    self.isedimakeup = true;
    return true;
  end

  if _PLATFORM_WINDOWS then
    faceseg:SetSegMark(videodefined.detectType.Face,true)
  end

  makeup:LoadMakeup(makeuptype,path,rootconfig);
  self.isMakeup = true;
  return true;
end

--移除美妆
function main:RemoveMakeupByType(makeuptype)
  LOG("RemoveMakeup Type:"..makeuptype);
  
  local isEditorMakeup = editormakeup:ReleaseResource(makeuptype);
  if isEditorMakeup == true then
    if editormakeup:IsExistMakeup() == false then
      self.isedimakeup = false;
      renderqueue:Deactivate(LAYER_MAKE_UP)
    end
    return true;
  end
  
  local makeupList = makeup:ReleaseMakeup(makeuptype)
  if #makeupList < 1 then
    self.isMakeup = false;
    if self.isloaded == false then
      if _PLATFORM_WINDOWS then
        faceseg:SetSegMark(videodefined.detectType.Face,false)
      end
      renderqueue:Clear(renderqueue.CAMERA_LAYER_ZERO, renderqueue.CAMERA_LAYER_LAST)
    end
  end
  return true;
end

--更改美妆强度
function main:SetStrengthForType(maketype, strength)
  LOG("SetStrength Type:"..maketype.." Strength:"..strength);
  if editormakeup:SetMakeupStrength(strength, maketype) then
    return true;
  end
  makeup:SetMakeupStrength(strength, maketype)
  return true;
end

function main:UpdateMakeup()
  if _PLATFORM_WINDOWS then
    if self.isMakeup then
      faceseg:SetSegMark(videodefined.detectType.Face,true)
    end
  end
end




return main;
