local manipulatebase = require "lightgame.manipulatepartical.manipulatebase"
local renderqueue = require "apolloutility.renderqueue"
local apollonode = require "apolloutility.apollonode"
local detectdefined = require "videodecet.defined"
local mathfunction = require "mathfunction"
local apolloengine = require "apolloengine"
local videodecet = require "videodecet"
local define = require "lightgame.manipulatepartical.defined"


--操纵两个粒子，当信号出现的时候粒子切换粒子
local switch = manipulatebase:extend();

function switch:new(patha, pathb, trigger,soundA,soundB)
  switch.super.new(self, trigger,soundA,soundB);
  self.a = apollonode.ParticleNode();
  self.a:CreateResource(patha);
  renderqueue:Before(self.a);
  self.b = apollonode.ParticleNode();
  self.b:CreateResource(pathb);
  renderqueue:Before(self.b);
  self.switch = true;
  
end

function switch:SetLocalPosition(pos)
  self.a:SetLocalPosition(pos);
  self.b:SetLocalPosition(pos);
end

 function switch:_ResetParameter()  --切换为不同的粒子，无需reset
 end

function switch:_SetTriggerdParam(paramName, value)
  self.b:SetParamMultiplier(paramName,value);
end

function switch:_SetUnTriggerdParam(paramName, value)
  self.a:SetParamMultiplier(paramName,value);
end

function switch:_OnDetected(def, globaloffset, globalscale)
  

  self:PlaySound(1);
  
  if self.switch then
    self.switch = false;
    self.a:SetShow(false);
    self.b:SetShow(true);
  end  
  self.b:SetGlobalOffset(globaloffset);
  self.b:SetGlobalScale(globalscale);
  self.b:AsyncUpdate(def)
  

  

 
end

function switch:_OnSilence(def)
  if not self.switch then
    self.switch = true;
    self.a:SetShow(true);
    self.b:SetShow(false);
  end  
  self.a:AsyncUpdate(def);
  
  self:PlaySound(2);


end

function switch:Exit()
  switch.super:Exit();
end

return switch;