local GestureAction = require "gesturemagic.gestureanimation.gestureaction"
local SequenceAnimation = require "apolloutility.sequenceanimation"
local TextureReader = require "apolloutility.texturereader"
local GestureBehavior = require "gesturemagic.behavior"
local b3 = require "behavior3"
local Object = require "classic"
local vc = require "venuscore"
local cjutil = require "cjson.util"
local cjson = require "cjson"
require "utility"
local ImageService = require "apolloutility.texturereader"


local GestureAnimation = Object:extend()

function GestureAnimation:new()
  self.begintime = vc.ITimerSystem:GetTimevalue();
  self.imageservice = ImageService();
  self.sequenceAnimation = SequenceAnimation("docs:bodyeffect/material/bhtree_animation.material");
  self.behaviortree = b3.BehaviorTree.new();
  self.blackboard = b3.Blackboard.new()
  self.gestureaction = GestureAction();
  self.blackboard:set("gestureaction", self.gestureaction);
end

function GestureAnimation:Load(btpath)
  if not vc.IFileSystem:isFileExist(btpath) then
    ERROR("GestureAnimation: main config "..mainconfig.." is not exist");
    return false;
  end  
  local fullpath = vc.IFileSystem:PathAssembly(btpath);
  local behavior = cjson.decode(cjutil.file_load(fullpath));
  self.behaviortree:load(behavior, GestureBehavior);
  return true;
end

function GestureAnimation:Update()
  local now = vc.ITimerSystem:GetTimevalue();
  self.def = now - self.begintime;
  self.begintime = now;
  self.behaviortree:tick(self, self.blackboard)
end

function GestureAnimation:SetSimulateActionPoint(point)
  self.gestureaction:SetSimulateActionPoint(point);
end


function GestureAnimation:__tostring()
  return "GestureAnimation"
end

--使用
--self.bodysticker = GestureAnimation();
--self.bodysticker:Load("docs:bodyeffect/skeleton");  
--self.bodysticker:Update();  

return GestureAnimation;