local soundplayer = require "soundplayer"
local venuscore = require "venuscore"
local Object = require "classic"
local cutebehavior = require "facecute.behavior.cutebehavior"
local behdefined = require "facecute.behavior.behdefined"

--管理音频
local soundeffect = Object:extend();
function soundeffect:new()
  self.soundplayer = soundplayer();
  self.curTime = 0;
  self.initMark = 0;
  self.curLoop = self.initMark ;
  self.frames = 0;
  self.version = 1.1;
  self.events={};
  self.stateType = behdefined.stateType.NULL;
  self.targetType = behdefined.targetType.Music;
  self.play = false;
end

--传入数据表，解析数据
function soundeffect:ParseConfig(m, param)
  self.path = param[1].."/"..m.name;
  self.path = venuscore.IFileSystem:PathAssembly(self.path);
  self.delay = m.triggerDelay;
  self.loop = m.triggerLoop;
  self.stop = m.triggerStop;
  self.trigger = m.triggerType;
  self:SetTrigger(config);
  self.stateType = behdefined.stateType.NULL;
  local res = self.soundplayer:LoadSound(self.path);
  if res and 0 == self.triggerType then--非出发类直接播放
    self.soundplayer:PlaySound(self.loop);
  end
  return res;
end
  
function soundeffect:getAsset(name)
  return nil;
end

function soundeffect:SetTrigger(config)
  self.triggerType = self.trigger;
  self.triggerLoop = 1;
  self.triggerDelay = self.delay;
  self.triggerStop = self.stop;
end

function soundeffect:ReStart()
  self.curTime = 0;
  self.initMark = 0;
  self.curLoop = self.initMark ;
  self.stateType = behdefined.stateType.NULL;
  if(self.triggerStop==true and  0 ~= self.triggerType)
  then
    self.soundplayer:StopSound();
    self.play = false;
  end
  self.disAction = nil;
  self.lastAction = nil;
  self.action = nil;
end


function soundeffect:SetShow(isshow)
  if(isshow==false)
  then
     self:ReStart();
   end
end

function soundeffect:SetRootNode(node)
end

function soundeffect:Play()
  self:Render();
end


function soundeffect:Render()
   local timespan = self.timespan;
   
    if 0 ~= self.triggerType 
    then
       if(self.triggerStop==true )
       then
         self.soundplayer:PlaySound(self.loop);
         self.play= true;
       elseif(self.triggerStop==false and self.soundplayer:isPlaying()==false )
       then
         self.soundplayer:PlaySound(self.loop);
         self.play= true;
       end
    else
       self.soundplayer:PlaySound(self.loop);
    end
   
end

function soundeffect:SetVisible(vis)
  if(vis==false and self.triggerStop==true)
  then
   --self.soundplayer:StopSound();
  end
  --return 0;
end

function soundeffect:AddEvent(event)
  table.insert(self.events,event);
end

function soundeffect:ResetEvent()
  self.events ={};
end

function soundeffect:GetLoopCount()
  return self.frames;
end

function soundeffect:ResetLoopCount()
    self.frames = 0;
end
function soundeffect:stopSoundForActionDisappear(action)
    local len = table.getn(action);
    local actDis = true;
    for i=1,len do
        local id = action[i]:GetActionID();
        if(id==self.triggerType)
        then
          actDis = false;
        end
    end
    if(actDis and self.triggerStop==true and self.play==true)
    then
      self.soundplayer:StopSound();
      self.stateType = behdefined.stateType.NULL;
      self.play = false;
    end
end

function soundeffect:Update(timespan, face, position, rotation, action,assets)
  --在这里判断self.trigger条件是否满足，满足后使用下列接口播放音频
  if 0 ~= self.triggerType then
   -- self.soundplayer:PlaySound(self.loop);
    self:stopSoundForActionDisappear(action);
    self.timespan = timespan;
    self.action   = action;
    self.events={};
    cutebehavior:tick(self);
    self.frames = self.frames+1;
  end
end

function soundeffect:StopSound()
  self.soundplayer:StopSound();
end

return soundeffect;