
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local Object = require "classic"
local renderqueue = require "apolloutility.renderqueue"
local particlenode = require "facecute.particle.particlenode"
local rendernode = require "apolloutility.apollonode.rendernode"
local particle = rendernode:extend();
local cutebehavior = require "facecute.behavior.cutebehavior"
local behdefined = require "facecute.behavior.behdefined"

function particle:new(maincamera)
  particle.super.new(self);
  particle.super.SetShow(self, false);
  self.maincamera = maincamera;
  self.particles = {};
  self.frames = 0;
  self.curFrame = 0;
  self.curTime = 0;
  self.stateChange = false;
  self.stateType = behdefined.stateType.NULL;
  self.curLoop=0;
  self.timespan = 0
end


local function RotateXYZ(x,y,z)
    local eulerQuat = mathfunction.Quaternion();
    eulerQuat:YawPitchRoll(y, x, z);
    return eulerQuat;
end

function particle:GetParticleSysConfig(name,sysarrayconfig)
  local len =#sysarrayconfig;
  for i=1,len do
    if(sysarrayconfig[i].name==name)
    then
      return sysarrayconfig[i];
    end
  end
  
  return nil;
end


--传入particle数据表，解析数据生成变形器组件
function particle:ParseConfig(config,para)
  local n =5;
  local particls = config.particles;
  
  if(config==nil or para==nil or para.metascene==nil or  para.metascene.gameobject==nil)
  then
    LOG("particle:ParseConfig");
    return false;
  end
  
  local metasceneconfig = para.metascene;
  self.positionType = config.positionType;
  self:SetTrigger(config);
  self.name = config.name;
  
  local len = table.getn(metasceneconfig.gameobject);
  for i=1,len do
    local obj =metasceneconfig.gameobject[i];
    if(obj.name==self.name)
    then
      para["particlename"] = self.name;
      para["particlesystemarray"] = metasceneconfig.particlesystemarray;
      if(obj.children)
      then
        self:SetLocalPosition(mathfunction.vector3(obj.translation[1], obj.translation[2], obj.translation[3]));
        local angletranscof = 1.0;
        local eulerQuat = mathfunction.Quaternion(obj.rotation[1],obj.rotation[2],obj.rotation[3],obj.rotation[4]);
        self:SetLocalRotation(eulerQuat);
        self:SetLocalScale(mathfunction.vector3(obj.scale[1],obj.scale[2],obj.scale[3]));
        self:addChildren(metasceneconfig.gameobject,obj.children,para);
      else
        self:addChildren(metasceneconfig.gameobject,{i-1},para);
      end
      break;
    end
  end
  local res = true;

  return res;
end


function particle:IsNeedAttachHead()
  if(self.positionType=="HAND")
  then
    return false;
  else
    return true;
  end
end

function particle:AddEvent(event)
end

function particle:addChildren(gameobjconfig,chdconfig,para)
  local n = #chdconfig;
  --n =1;
  for i=1,n do
      local b= particlenode(self.maincamera);
      local particleparaconfig = self:GetParticleSysConfig(gameobjconfig[chdconfig[i]+1].name,para.particlesystemarray);
      para["particleparaconfig"] = particleparaconfig;
      b.positionType = self.positionType;
      b:ParseConfig(gameobjconfig[chdconfig[i]+1],para);
      if (self.positionType=="HAND") then
          renderqueue:Before(b);
      else
          renderqueue:After(b);
      end
      b:SetName(gameobjconfig[chdconfig[i]+1].name);
      table.insert(self.particles, b);
  end
  
end

function particle:SetTrigger(config)
  if(config.showupTrigger)
  then
    self.triggerType = config.showupTrigger.triggerType;
    --self.triggerLoop = config.showupTrigger.;
    self.triggerDelay = config.showupTrigger.triggerDelay;
    self.triggerStop = config.showupTrigger.triggerStop;
    self.triggerDisplayFrames = config.showupTrigger.displayFrames;
    self.triggerLoop = config.showupTrigger.displayFrames;
    --self.triggerLoop = 500;
  end
end


function particle:SetRenderOrder(config)
  
 --[[ local zPos = config["zPosition"];
  if(zPos)
  then
    for _, def in ipairs(self.particles) do
       def:SetRenderOrder(zPos);
    end
  end]]
  
 --[[ local zPos = config["zPosition"];
  if(zPos~=nil)
  then
     --local center = mathfunction.vector3(0, 0,-zPos);
     --local bindboxV = mathfunction.Aabbox3d(
      -- center - mathfunction.vector3(1,1,1),
      -- center + mathfunction.vector3(1,1,1));
     --local bindboxV = mathfunction.Aabbox3d(mathfunction.vector3(-1,1,0-zPos*10-1000),
     --mathfunction.vector3(1,-1,1-zPos*10-1000));
    local offset = -2000;
    local bindboxV = mathfunction.Aabbox3d(mathfunction.vector3(-1,-1, offset + zPos -1),
    mathfunction.vector3(1,1,offset + zPos));
    self:SetBindBox(bindboxV);
    self:SetCull(false);
  end]]
end


function particle:Render()
  for _, def in ipairs(self.particles) do
    def:Update(self.timespan, self.face, self.position, self.rotation, self.action);
  end
end


function particle:GetActionCenter(action)


   if(not action)
   then
     return nil;
   end
   local len = table.getn(action);
   if(len==0)
   then
     return nil;
    end
    

    for i=1,len do
         local id = action[i]:GetActionID();
      if(self.triggerType==id)
      then
         local  center =action[i]:GetCenter();
         
         --[[local rect =action[i]:GetRect();
         local rectw = math.abs(rect[3]-rect[1]);
         local recth =math.abs(rect[2]-rect[4]);
        -- local rectw =recth* facedefined.handSize[2]/ facedefined.handSize[1]
         local vec2 = apolloengine.Framework:GetResolution();
         local centerx = (rect[1]+rect[3])/2.0;
         local centery = (rect[4]+rect[2])/2.0;]]
         return center;
      end
    end
   return nil;
end


function particle:UpdateHandPosition()
  
  if(self.positionType=="HAND" and  self.action)
  then
    local center = self:GetActionCenter(self.actionRecord);
    if(center)
    then
      for _, def in ipairs(self.particles) do
        def:UpdateHandPosition(center);
      end
    else
        self:SetVisible(false);
        self:ReStart();
    end
  end
  
end
function particle:Update(timespan, face, position, rotation, action)
  self.timespan = timespan;
  self.face     = face;
  self.positon  = position;
  self.rotation = rotation;
  self.action   = action;
  self.actionRecord = action;
  self:UpdateHandPosition();
  
  if(self.triggerType==nil or 0 == self.triggerType)
  then
    self:Play();
  else
    cutebehavior:tick(self);
  end
  --self:Render();
  --[[for _, def in ipairs(self.particles) do
    def:Update(timespan, face, position, rotation, action);
  end]]
end


function particle:SetShow(isshow)  
  if (self.triggerType==nil or 0 == self.triggerType)
  then
    particle.super.SetShow(self,isshow);
    for _, def in ipairs(self.particles) do
     def:SetVisible(isshow);
    end

    if(isshow==false)
    then
      self:ReStart();
    end
  else
     if(isshow==false)
     then
       --if(self:IsOnFace())
       --then
         particle.super.SetShow(self,false);
         self:ReStart();
         for _, def in ipairs(self.particles) do
            def:SetVisible(false);
            --def.node:Reset();
            --def.node:Stop();
         end
       --end
     end
  end
  

end

function particle:ReStart()
  self.curTime = 0;
  self.initMark = 0;
  self.curLoop = self.initMark;
  self.stateType = behdefined.stateType.NULL;
  self.disAction = nil;
  self.lastAction = nil;
  self.action = nil;
  self.needupd = false;
  self.curLen = nil;
  self.frames= 0;
  self.curFrame = 0;
  self.actionRecord = nil;
end

function particle:SetVisible(vis)
  for _, def in ipairs(self.particles) do
    def:SetVisible(vis);
  end
end

function particle:GetLoopCount()
  return self.curFrame;
end

function particle:ResetLoopCount()
    self.curFrame = 0;
end

function particle:SetRootNode(node)
  if self:IsNeedAttachHead() then
    node:AttachNode(self);
  end
  for _, def in ipairs(self.particles) do
    self:AttachNode(def);
  end
end

function particle:Play()
  self:SetVisible(true);
  self:Render();
  self.curFrame = self.curFrame + 1;
  
end

return particle;