local apollonode = require "apolloutility.apollonode"
local defined = require "apolloutility.defiend"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local renderqueue = require "apolloutility.renderqueue"
local haircolordefined = require "facecute.haircolor.haircolordefined"



local hairtarget = {}
--是否开启降噪
hairtarget.enabledenoise = true;
function hairtarget:Initialize(maincamera)
 
  self.updated = false;
  self.enable = false;
  local near = maincamera:GetNear();
  local far = maincamera:GetFar();
  local pos = maincamera:GetWorldPosition();
  local lookat = pos + maincamera:GetForward();
  local up = maincamera:GetUp();
  local color = mathfunction.Color(0.0,0.0,0.0,0.0); --清屏颜色
  
  --渲染head box
  self.head_boundingbox_camera = apollonode.CameraNode();
  self.head_boundingbox_camera:Deactivate();
  self.head_boundingbox_camera:CreateRealCameraProjection(near, far);
  self.head_boundingbox_camera:LookAt(pos, lookat, up);
  self.head_boundingbox_camera:SetSequence(haircolordefined.hair_boundingbox_sequence);
  self.head_boundingbox_camera:SetClearColor(color);
  self.head_boundingbox_rt = apolloengine.RenderTargetEntity();
  self.head_boundingbox_rt:PushMetadata(--设置FBO格式
    apolloengine.RenderTargetMetadata(
      apolloengine.RenderTargetEntity.RT_RENDER_TARGET_2D,
      apolloengine.RenderTargetEntity.ST_SWAP_UNIQUE,
      apolloengine.Framework:GetViewport(),
      apolloengine.Framework:GetResolution()));--分辨率
    self.head_boundingbox_rt :MakeBufferAttachment(apolloengine.RenderTargetEntity.TA_DEPTH_STENCIL);
    self.head_boundingbox_tex = self.head_boundingbox_rt:MakeTextureAttachment(apolloengine.RenderTargetEntity.TA_COLOR_0);
    self.head_boundingbox_tex:PushMetadata(--创建纹理
      apolloengine.TextureRenderMetadata(
        apolloengine.RenderTargetEntity.ST_SWAP_UNIQUE,
        apolloengine.Framework:GetResolution()));
    self.head_boundingbox_rt :CreateResource();
    self.head_boundingbox_camera:AttachRenderTarget(self.head_boundingbox_rt);
    
  --渲染染色
  self.head_changecolor_camera = apollonode.CameraNode();
  self.head_changecolor_camera:Deactivate();
  self.head_changecolor_camera:CreateRealCameraProjection(near, far);
  self.head_changecolor_camera:LookAt(pos, lookat, up);
  self.head_changecolor_camera:SetSequence(haircolordefined.hair_changecolor_sequence);
  self.head_changecolor_camera:SetClearColor(color);
  self.head_changecolor_rt = apolloengine.RenderTargetEntity();
  self.head_changecolor_rt:PushMetadata(--设置FBO格式
    apolloengine.RenderTargetMetadata(
      apolloengine.RenderTargetEntity.RT_RENDER_TARGET_2D,
      apolloengine.RenderTargetEntity.ST_SWAP_UNIQUE,
      apolloengine.Framework:GetViewport(),
      apolloengine.Framework:GetResolution()));--分辨率
  self.head_changecolor_rt :MakeBufferAttachment(apolloengine.RenderTargetEntity.TA_DEPTH_STENCIL);
  self.head_changecolor_tex = self.head_changecolor_rt:MakeTextureAttachment(apolloengine.RenderTargetEntity.TA_COLOR_0);
  self.head_changecolor_tex:PushMetadata(--创建纹理
    apolloengine.TextureRenderMetadata(
      apolloengine.RenderTargetEntity.ST_SWAP_UNIQUE,
      apolloengine.Framework:GetResolution()));
  self.head_changecolor_rt :CreateResource();
  self.head_changecolor_camera:AttachRenderTarget(self.head_changecolor_rt);
    
  --增加降噪摄像机
  if self.enabledenoise == true then
    self.head_denoise_camera = apollonode.CameraNode();
    self.head_denoise_camera:Deactivate();
    self.head_denoise_camera:CreateRealCameraProjection(near, far);
    self.head_denoise_camera:LookAt(pos, lookat, up);
    self.head_denoise_camera:SetSequence(haircolordefined.hair_denoise_sequence);
    self.head_denoise_camera:SetClearColor(color);
  
    self.head_denoise_rt = apolloengine.RenderTargetEntity();
    self.head_denoise_rt:PushMetadata(--设置FBO格式
      apolloengine.RenderTargetMetadata(
        apolloengine.RenderTargetEntity.RT_RENDER_TARGET_2D,
        apolloengine.RenderTargetEntity.ST_SWAP_UNIQUE,
        apolloengine.Framework:GetViewport(),
        apolloengine.Framework:GetResolution()));--分辨率
  
    self.head_denoise_tex = self.head_denoise_rt:MakeTextureAttachment(apolloengine.RenderTargetEntity.TA_COLOR_0);
    self.head_denoise_tex:PushMetadata(--创建纹理
      apolloengine.TextureRenderMetadata(
        apolloengine.RenderTargetEntity.ST_SWAP_UNIQUE,
        apolloengine.Framework:GetResolution()));
    self.head_denoise_rt :CreateResource();
    self.head_denoise_camera:AttachRenderTarget(self.head_denoise_rt);
  end
  
end

function hairtarget:CreateQuad(changecolor_material)
  
  if self.enabledenoise == true then
    self.quad_denoise = apollonode.QuadNode();
    self.quad_denoise:SetShow(false);
    apolloengine.ShaderEntity.PIXEL_OFFSETS = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,"PIXEL_OFFSETS");
    apolloengine.ShaderEntity.SQUARE_COORDNATE = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.INTERNAL,"SQUARE_COORDNATE"); 
    apolloengine.ShaderEntity.TEXTURE_HAIR_MASK =apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,"TEXTURE_MASK");
    self.quad_denoise:CreateResource(haircolordefined.hairdenoise_material,true);

    local resolution = apolloengine.Framework:GetResolution();
    local height = resolution:y();
    local width = resolution:x();  
    self.quad_denoise:SetParameter(apolloengine.ShaderEntity.PIXEL_OFFSETS,mathfunction.vector2(1.5/width,1.5/height));
    self.quad_denoise:SetSequence(haircolordefined.hair_denoise_sequence);
  end
  
  --染色到before相机上的node
  self.quadnode = apollonode.QuadNode();
  self.quadnode:SetShow(false);
  apolloengine.ShaderEntity.TEXTURE_TO_HAIR_COLOR =apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,"TEXTURE_TO_COLOR");
  apolloengine.ShaderEntity.TEXTURE_HAIR_MASK =apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,"TEXTURE_MASK");
  apolloengine.ShaderEntity.TEXTURE_LUT =apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,"TEXTURE_LUT");
  apolloengine.ShaderEntity.BRIGHTNESS = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,"BIRGHTNESS");
  apolloengine.ShaderEntity.BRIGHTNESS_RANGE = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,"BRIGHTNESS_RANGE");
  apolloengine.ShaderEntity.BRIGHTNESS_CURVECOEF = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,"BRIGHTNESS_CURVECOEF");
  apolloengine.ShaderEntity.SATURATION_CURVECOEF = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,"SATURATION_CURVECOEF");
  apolloengine.ShaderEntity.XYMIN = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,"XYMIN");
  apolloengine.ShaderEntity.XYMAX = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,"XYMAX");
  --apolloengine.ShaderEntity.BRIGHTNESS_RANGE1 = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,"BRIGHTNESS_RANGE1");
  self.quadnode:CreateResource(changecolor_material,true);
  self.quadnode:SetParameter(apolloengine.ShaderEntity.TEXTURE_TO_HAIR_COLOR,self.head_boundingbox_tex);--目标颜色贴图
  
  if self.enabledenoise == true then 
    self.quadnode:SetParameter(apolloengine.ShaderEntity.TEXTURE_DIFFUSE,self.head_denoise_tex);  
  end
  
  self.quadnode:SetSequence(haircolordefined.hair_changecolor_sequence);
  --
  self.quadnode:SetParameter(apolloengine.ShaderEntity.XYMIN,mathfunction.vector2(0.0,0.0)); 
  self.quadnode:SetParameter(apolloengine.ShaderEntity.XYMIN,mathfunction.vector2(1.0,1.0));
  
  self.quad_laplace = apollonode.QuadNode();
  self.quad_laplace:SetShow(false);
  apolloengine.ShaderEntity.TEXTURE_SIZE =apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,"TEXTURE_SIZE");
  apolloengine.ShaderEntity.SHAPREN_STREGTH = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,"SHARPEN_STRENGTH");
  apolloengine.ShaderEntity.LAPLACE_COORDNATE = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.INTERNAL,"LAPLACE_COORDNATE");   
  self.quad_laplace:CreateResource(haircolordefined.laplace_sharpen_material,true);
  self.quad_laplace:SetParameter(apolloengine.ShaderEntity.TEXTURE_DIFFUSE,self.head_changecolor_tex); 
  self.quad_laplace:SetParameter(apolloengine.ShaderEntity.TEXTURE_SIZE,apolloengine.Framework:GetResolution());
  
  --最终结果贴到前置相机
  renderqueue:Prev(self.quad_laplace); --前置相机绘制
  
end

function hairtarget:Active()
  self.head_boundingbox_camera:Activate();
  self.head_changecolor_camera:Activate();
  self.quadnode:SetShow(false);
  self.quad_laplace:SetShow(false);
  if self.enabledenoise == true then
    self.head_denoise_camera:Activate();
    self.quad_denoise:SetShow(false);
  end
end

function hairtarget:SetHairMask(texture)
  self.quadnode:SetParameter(apolloengine.ShaderEntity.TEXTURE_HAIR_MASK,self.hair_mask_map);  --hair mask
end

function hairtarget:Enable()
  self.enable = true;
end

function hairtarget:Disable()
  self.enable = false;
end

function hairtarget:SetSharpStregth(ratio)
  self.quad_laplace:SetParameter(apolloengine.ShaderEntity.SHAPREN_STREGTH,mathfunction.vector1(ratio));
end

function hairtarget:SetBrightness(brightness)
  self.quadnode:SetParameter(apolloengine.ShaderEntity.BRIGHTNESS,mathfunction.vector1(brightness));
end

function hairtarget:SetBrightnessCurveCoef(coef1,coef2,coef3,coef4)
  self.quadnode:SetParameter(apolloengine.ShaderEntity.BRIGHTNESS_CURVECOEF,mathfunction.vector4(coef1,coef2,coef3,coef4));
end

function hairtarget:SetSaturationCurveCoef(coef1,coef2,coef3,coef4)
  self.quadnode:SetParameter(apolloengine.ShaderEntity.SATURATION_CURVECOEF,mathfunction.vector4(coef1,coef2,coef3,coef4));
end
--[[
  function hairtarget:SetBrightnessRange(brightness_low,brightness_high)
  local high = 1;
  local low = 0;
  
  if brightness_high < brightness_low then
    high = brightness_low;
    low = brightness_high;
  else
    high = brightness_high;
    low = brightness_low;
  end
  
  self.quadnode:SetParameter(apolloengine.ShaderEntity.BRIGHTNESS_RANGE, mathfunction.vector2(low,high));
end
]]--

function hairtarget:SetBrightnessRange(high,mid,low)
  self.quadnode:SetParameter(apolloengine.ShaderEntity.BRIGHTNESS_RANGE, mathfunction.vector3(low,mid,high));
end




function hairtarget:SetLuttable(lut)
  --颜色查找表纹理
  self.lut_map = apolloengine.TextureEntity();
  self.lut_map:PushMetadata(apolloengine.TextureFileMetadata(apolloengine.TextureEntity.TU_STATIC,
      apolloengine.TextureEntity.PF_AUTO,1, false,
      apolloengine.TextureEntity.TW_CLAMP_TO_EDGE,
      apolloengine.TextureEntity.TW_CLAMP_TO_EDGE,
      apolloengine.TextureEntity.TF_NEAREST,
      apolloengine.TextureEntity.TF_NEAREST,
      lut));
  self.lut_map:CreateResource();
  self.quadnode:SetParameter(apolloengine.ShaderEntity.TEXTURE_LUT,self.lut_map); --颜色查找表(用于提亮)
end


function hairtarget:Queue(node)
   node:SetSequence(haircolordefined.hair_boundingbox_sequence);
   node:SetCamera(self.head_boundingbox_camera);
end

function hairtarget:Update(hair_mask_texture,video_image_texture,xymin,xymax)
  self.updated = true;
  self.quadnode:SetParameter(apolloengine.ShaderEntity.TEXTURE_HAIR_MASK,hair_mask_texture);  
 -- self.quadnode:SetParameter(apolloengine.ShaderEntity.TEXTURE_DIFFUSE,video_image_texture); 
  self.quadnode:SetParameter(apolloengine.ShaderEntity.XYMIN,xymin); 
  self.quadnode:SetParameter(apolloengine.ShaderEntity.XYMAX,xymax);
  self.quad_laplace:SetParameter(apolloengine.ShaderEntity.TEXTURE_HAIR_MASK,hair_mask_texture); 
  self.quad_laplace:SetParameter(apolloengine.ShaderEntity.TEXTURE_SIZE,apolloengine.Framework:GetResolution());
  
  if self.enabledenoise == true then
    self.quad_denoise:SetParameter(apolloengine.ShaderEntity.TEXTURE_HAIR_MASK,hair_mask_texture);
    self.quad_denoise:SetParameter(apolloengine.ShaderEntity.TEXTURE_DIFFUSE,video_image_texture);
    local resolution = apolloengine.Framework:GetResolution();
    local height = resolution:y();
    local width = resolution:x();  
    self.quad_denoise:SetParameter(apolloengine.ShaderEntity.PIXEL_OFFSETS,mathfunction.vector2(1.5/width,1.5/height));
  else
    self.quadnode:SetParameter(apolloengine.ShaderEntity.TEXTURE_DIFFUSE,video_image_texture);
  end
  
end

function hairtarget:SetShow(isShow)
  if self.updated then
    if self.enable and self.isShow ~= isShow then
      self.isShow = isShow
      self.quadnode:SetShow(isShow);
      self.quad_laplace:SetShow(isShow);
      if self.enabledenoise == true then
        self.quad_denoise:SetShow(isShow);
      end
    end
  end  
end





function hairtarget:Clear()
  self.head_boundingbox_camera:Deactivate();
  self.head_changecolor_camera:Deactivate();
  if self.quad_laplace ~= nil then
    self.quad_laplace:SetShow(false);
  end
  if self.quad_denoise ~= nil then
    self.head_denoise_camera:Deactivate();
    self.quad_denoise:SetShow(false);
  end
  self.isShow = false;
  self.updated = false;
  self:Disable();
end


return hairtarget;