local facecover = require "facecute.facechange.facecover"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local Object = require "classic"
local renderqueue = require "apolloutility.renderqueue"
local facedefined = require "facecute.facechange.facedefined"
local facecoverpri = require "facecute.facechange.facecoverpri"

--管理多个facechange
local facechange = Object:extend();

function facechange:new(maincamera)
  self.maincamera = maincamera;
  self.facechanges = {};
  self.facechangenames={};
  self.facecoverpri =facecoverpri(self.maincamera);

end


function facechange:IsNeedSwap(tag)
  
  local len = table.getn(facedefined.blendSwap);
  for i=1,len do
    
    if(facedefined.blendMode[tag]== facedefined.blendSwap[i])
    then
       return true;
    end   
  end
  
end

function facechange:getAsset(name)
   local len = table.getn(self.facechangenames);
  for i=1,len do
    if(name==self.facechangenames[i])
    then
       return self.facechanges[i];
    end
  end
  return nil;
end

--传入数据表，解析数据生成face组件
function facechange:ParseConfig(config, para)

    if (config == nil or para == nil) then
        return false;
    end

    local res = true;

    local index = 1;
    local faceroot = config["faceMorph"];
    if (faceroot ~= nil) then

        self.facecoverpri:ParseConfig(config, nil);
        local faceMakeUps = faceroot["makeups"];
        local compress_root = config["compress_root"];
        local faceLen = table.getn(faceMakeUps);
        for i = 1, faceLen do
            --for i=6,6 do
            if (faceMakeUps[i]["enable"] == true) then
                local b = facecover(self.maincamera);
                --renderqueue:Before(b);
                --renderqueue:Queue(index+facedefined.queue_camera_count_s,b);
                -- para["layerOrder"] =index+facedefined.queue_camera_count_s;
                --renderqueue:Queue(index+facedefined.queue_camera_count_s,b);
                para["facecoverpri"] = self.facecoverpri;
                para["addIndex"] = i;
                local val = faceroot["zPosition"];
                para["zPos"] = val;
                --para["zOrder"] = -i;
                if (self:IsNeedSwap(faceMakeUps[i]["tag"])--[[faceMakeUps[i]["tag"]==3 or faceMakeUps[i]["tag"]==5]])
                then
                    index = index + 1;
                    b.needswap = true;
                end
                res = res and b:ParseConfig(faceMakeUps[i], para, compress_root);
                if faceMakeUps[i]["name"] then
                  b:SetName(faceMakeUps[i]["name"]);
                end
                table.insert(self.facechanges, b);
                table.insert(self.facechangenames, faceMakeUps[i]["name"]);
            end
        end
    end

    --
    local isFullFace = false;
    local isNotFullFace = false;
    local isNeedZDepth = false;
    local isNotNeedZDepth = false;
    local len = #self.facechanges;
    for i = 1, len do
        if (self.facechanges[i]:IsBeFullFace())
        then
            isFullFace = true;
        else
            isNotFullFace = true;
        end
        if (self.facechanges[i]:IsNeedZDepth())
        then
            isNeedZDepth = true;
        else
            isNotNeedZDepth = true;
        end
    end

    local pripara = { isFullFace, isNotFullFace, isNeedZDepth, isNotNeedZDepth };
    self.facecoverpri.isFullFace = pripara[1];
    self.facecoverpri.isNotFullFace = pripara[2];
    self.facecoverpri.isNeedZDepth = pripara[3];
    self.facecoverpri.isNotNeedZDepth = pripara[4];
    self:AddToRenderQueue();
    return res;
end


function facechange:AddToRenderQueue()
      local index =1;
      local len = #self.facechanges;
      for i =1, len do
           local b = self.facechanges[i];
           b.addIndex = index;
           index = index+1;
           renderqueue:AddObjs(b);
      end
      
     local maxz = -10000;
     for i=1,len do 
        local zorder = self.facechanges[i]:GetRenderOrder();
        maxz = math.max(maxz,zorder);
     end
     renderqueue:SetMaxFaceOrder(maxz);
end

function facechange:SetShow(isshow)
  for _, def in ipairs(self.facechanges) do
    def:SetShow(isshow);
  end
end

function facechange:Update(timespan, face, position, rotation, action)
  self.facecoverpri:Update(timespan, face, position, rotation, action);
  for _, def in ipairs(self.facechanges) do
    def:Update(timespan, face, position, rotation, action);
  end
end

function facechange:SetRootNode(node)
  node:AttachNode(self.facecoverpri);
  for _, def in ipairs(self.facechanges) do
    node:AttachNode(def);
  end
   
end
return facechange;