local transfer = require "facecute.deformation.transfer"
local bezier = require "facecute.deformation.bezier"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local Object = require "classic"
local renderqueue = require "apolloutility.renderqueue"
--管理多个变形器
local deformation = Object:extend();

function deformation:new(maincamera)
  self.maincamera = maincamera;
  self.deformations = {}
end


function deformation:getAsset(name)
end
  
--传入deformation数据表，解析数据生成变形器组件
function deformation:ParseConfig(config, para)
    --local b = bezier(self.maincamera);
    --b:ParseConfig(config);
    -- table.insert(self.deformations, b);
    --[[
        local b = bezier(self.maincamera);
      b:ParseConfig(config);
      table.insert(self.deformations, b);
    ]]--

    local defpara = {};
    for name, pa in pairs(para) do
        defpara["name"] = pa;
    end

    local version = tonumber(config["version"]);
    defpara["version"] = para[2];
    for i = 1, #config["deformations"] do
        local deformation_tmp = config["deformations"][i]
        --LOG(("name: [%s]"):format(deformation_tmp["name"]))
        --LOG(("centerOffset: [%f %f]"):format(deformation_tmp["centerOffset"][1],deformation_tmp["centerOffset"][2]))
        if (deformation_tmp["transfer"] == true) then
            local t = transfer(self.maincamera);
            --renderqueue:Queue(i,t);
            defpara["layerOrder"] = i;
            t:ParseConfig(deformation_tmp, defpara);
            table.insert(self.deformations, t);

        end
        if (deformation_tmp["transfer"] == false) then
            local b = bezier(self.maincamera);
            --renderqueue:Queue(i,b);
            defpara["layerOrder"] = i;
            b:ParseConfig(deformation_tmp, defpara);
            table.insert(self.deformations, b);
        end
    end

    self:AddToRenderQueue();
end


function deformation:AddToRenderQueue()
      local index =1;
      local len = #self.deformations;
      for i =1, len do
           local b = self.deformations[i];
           b.addIndex = index;
           index = index+1;
           renderqueue:AddObjs(b);
          local z = b.addIndex/10000+renderqueue:GetMaxFaceOrder();
          b:SetRenderOrder(z);
      end
end

function deformation:getAsset(name)
  return nil;
end

function deformation:SetShow(isshow)
  for _, def in ipairs(self.deformations) do
    def:SetShow(isshow);
  end
end

function deformation:Update(timespan, face, position, rotation, action)
  for _, def in ipairs(self.deformations) do
    def:Update(timespan, face, position, rotation, action);
  end
end

function deformation:SetRootNode(node)
  for _, def in ipairs(self.deformations) do
    node:AttachNode(def);
  end
end


return deformation;
