local modelnodemodel = require "apolloutility.apollonode.modelnode"
local modelnode = require "apolloutility.apollonode.meshnode"
local skeletonnode = require "apolloutility.apollonode.skeletonnode"
local trasnnode = require "apolloutility.apollonode.trasnnode"
local defiend = require "facecute.3dsticker.defiend"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local venusjson = require "venusjson"
local Object = require "classic"
local vc = require "venuscore"

local modelnode3New = modelnodemodel:extend();

local AS_ERROR = apolloengine.AnimationComponent.AS_ERROR;
local AS_PLAYING = apolloengine.AnimationComponent.AS_PLAYING;
local AS_DONE = apolloengine.AnimationComponent.AS_DONE;
local AS_STOP = apolloengine.AnimationComponent.AS_STOP;


local TextureSlot = 
{
  TS_DIFFUSE = 0,
  TS_NORMAL = 1
};

local MaterialType = 
{
  MT_OPAQUE = 0,
  MT_TRANSPARENT = 1
};


function modelnode3New:new()
    modelnode3New.super.new(self)
    self.animLoop = 0;
    self.currLoop = 0;
    self.animTime = -1;
    self.animFPS = 30
    self.animStatus = AS_STOP
end


----------

function modelnode3New:SetRootNode(rootNode)
    rootNode:AttachNode(self)
end

function modelnode3New:Finished()
    return self.animStatus == AS_DONE
end

function modelnode3New:SeekToFirst()
    self:Reset(0)
end

function modelnode3New:SeekToMiddle()
    local frameCount = self:GetFrameCount()
    self:Reset(frameCount * 0.5)
end

function modelnode3New:SeekToLast()
    local frameCount = self:GetFrameCount()
    self:Reset(frameCount - 1)
end

function modelnode3New:Show(args)
    modelnode3New.super.SetShow(self, args);
end

function modelnode3New:GetRenderOrder()
  local offset = -2000;
  if self.zPos~=nil then
      return self.zPos + offset;
  end
  return offset;
end


function modelnode3New:SetRenderOrder(zPos)
  local offset = -2000;
  self.zPos = zPos;
  local bindboxV = mathfunction.Aabbox3d(mathfunction.vector3(-1,-1, offset + zPos -1),
  mathfunction.vector3(1,1,offset + zPos));
  self:SetBindBox(bindboxV);
  --self:SetCull(false);
  for key,value in pairs(self.nodes) do
    LOG("SET RENDER ORDER:"..key.."TO:"..zPos);
    value:SetBindBox(bindboxV);
    value:SetCull(false);
  end
end


function modelnode3New:NeedSwap()
  return false;
end

function modelnode3New:IsRenderProperty(p)
  local ret = false;
  for key,value in pairs(self.nodes) do
    if value:IsRenderProperty(p) then
      return true;
    end
  end

  return false;
end


function modelnode3New:Hide(args)
    modelnode3New.super.SetShow(self,false);

    self.animLoop = 0;
    self.currLoop = 0;
    self.animTime = -1;
    self.animStatus = AS_STOP

    modelnode3New.super.Stop(self)
end

function modelnode3New:Start(args)
    if self.animStatus == AS_PLAYING then
        return
    end

    self:Reset();
    self.animStatus = AS_PLAYING
    self.animLoop = args.loop;
    self.currLoop = 0;
    self.animTime = 0.0;

    if self.animLoop == 0 then
        self:SetLoop(true);
    else
        self:SetLoop(false);
    end

    modelnode3New.super.Play(self);
end

function modelnode3New:Stop(args)

end

function modelnode3New:Update(timespan, face, position, rotation, action)
    self:UpdateAnimation(timespan)
end

--TODO
function modelnode3New:SetFade(fade)

end

--------


function modelnode3New:UpdateAnimation(timespan)

    if self.animStatus ~= AS_PLAYING then
        return self.animStatus
    end

    local res = modelnode3New.super.UpdateAnimation(self, timespan);

    if res == AS_DONE then
        self.currLoop = self.currLoop + 1;
        if self.animLoop > 0 then
            if self.currLoop < self.animLoop then
                self:Reset();
            else
                self.animStatus = AS_DONE
                self.animTime = -1
                self.animLoop = 0
                self.currLoop = 0
            end
        end
    elseif res == AS_ERROR then
        self.animStatus = AS_ERROR;
    elseif res == AS_STOP then
        self.animStatus = AS_STOP
    end
    return self.animStatus;
end



function modelnode3New:SetTexturePath(diffuseFullPath,refFullPath)
    self.submeshTexTable = diffuseFullPath;
    self.submeshRefTable = refFullPath;
end
  
function modelnode3New:CreateResource(rootpath, defmaterial, memoryuseage)
  memoryuseage = memoryuseage or apolloengine.VertexBufferEntity.MU_STATIC;
  local res = true;
  local configFullPath = rootpath .. "/" .. "config.json";

  local modelconfig = venusjson.LaodJsonFile(configFullPath);
  if modelconfig.version == 2 then
    return self:CreateResource2(rootpath, defmaterial, memoryuseage);
  elseif modelconfig.version == 3 then
    return self:CreateResource3(rootpath, defmaterial, memoryuseage);
  end
  local bind = mathfunction.Aabbox3d();
  for meshesKey, meshesValue in pairs(modelconfig) do
    for meshKey,meshValue in pairs(meshesValue) do
      local meshpath = meshValue.name;
      local submeshname = string.sub(meshpath,8,string.len(meshpath)-5);
      if self.submeshTexTable[submeshname] ~=nil then
        
        local meshFullPath = rootpath .. "/" .. meshpath;
        local diffusetex;
        local normaltex;
        local pbrtex;
        LOG("create submesh "..submeshname);
        local diffuseFullPath;
        if vc.IFileSystem:isFileExist(self.submeshTexTable[submeshname]) then
          diffuseFullPath = self.submeshTexTable[submeshname];
        end
        local normalFullPath ;
        local pbrtextureFullPath ;
        local materialtype;
        local ispbr = false;
        local material = meshValue.material;
        if material then
          materialtype = material.alphamode;
          materialtype = MaterialType.MT_TRANSPARENT;
          if material.normaltexture then
            normaltex = material.normaltexture.path;
          end
          
          if material.pbrmetallicroughness.basecolortexture then
            diffusetex = material.pbrmetallicroughness.basecolortexture.path;
          end  
        end
        
        if diffusetex and diffuseFullPath==nil then
          diffuseFullPath = rootpath .. "/" .. diffusetex;
        end
        if normaltex and normalFullPath==nil then
          normalFullPath = rootpath .. "/" .. normaltex;
        end
        
    
        local materialFullPath = defmaterial or defiend.model_simple_material_path;
        if material.pbrmetallicroughness.metallicroughnesstexture ~= nil then  --pbr材质
          ispbr = true;
          materialFullPath = defiend.model_pbr_material_path;
          if pbrtextureFullPath==nil then
            pbrtex = material.pbrmetallicroughness.metallicroughnesstexture.path;
            pbrtextureFullPath = rootpath .. "/" .. pbrtex;
          end
        end
        
        local skeletonPath = meshValue.skeleton;
        local maxBone = meshValue.maxbonecnt;
        local animationPath = meshValue.animation;
        local frameCount = meshValue.framecount;
        local isHasScale = meshValue.hasscale;
        
        local transList = meshValue.translation;
        local rotList = meshValue.rotation;
        local scaleList = meshValue.scale;
        
        local bindmin = meshValue.boundingbox.min;
        local bindmax = meshValue.boundingbox.max;
        
        local bindboxV = mathfunction.Aabbox3d(
          mathfunction.vector3(bindmin[1],bindmin[2],bindmin[3]),
          mathfunction.vector3(bindmax[1],bindmax[2],bindmax[3]));
        
        if animationPath then
          
          local suffix = materialtype == MaterialType.MT_TRANSPARENT and "_t" or "";
    
          local materialpath = ispbr
              and (isHasScale and defiend.model_pbr_matrix_material_path or defiend.model_pbr_dual_material_path)
              or (isHasScale and defiend.model_matrix_material_path or defiend.model_dual_material_path) 
          materialFullPath = string.format(materialpath, maxBone,suffix);
          
      
          self.isSkined = true;
          animationPath = rootpath .. "/" .. animationPath;
          skeletonPath = rootpath .. "/" .. skeletonPath;
        end
        
        local modelnode = modelnode();
        if self.keepsource then
          modelnode:SetKeepSource(self.keepsource);
        end
        
        if diffuseFullPath then 
          modelnode:PushTextureMetadata(apolloengine.ShaderEntity.TEXTURE_DIFFUSE,diffuseFullPath);
        end 
      
        if normalFullPath then
          modelnode:PushTextureMetadata(apolloengine.ShaderEntity.TEXTURE_BUMP,normalFullPath);
        end  
        
        if material.pbrmetallicroughness.metallicroughnesstexture ~= nil then  --pbr材质
          modelnode:PushTextureMetadata(apolloengine.ShaderEntity.TEXTURE_AMR,pbrtextureFullPath);
          modelnode:PushTextureMetadata(apolloengine.ShaderEntity.TEXTURE_NORMAL,normalFullPath);
          modelnode:PushTextureMetadata(apolloengine.ShaderEntity.TEXTURE_ALDEBO,diffuseFullPath);
        end
      
      
        self.nodes[meshpath] = modelnode;
        LOG(materialFullPath);
        res = res and modelnode:CreateResource(meshFullPath,materialFullPath,skeletonPath,animationPath,frameCount, isHasScale and 0 or 1, memoryuseage);
        modelnode:SetBindBox(bindboxV);
        if(maxBone~=nil) then
          local skinCom = modelnode:CreateComponent(apolloengine.Node.CT_SKIN);

          skinCom:SetHasScale(isHasScale);
          skinCom:SetSkeletonComponent(modelnode.skeleton);  
          table.insert(self.skincoms,skinCom);
        end
        bind:Contains(bindboxV);
        self:AttachNode(modelnode);
      end
    end
  end
  self.bindbox:SetBindBox(bind);
  return res;
end
  
function modelnode3New:CreateResource2(rootpath, defmaterial, memoryuseage)
  local res = true;
  memoryuseage = memoryuseage or apolloengine.VertexBufferEntity.MU_STATIC;
  local configFullPath = rootpath .. "/" .. "config.json";
  local modelconfig = venusjson.LaodJsonFile(configFullPath);
  if modelconfig.version ~= 2 then
    return false; 
  end
  self.version = 2;
  local bind = mathfunction.Aabbox3d();
  
  local hasAnim = false;
  local isHasScale = false;
  
  if modelconfig.skeleton~=nil and modelconfig.skeleton.name~="" and modelconfig.skeleton.animation.name~="" then
    
    local skeletonPath = modelconfig.skeleton.name;
    skeletonPath = rootpath .. "/" .. skeletonPath;
    local animInfos =  modelconfig.skeleton.animation;
    animInfos.name = rootpath .. "/" .. animInfos.name;
   
    local skenode = skeletonnode();
    skenode:SetSkeletonAndAnims(skeletonPath,animInfos );
    self:AttachNode(skenode);
    self.skeletonNode = skenode;
    hasAnim = true;
    isHasScale = animInfos.hasscale;
  end
  
  for meshKey,meshValue in pairs(modelconfig.meshes) do
    local meshpath = meshValue.name;
    local submeshname = string.sub(meshpath,8,string.len(meshpath)-5);
    if self.submeshTexTable[submeshname] ~= nil then
      
      local meshFullPath = rootpath .. "/" .. meshpath;
      local diffusetex;
      local normaltex;
      local pbrtex;
      LOG("create submesh "..submeshname);
      local diffuseFullPath ;
      if vc.IFileSystem:isFileExist(self.submeshTexTable[submeshname]) then
        diffuseFullPath = self.submeshTexTable[submeshname];
      end
      local normalFullPath ;
      local pbrtextureFullPath ;
      local materialtype;
      local ispbr = false;
      local reflectiontex;
      local reflectionfullPath;
      
      local specshadertable ;
      if  self.submeshRefTable[submeshname]~=nil then
        specshadertable = self.submeshRefTable[submeshname].specshader
      end
      
      local material = meshValue.material;
      if material then
        materialtype = material.alphamode;
        materialtype = MaterialType.MT_TRANSPARENT;
        if material.normaltexture then
          normaltex = material.normaltexture.path;
        end
        
        if material.pbrmetallicroughness.basecolortexture then
          diffusetex = material.pbrmetallicroughness.basecolortexture.path;
        end
    
        if material.reflectiontexture or self.submeshRefTable[submeshname]~=nil then
          if self.submeshRefTable[submeshname]~=nil then
            reflectiontex = self.submeshRefTable[submeshname].tex;
            reflectionfullPath = self.submeshRefTable[submeshname].tex;
          else
            reflectiontex = material.reflectiontexture.path;
          end
            
        end
      end
      
      if diffusetex and diffuseFullPath==nil  then
        LOG("USE VENUS CONFIG")
        diffuseFullPath = rootpath .. "/" .. diffusetex;
      end
      if normaltex and normalFullPath==nil then
        normalFullPath = rootpath .. "/" .. normaltex;
      end
      if reflectiontex and reflectionfullPath==nil then
          reflectionfullPath = rootpath .. "/" .. reflectiontex; 
      end
    
      local materialFullPath = defmaterial or defiend.model_simple_material_path;
      if material.pbrmetallicroughness.metallicroughnesstexture ~= nil then  --pbr材质
        ispbr = true;
        materialFullPath = defiend.model_pbr_material_path;
        if pbrtextureFullPath==nil then
          pbrtex = material.pbrmetallicroughness.metallicroughnesstexture.path;
          pbrtextureFullPath = rootpath .. "/" .. pbrtex;
        end
      end
    
      
      local maxBone = meshValue.maxbonecnt;
    
      local transList = meshValue.translation;
      local rotList = meshValue.rotation;
      local scaleList = meshValue.scale;
      
      local bindmin = meshValue.boundingbox.min;
      local bindmax = meshValue.boundingbox.max;
      
      local bindboxV = mathfunction.Aabbox3d(
        mathfunction.vector3(bindmin[1],bindmin[2],bindmin[3]),
        mathfunction.vector3(bindmax[1],bindmax[2],bindmax[3]));
      
      if hasAnim and maxBone~=nil then
        local suffix = materialtype == MaterialType.MT_TRANSPARENT and "_t" or "";
        local materialpath = 
          ispbr
            and (isHasScale and defiend.model_pbr_matrix_material_path or defiend.model_pbr_dual_material_path)
            or (isHasScale and defiend.model_matrix_material_path or defiend.model_dual_material_path)
        materialFullPath = string.format(materialpath, maxBone,suffix);
      
        self.isSkined = true;
      end
    
      local modelnode = modelnode();
      if self.keepsource then
        modelnode:SetKeepSource(self.keepsource);
      end
      
      if diffuseFullPath then 
        modelnode:PushTextureMetadata(apolloengine.ShaderEntity.TEXTURE_DIFFUSE,diffuseFullPath);
      end 
    
      if normalFullPath then
        modelnode:PushTextureMetadata(apolloengine.ShaderEntity.TEXTURE_BUMP,normalFullPath);
      end
      local UNIFORM_REFFACTOR 
      if reflectionfullPath then 
         UNIFORM_REFFACTOR = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,"UNIFORM_REFFACTOR");
          
          materialFullPath = defiend.model_reflection_path;
      
          modelnode:PushTextureMetadata(apolloengine.ShaderEntity.TEXTURE_REFLECTION,reflectionfullPath,apolloengine.TextureEntity.TW_MIRRORED_REPEAT);
      end
      
      if material.pbrmetallicroughness.metallicroughnesstexture ~= nil then  --pbr材质
        modelnode:PushTextureMetadata(apolloengine.ShaderEntity.TEXTURE_AMR,pbrtextureFullPath);
        modelnode:PushTextureMetadata(apolloengine.ShaderEntity.TEXTURE_NORMAL,normalFullPath);
        modelnode:PushTextureMetadata(apolloengine.ShaderEntity.TEXTURE_ALDEBO,diffuseFullPath);
      end
    
      if reflectionfullPath then 
        if specshadertable~=nil then
          LOG("AND SPEC TEXTURE")
          modelnode:PushTextureMetadata(apolloengine.ShaderEntity.TEXTURE_NORMAL,specshadertable["bump"],apolloengine.TextureEntity.TW_MIRRORED_REPEAT);
         modelnode:PushTextureMetadata(apolloengine.ShaderEntity.TEXTURE_EMSSION,specshadertable["emissive"],apolloengine.TextureEntity.TW_MIRRORED_REPEAT);
        --[[  modelnode:PushTextureMetadata(apolloengine.ShaderEntity.TEXTURE_EMSSION,specshadertable[],apolloengine.TextureEntity.TW_MIRRORED_REPEAT);]]
          materialFullPath = defiend.diff_specular_bump_env_opaque_lighting;
        end
       
      end
      
      self.nodes[meshpath] = modelnode;
      LOG(materialFullPath);
      res = res and modelnode:CreateResource(meshFullPath,materialFullPath,nil,nil,nil, nil, memoryuseage);
      
      if reflectionfullPath then
        modelnode:SetParameter(UNIFORM_REFFACTOR,mathfunction.vector1(self.submeshRefTable[submeshname].value));
      end
        
      modelnode:SetBindBox(bindboxV);
      bind:Contains(bindboxV);
    
      if(maxBone~=nil) and self.skeletonNode~=nil then
        local skinCom = modelnode:CreateComponent(apolloengine.Node.CT_SKIN);

        skinCom:SetHasScale(isHasScale);
        skinCom:SetSkeletonComponent(self.skeletonNode.skeleton);
        table.insert(self.skincoms,skinCom);
      end
    
    
      self:AttachNode(modelnode);
    end
    
    self.bindbox:SetBindBox(bind);
  end
  return res;
end

function modelnode3New:CreateResource3(rootpath, defmaterial, memoryuseage)
  local res = true;
  memoryuseage = memoryuseage or apolloengine.VertexBufferEntity.MU_STATIC;
  local configFullPath = rootpath .. "/" .. "config.json";
  local modelconfig = venusjson.LaodJsonFile(configFullPath);
  if modelconfig.version ~= 3 then
    return false;
  end
  self.version = 3;
  local bind = mathfunction.Aabbox3d();

  local hasAnim = false;
  local isHasScale = false;


  if modelconfig.skeleton ~= nil then
    local skeletonPath = modelconfig.skeleton.name;
    skeletonPath = rootpath .. "/" .. skeletonPath;
    local animInfos
    local originalName
    if modelconfig.skeleton.animation~=nil then
      animInfos =  modelconfig.skeleton.animation;
      originalName = modelconfig.skeleton.originalani.original
    end

    if animInfos ~= nil then
      local animationCount = table.getn(animInfos);
      if originalName == "" then
        originalName = animInfos.name
      end
      for i = 1, animationCount, 1 do
        animInfos[i].name = rootpath .. "/" .. animInfos[i].name;
      end
      isHasScale = modelconfig.skeleton.scale.hasscale;
      hasAnim = true;
    else
      isHasScale = true;
    end
    local skenode = skeletonnode();

    skenode:SetSkeletonAndAnims2(skeletonPath,animInfos,isHasScale, originalName);

    self:AttachNode(skenode);
    self.skeletonNode = skenode;
  end

  for meshKey,meshValue in pairs(modelconfig.meshes) do
    local meshpath = meshValue.name;
    local submeshname = string.sub(meshpath,8,string.len(meshpath)-5);
    if self.submeshTexTable[submeshname] ~= nil then

      local meshFullPath = rootpath .. "/" .. meshpath;
      local diffusetex;
      local normaltex;
      local pbrtex;
      LOG("create submesh "..submeshname);
      local diffuseFullPath ;
      if vc.IFileSystem:isFileExist(self.submeshTexTable[submeshname]) then
        diffuseFullPath = self.submeshTexTable[submeshname];
      end
      local normalFullPath ;
      local pbrtextureFullPath ;
      local materialtype;
      local ispbr = false;
      local reflectiontex;
      local reflectionfullPath;
      
      local specshadertable ;
      if  self.submeshRefTable[submeshname]~=nil then
        specshadertable = self.submeshRefTable[submeshname].specshader
      end

      local material = meshValue.material;
      if material then
        materialtype = material.alphamode;
        materialtype = MaterialType.MT_TRANSPARENT;
        if material.normaltexture then
          normaltex = material.normaltexture.path;
        end

        if material.pbrmetallicroughness.basecolortexture then
          diffusetex = material.pbrmetallicroughness.basecolortexture.path;
        end

        if material.reflectiontexture or self.submeshRefTable[submeshname]~=nil then
          if self.submeshRefTable[submeshname]~=nil then
            reflectiontex = self.submeshRefTable[submeshname].tex;
            reflectionfullPath = self.submeshRefTable[submeshname].tex;
          else
            reflectiontex = material.reflectiontexture.path;
          end

        end
      end

      if diffusetex and diffuseFullPath==nil  then
        LOG("USE VENUS CONFIG")
        diffuseFullPath = rootpath .. "/" .. diffusetex;
      end
      if normaltex and normalFullPath==nil then
        normalFullPath = rootpath .. "/" .. normaltex;
      end
      if reflectiontex and reflectionfullPath==nil then
        reflectionfullPath = rootpath .. "/" .. reflectiontex;
      end

      local materialFullPath = defmaterial or defiend.model_simple_material_path;
      if material.pbrmetallicroughness.metallicroughnesstexture ~= nil then  --pbr材质
        ispbr = true;
        materialFullPath = defiend.model_pbr_material_path;
        if pbrtextureFullPath==nil then
          pbrtex = material.pbrmetallicroughness.metallicroughnesstexture.path;
          pbrtextureFullPath = rootpath .. "/" .. pbrtex;
        end
      end


      local maxBone = meshValue.maxbonecnt;

      local transList = meshValue.translation;
      local rotList = meshValue.rotation;
      local scaleList = meshValue.scale;

      local bindmin = meshValue.boundingbox.min;
      local bindmax = meshValue.boundingbox.max;

      local bindboxV = mathfunction.Aabbox3d(
              mathfunction.vector3(bindmin[1],bindmin[2],bindmin[3]),
              mathfunction.vector3(bindmax[1],bindmax[2],bindmax[3]));

      if hasAnim and maxBone~=nil then
        local suffix = materialtype == MaterialType.MT_TRANSPARENT and "_t" or "";
        local materialpath =
        ispbr
                and (isHasScale and defiend.model_pbr_matrix_material_path or defiend.model_pbr_dual_material_path)
                or (isHasScale and defiend.model_matrix_material_path or defiend.model_dual_material_path)
        materialFullPath = string.format(materialpath, maxBone,suffix);

        self.isSkined = true;
      end

      local modelnode = modelnode();
      if self.keepsource then
        modelnode:SetKeepSource(self.keepsource);
      end

      if diffuseFullPath then
        modelnode:PushTextureMetadata(apolloengine.ShaderEntity.TEXTURE_DIFFUSE,diffuseFullPath);
      end

      if normalFullPath then
        modelnode:PushTextureMetadata(apolloengine.ShaderEntity.TEXTURE_BUMP,normalFullPath);
      end
      local UNIFORM_REFFACTOR
      if reflectionfullPath then
        UNIFORM_REFFACTOR = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,"UNIFORM_REFFACTOR");

        materialFullPath = defiend.model_reflection_path;

        modelnode:PushTextureMetadata(apolloengine.ShaderEntity.TEXTURE_REFLECTION,reflectionfullPath,apolloengine.TextureEntity.TW_MIRRORED_REPEAT);
        
        if specshadertable~=nil then
          LOG("AND SPEC TEXTURE")
          modelnode:PushTextureMetadata(apolloengine.ShaderEntity.TEXTURE_NORMAL,specshadertable["bump"],apolloengine.TextureEntity.TW_MIRRORED_REPEAT);
         modelnode:PushTextureMetadata(apolloengine.ShaderEntity.TEXTURE_EMSSION,specshadertable["emissive"],apolloengine.TextureEntity.TW_MIRRORED_REPEAT);
        --[[  modelnode:PushTextureMetadata(apolloengine.ShaderEntity.TEXTURE_EMSSION,specshadertable[],apolloengine.TextureEntity.TW_MIRRORED_REPEAT);]]
          materialFullPath = defiend.diff_specular_bump_env_opaque_lighting;
        end
      end

      if material.pbrmetallicroughness.metallicroughnesstexture ~= nil then  --pbr材质
        modelnode:PushTextureMetadata(apolloengine.ShaderEntity.TEXTURE_AMR,pbrtextureFullPath);
        modelnode:PushTextureMetadata(apolloengine.ShaderEntity.TEXTURE_NORMAL,normalFullPath);
        modelnode:PushTextureMetadata(apolloengine.ShaderEntity.TEXTURE_ALDEBO,diffuseFullPath);
        
      end

      self.nodes[meshpath] = modelnode;
      LOG(materialFullPath);
      res = res and modelnode:CreateResource(meshFullPath,materialFullPath,nil,nil,nil, nil, memoryuseage);
      if reflectionfullPath then
        modelnode:SetParameter(UNIFORM_REFFACTOR,mathfunction.vector1(self.submeshRefTable[submeshname].value));
      end
      modelnode:SetBindBox(bindboxV);
      bind:Contains(bindboxV);

      if(maxBone~=nil) and self.skeletonNode~=nil then
        local skinCom = modelnode:CreateComponent(apolloengine.Node.CT_SKIN);

        skinCom:SetHasScale(isHasScale);
        skinCom:SetSkeletonComponent(self.skeletonNode.skeleton);
        table.insert(self.skincoms,skinCom);
      end


      self:AttachNode(modelnode);
    end

    self.bindbox:SetBindBox(bind);
  end
  return res;
end

return modelnode3New