local modelnode = require "apolloutility.apollonode.modelnode"
local apolloengine = require "apolloengine"

local modelnode3 = modelnode:extend();

local AS_ERROR = apolloengine.AnimationComponent.AS_ERROR;
local AS_PLAYING = apolloengine.AnimationComponent.AS_PLAYING;
local AS_DONE = apolloengine.AnimationComponent.AS_DONE;
local AS_STOP = apolloengine.AnimationComponent.AS_STOP;
local AS_PAUSE = AS_STOP + 500

function modelnode3:Play(delay, loop, lastingFrame, fadingFrame, doneCallback)

    if self.animStatus == AS_PAUSE or self.animStatus == AS_PLAYING then
        self.animStatus = AS_PLAYING
        return
    end

    self:Reset();
    self.animDelay = delay;
    self.animTime = 0;
    self.animLoop = 0

    if loop ~= nil then
        self.loopCount = loop;
    end

    if doneCallback ~= nil and doneCallback == true then
        self.OnAnimDone = modelnode3.defaultAnimCallback;
    elseif doneCallback ~= nil then
        self.OnAnimDone = doneCallback;
    end

    if self.loopCount == 0 then
        self:SetLoop(true);
    else
        self:SetLoop(false);
    end

    self.animStatus = AS_PLAYING;
    modelnode3.super.Play(self);
end

function modelnode3:Stop()
    self.loopCount = 0;
    self.animTime = -1;
    self.animDelay = 0;
    modelnode3.super.Stop(self)
    self:SetShow(false)
end

function modelnode3:Pause()
    self:setState("paused")
    self.animStatus = AS_PAUSE
    self.animPauseFrame = nil
end

function modelnode3:PauseInFirstFrame()
    self:setState("first_frame")
    self.animStatus = AS_PAUSE
    self.animPauseFrame = self:GetFrameCount() > 0 and 0 or -1
end

function modelnode3:PauseInLastFrame()
    self:setState("last_frame")
    self.animStatus = AS_PAUSE
    self.animPauseFrame = self:GetFrameCount() > 0 and (self:GetFrameCount() - 1) or -1
end

function modelnode3:Hide()
    self:Stop();
end

function modelnode3:TestTrigger()
    if self.triggerFlag then
        self.triggerFlag = false
        return self.cur_state3
    end
    return nil
end

function modelnode3:setState(state)
    if self.cur_state3 ~= state then
        self.triggerFlag = true
        self.cur_state3 = state
    end
end

function modelnode3:new()
    modelnode3.super.new(self);
    self.cur_state3 = "invisible";
    self.triggerFlag = false;
    self.loopCount = 0;
    self.animLoop = 0;
    self.animTime = -1;
    self.animDelay = 0;
    self.animFPS = 30
    self.animStatus = AS_STOP;
    self.animPauseFrame = nil;
end

function modelnode3:SetShow(isshow)
    modelnode3.super.SetShow(self, isshow);
    if isshow then
        self:setState("playing")
    else
        self:setState("invisible")
    end
end

function modelnode3:defaultAnimCallback()
    self:SetShow(false);
end

function modelnode3:UpdateAnimation(def)

    if self.animStatus == AS_PAUSE then
        if self.animPauseFrame ~= nil then
            if self.animPauseFrame ~= -1 then
                self:Reset(self.animPauseFrame)
            else
                self:Reset()
            end
        end
    end

    if self.animStatus ~= AS_PLAYING then
        return self.animStatus
    end

    if self.animTime >= 0 then
        self.animTime = self.animTime + def;
    end

    if self.animTime > self.animDelay / self.animFPS then

        self:SetShow(true);

        local res = modelnode3.super.UpdateAnimation(self, def);

        if res == AS_DONE then
            self.animLoop = self.animLoop + 1;
            if self.loopCount > 0 then
                if self.animLoop < self.loopCount then
                    self:Reset();
                else
                    self.animStatus = AS_DONE
                    if self.OnAnimDone ~= nil then
                        self.OnAnimDone(self)
                    end
                end
            end
        elseif res == AS_ERROR then
            self.animStatus = AS_ERROR;
        elseif res == AS_STOP then
            self.animStatus = AS_STOP
        end
    end
    return self.animStatus;
end

return modelnode3