local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local venusjson = require "venusjson"
local Object = require "classic"
local trasnnode = require "apolloutility.apollonode.trasnnode"
local meshnode = require "apolloutility.apollonode.meshnode"
local modelnode3 = require "facecute.3dsticker.modelnode3New"
local modelnode3Old = require "facecute.3dsticker.modelnode3Old"
local vc = require "venuscore"
local metascene = Object:extend();

function metascene:new()
    metascene.super.new(self);
    self.roots = {};
    self.gameobjects = {};
    self.meshtoobject = {};
end

function metascene:ParseSubMeshAndTexture(gameobjectconfig,para)
    if gameobjectconfig.meshrenderer~=nil or gameobjectconfig.skinnedmeshrenderer~=nil then
        local renderer = gameobjectconfig.meshrenderer;
        if renderer == nil then
            renderer = gameobjectconfig.skinnedmeshrenderer;
        end
        local mesh = renderer.mesh;
        if mesh==nil then
            mesh = renderer.skinnedmesh
        end

        mesh= string.sub(mesh, 1, -5);
        local modelPath = para[1] .. "/_metascene/" .. mesh;
       
        local diffuseFullPath;
        if renderer.materialdef.diffusemap~=nil then
            diffuseFullPath = para[1] .. "/_metascene/" .. renderer.materialdef.diffusemap;
        end

        local reflectionPath;
        local reflectionfactor = 0;
        if renderer.materialdef.reflectionmap~=nil and renderer.materialdef.reflectionmap~="" then
            reflectionPath = para[1] .. "/_metascene/" .. renderer.materialdef.reflectionmap;
            reflectionfactor = renderer.materialdef.reflectionfactor;
        end
        local ret = string.gsub( renderer.submesh,":","_");
        
        local emissivepath,bumppath;
        local specshadertable = nil;
        if renderer.materialdef.emissivemap~=nil and renderer.materialdef.bumpmap~=nil 
        and   renderer.materialdef.shader == "sensetime/diff_specular_bump_env_opaque_lighting"   then
            specshadertable = {};
            emissivepath = para[1] .. "/_metascene/" .. renderer.materialdef.emissivemap;
            bumppath = para[1] .. "/_metascene/" .. renderer.materialdef.bumpmap;
            specshadertable["mesh"] = retl
            specshadertable["diffuse"] = diffuseFullPath;
            specshadertable["reflect"] = reflectionPath;
            specshadertable["emissive"] = emissivepath;
            specshadertable["bump"] = bumppath;
        end
        
      
        return diffuseFullPath, ret,modelPath ,reflectionPath,reflectionfactor,specshadertable;
    end

end

function metascene:ParseGO(gameobjectconfig,currentidx,para)
    if gameobjectconfig[currentidx].meshrenderer==nil and gameobjectconfig[currentidx].skinnedmeshrenderer==nil then
        if gameobjectconfig[currentidx].children~=nil  then
           
            for i=1,table.getn(gameobjectconfig[currentidx].children) do
   
                return self:ParseGO(gameobjectconfig,gameobjectconfig[currentidx].children[i]+1,para);
            end
        end
    else
        return self:ParseSubMeshAndTexture(gameobjectconfig[currentidx],para);
    end
end

function metascene:ParseConfig3(config, para, goNameList,old)
    local submeshTexTable = {};
    self.config = config
    if self.config == nil or self.config.gameobject == nil then
        LOG("metascene:ParseConfig3PARSE ERROR")
        return false
    end
    local parsed = {};
    self.modeltosubmap = {};
    self.modeltorefmap = {};
    for i=2,table.getn(self.config.gameobject),1 do
        if parsed[i] == nil then
            local gameobjectconfig = self.config.gameobject[i];
            local submeshTexTable = {};
            local submeshRefTable = {};
            local goname = gameobjectconfig.name;
            self:ParseOne(para,config,i,parsed,submeshTexTable,submeshRefTable);
            LOG(goname.."TEST")
            self.modeltosubmap[goname] = submeshTexTable;
            self.modeltorefmap[goname] = submeshRefTable;
        end
    end
    return true
end

function metascene:GetSubMeshAndTex(goname)
    return self.modeltosubmap[goname],self.modeltorefmap[goname];
end

function metascene:ParseOne(para,config,index,parsed,submeshTexTable,submeshRefTable)
    if parsed[index]~=nil then
        return;
    end
    local gameobjectconfig = self.config.gameobject[index];
    local tex,submesh,modelpath,reflectionPath,reffactor, specshadertable= self:ParseSubMeshAndTexture(gameobjectconfig,para);
    if tex~=nil and modelpath~=nil and submesh~=nil then

        
        submeshTexTable[submesh] = tex;
       
        if reflectionPath~=nil and  vc.IFileSystem:isFileExist(reflectionPath)  then
            LOG("INSERT "..submesh.." AND "..reflectionPath);
            submeshRefTable[submesh] = {}
            submeshRefTable[submesh].tex = reflectionPath;
            submeshRefTable[submesh].value = reffactor;
            
            if specshadertable~=nil then
              submeshRefTable[submesh].specshader = specshadertable;
            end
        end
    end
    parsed[index] = true;
    local children = gameobjectconfig.children;
    if children~=nil then
        for i=1,table.getn(children) do
            self:ParseOne(para,config,children[i]+1,parsed,submeshTexTable,submeshRefTable);
        end
    end
end

function metascene:ParseConfig(configPath,para,goNameList,old)
    self.config = venusjson.LaodJsonFile(configPath);
    if self.config.gameobject ==nil then
        LOG("PARSE ERROR")
        return;
    end
    local parsed = {};
    
    for i=1,table.getn(self.config.gameobject),1 do
        local gameobjectconfig = self.config.gameobject[i];
        local position =  mathfunction.vector3( gameobjectconfig.translation[1],
                                                gameobjectconfig.translation[2],
                                                gameobjectconfig.translation[3]);

        local scale =  mathfunction.vector3(    gameobjectconfig.scale[1],
                                                gameobjectconfig.scale[2],
                                                gameobjectconfig.scale[3]);

        local rotation =  mathfunction.Quaternion(  gameobjectconfig.rotation[1],
                                                    gameobjectconfig.rotation[2],
                                                    gameobjectconfig.rotation[3],
                                                    gameobjectconfig.rotation[4]);
        
        if goNameList[gameobjectconfig.name]~=nil then
            local childrenIndex = gameobjectconfig.children;
            if childrenIndex~= nil then
                local submeshTexTable = {};
                local modelfullpath;
                local isModleParent = false;
                for i=1,table.getn(childrenIndex) do
                    local idx = childrenIndex[i]+1;
                    local childconfig = self.config.gameobject[idx];
                    -- local tex,submesh,model= self:ParseSubMeshAndTexture(childconfig,para);
                    local tex,submesh,model= self:ParseGO(self.config.gameobject,idx,para);
                    if tex~=nil then
                        isModleParent = true;
                        if modelfullpath==nil then
                            modelfullpath = model;
                        end
                        if modelfullpath~=model then
                            LOG("DIFFERENT FBX FOR A MODEL");
                        end
                        LOG("INSERT "..submesh.." AND "..tex)
                        if vc.IFileSystem:isFileExist(tex) then
                            LOG("actual insert "..submesh.." AND "..tex)
                            submeshTexTable[submesh] = tex;
                        end
                    end
                end
                if isModleParent==true then
                    local model;
                    if old ~=nil then
                        model = modelnode3Old();
                    else 
                        model = modelnode3();
                    end

                    model:SetTexturePath(submeshTexTable);
                    LOG("create model:"..gameobjectconfig.name)
                    model:CreateResource(modelfullpath);
                   
                    self.meshtoobject[gameobjectconfig.name] = model;
                end
            else
                local tex,submesh,modelpath,reffactor,specshadertable= self:ParseSubMeshAndTexture(gameobjectconfig,para);
                if tex~=nil and modelpath~=nil and submesh~=nil then
                    local model;
                    if old ~=nil then
                        model = modelnode3Old();
                    else 
                        model = modelnode3();
                    end
                    local submeshTexTable = {};
                    if vc.IFileSystem:isFileExist(tex) then
                        submeshTexTable[submesh] = tex;
                    end
                    model:SetTexturePath(submeshTexTable);
                    model:CreateResource(modelpath);
                    self.meshtoobject[gameobjectconfig.name] = model;
                end
            end
        end
    end
end



function metascene:GetModelNodeByMeshName(name)
    return  self.meshtoobject[name];
end

return metascene