local venusemoji = require "emoji.venusemoji"
local posture = require "facecute.estimates.transposture"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local videodecet = require "videodecet"
local venusjson = require "venusjson"
local venuscore = require "venuscore"

local emoji={};

function emoji:Initialize()
end

function emoji:LoadConfig(path)
  local rootconfig = venusjson.LaodJsonFile(path);
  if rootconfig.blendshape then
    local pathDir= string.match(path, "(.+)/[^/]*%.%w+$");
    local rootdir = pathDir.."/";
    venuscore.IFileSystem:SetResourcePath(rootdir);
    self.emoji3d = venusemoji();
    if self.emoji3d:ParseConfig(rootconfig.blendshape) == false then
      self.emoji3d = nil;
      return false;
    end
  end
  return true;
end

function emoji:ReleaseResource()
  if self.emoji3d then
    self.emoji3d = nil;
  end
end

function emoji:Positioning()
  local faces = videodecet:GetFaces();
  if faces then
    posture:Update(faces,maincamera);
    local postures = posture:GetPostures();
    if #postures >= 1 and self.emoji3d ~= nil then
      local est = postures[1];
      self.emoji3d:SetPosition(est);
      return true;
    end
  end
  return false;
end

function emoji:GetEmojiData()
  return self.emoji3d:ReceiveInputDatas(); 
end


function emoji:Update(def)
  if self.emoji3d then
    if self:Positioning() then
      local emoji_data = self:GetEmojiData();

      if(emoji_data == nil) then
        return;
      end

      self.emoji3d:UpdateData(emoji_data);
      self.emoji3d:UpdateModel(emoji_data, def);
      self.emoji3d:ShowModel(true);
    else
      self.emoji3d:ShowModel(false);
    end
  end
end

return emoji;
