local BundleSystem = require "venuscore.bundle.bundlesystem"
local renderqueue = require "apolloutility.renderqueue"
local apollonode = require "apolloutility.apollonode"
local defined = require "apolloutility.defiend"
local mathfunction = require "mathfunction"
local apolloengine = require "apollocore"
local videodecet = require "videodecet"
local venuscore = require "venuscore"
local venusjson = require "venusjson"
local Object = require "classic"

local editorscene = Object:extend();

function editorscene:new(insertlayer)
  self:Initialize()
  self.insertLayer = insertlayer;
end

function editorscene:Initialize()
  self.objects = {};
  
  self.lastCamera = nil;
  self.firstCamera = nil;
  self.sceneCamers = {};
  self.aniComponents = {};
  self.frameaniComponents = {};
  self.renderComponents = {};
  self.cpuEmitter = nil;
  
  self.inputtex = nil; --上层layer的结果
  self.outputtex = nil; -- 编辑器场景结果
  self.mainrt = nil; 
  self.firstquadnode = nil;
  
  self.index = nil;
  
  self.mainOutputCamera = nil;
  
  self.enable = true;

  --self.objectUsrscripts = {};
end

function editorscene:Update(def)
  
  --[[for key, value in pairs(self.objectUsrscripts) do
    value:Update(def);
  end]]--
  
  --纹理需要每帧设置，renderqueue中删除插入相机时纹理会变
  self.firstquadnode:SetParameter(apolloengine.ShaderEntity.TEXTURE_DIFFUSE, self.inputtex);
  
  for k,v in pairs(self.objects) do 
    if v.Update then
      v:Update(def)
    end
  end
end

function editorscene:LoadConfig(baseobject, mainrt)
    for i = 1, #baseobject do
      local nativeNode = baseobject[i]:GetNativeNode();
      local nodeType = baseobject[i]:GetTypeName();
      self.objects[tostring(nativeNode:GetObjectID())] = baseobject[i];
      
      if nodeType == "ParticleNode" then
        local rendercom = baseobject[i].RenerComponent;
        if rendercom then
          self.renderComponents[tostring(nativeNode.Layer)] = self.renderComponents[tostring(nativeNode.Layer)] or {};
          table.insert(self.renderComponents[tostring(nativeNode.Layer)],rendercom);
        end
        self.cpuEmitter = nativeNode;
      else
        local cameracom = baseobject[i]:GetComponent(apolloengine.Node.CT_CAMERA);
        if cameracom then
          cameracom:SetSequenceCulling(true);
          if self.firstCamera == nil or (self.firstCamera).Sequence > cameracom.Sequence then
            self.firstCamera = cameracom;
          end
          if self.lastCamera == nil or (self.lastCamera).Sequence < cameracom.Sequence then
            self.lastCamera = cameracom;
          end
          
          self.sceneCamers[tostring(cameracom.LayerMask)] = cameracom;
        end
        
        local rendercom = baseobject[i]:GetComponent(apolloengine.Node.CT_RENDER)
        if rendercom then
          self.renderComponents[tostring(nativeNode.Layer)] = self.renderComponents[tostring(nativeNode.Layer)] or {};
          table.insert(self.renderComponents[tostring(nativeNode.Layer)],rendercom);
        end

        local frameanicom = baseobject[i]:GetComponent(apolloengine.Node.CT_FRAME_PLAYER)
        if frameanicom then
          table.insert(self.frameaniComponents,frameanicom);
        end
        
        local animationcom = baseobject[i]:GetComponent(apolloengine.Node.CT_ANIMATION)
        if animationcom then
          table.insert(self.aniComponents,animationcom);
        end
      end
    end
    
    self:_CameraInit(mainrt);
    self:_RenderInit();
    self:_FramAniInit();
    self:_ParticleInit();
    self:_AnimationInit();
  return true;
end

function editorscene:GetFirstCamera()
  return self.firstCamera;
end

function editorscene:GetLastCamera()
  return self.lastCamera;
end

function editorscene:GetInputTexture()
  return self.inputtex;
end

function editorscene:GetOutputTexture()
  return self.outputtex;
end




function editorscene:_CameraInit(mainrt)
  local color = mathfunction.Color(1.0,0.5,0.5,1);
  if mainrt == nil then
    self.mainrt =  apolloengine.RenderTargetEntity();--创建一个FBO
    self.mainrt:PushMetadata(--设置FBO格式
                apolloengine.RenderTargetMetadata(
                  apolloengine.RenderTargetEntity.RT_RENDER_TARGET_2D,
                  apolloengine.RenderTargetEntity.ST_SWAP_UNIQUE,--标记作用，主要用于底层资源共享
                  apolloengine.Framework:GetViewport(),
                  apolloengine.Framework:GetResolution()));--分辨率
    self.mainrt:MakeBufferAttachment(apolloengine.RenderTargetEntity.TA_DEPTH_STENCIL);--增加color0纹理
    self.outputtex = self.mainrt:MakeTextureAttachment(apolloengine.RenderTargetEntity.TA_COLOR_0);--增加color0纹理
    self.outputtex:PushMetadata(--创建纹理
                apolloengine.TextureRenderMetadata(
                  apolloengine.RenderTargetEntity.ST_SWAP_UNIQUE,--此处的纹理swap和尺寸必须和rt的相同不然将导致未定义的错误
                  apolloengine.Framework:GetResolution()));
    self.mainrt:CreateResource();
  else
    self.mainrt = mainrt;
    self.outputtex = mainrt:GetAttachment(apolloengine.RenderTargetEntity.TA_COLOR_0)
  end
  
  --没有fbo的相机
  local inputcameras = {};
  for key,value in pairs (self.sceneCamers) do
    if value:GetAttachedRenderTarget() == nil then
      value:SetClearColor(color);
      value:AttachRenderTarget(self.mainrt);
      self.mainOutputCamera = value;  --保存编辑器相机做种的输出相机
    end
    table.insert(inputcameras,value);
  end
  
  --回调函数
  self.SettingInputTexture = function(texture)
    self.inputtex = texture;
  end
  
  self.GettingOutputTexture = function()
    local outtex = self.outputtex
    return outtex;
  end
  
  self.OnSequenceChanged = function()
    self:_RenderInit();  --renderqueue中删除相机的时候需要更新相机的sequence
    local sequnce = self.firstCamera:GetSequence();
    local layerMask = self.firstCamera.LayerMask;
    self.firstquadnode:SetLayer(layerMask);
    self.firstquadnode:SetSequence(sequnce);
    self.firstquadnode:SetName("Editor_Quad_Blit "..tostring(sequnce));
  end
  
  self.firstquadnode = apollonode.QuadNode();
  self.firstquadnode:CreateResource(defined.blit_material_path,true,false);
  --编辑器相机队列插入renderqueue相机队列
  self.index = renderqueue:InsertCameras(self.insertLayer,inputcameras,self.SettingInputTexture,self.GettingOutputTexture,self.OnSequenceChanged);

end

function editorscene:_RenderInit()
  for key,value in pairs (self.renderComponents) do
    local newsequence = (self.sceneCamers[key]).Sequence;
    for subkey,subvalue in pairs (value) do
      subvalue:SetSequence(newsequence);
    end
  end
end

function editorscene:_FramAniInit()
  for key,value in pairs (self.frameaniComponents) do
    value:Play();
  end
end

function editorscene:_ParticleInit()
  if self.cpuEmitter then
    self.cpuEmitter:Start();
  end
end

function editorscene:_AnimationInit()
    for key,value in pairs(self.aniComponents) do
      local animations = value:GetAnimations();
      for k,v in pairs(animations) do
        value:Play(k); 
        value:Loop(k,true);
      end
    end
end

function editorscene:SetMakeupStrength(strength, maketype)
  for k,v in pairs(self.objects) do 
    if v.Update and v.GetNativeNode then
      local node = v:GetNativeNode();
      local scriptCom = node:GetComponent(apolloengine.Node.CT_SCRIPT);
      if scriptCom then
        local paraSet = scriptCom.Instances
        for scrKey,scrValue in pairs(paraSet) do
          if scrValue["alphaTable"] ~= nil then
            scrValue:RecursiveNode(scrValue["Node"], strength);
            return true;
          end
        end
      end
    end
  end
end

function editorscene:ReleaseResource()
  
  self.objects = {};
  
  self.firstCamera = nil;
  self.lastCamera = nil;
  self.sceneCamers = {};
  self.aniComponents = {};
  self.frameaniComponents = {};
  self.renderComponents = {};
  self.cpuEmitter = nil;
  
  self.outputtex =  nil;
  self.inputtex = nil;
  self.mainrt = nil;
  self.firstquadnode = nil;
  
  self.SettingInputTexture = nil;
  self.GettingOutputTexture = nil;
  
  self.mainOutputCamera = nil;
  
  renderqueue:RemoveCameras(self.index);
  collectgarbage();
end

function editorscene:RemoveCurrentSceneCameras()
  renderqueue:RemoveCameras(self.index);
  --将之前场景中输出相机上挂在的RT移除掉
  self.mainOutputCamera:DetachRenderTarget(self.mainrt);
end

function editorscene:OnRecordStart()
  if not self.frameaniComponents or not self.aniComponents then
    return
  end
  
  for key,value in pairs (self.frameaniComponents) do
    value:Reset();
  end
  
  for key,value in pairs(self.aniComponents) do
    local animations = value:GetAnimations();
    for k,v in pairs(animations) do
      value:Reset(k); 
    end
  end
  
  if self.cpuEmitter then
    self.cpuEmitter:Reset();
  end
end


return editorscene;
