local BundleSystem = require "venuscore.bundle.bundlesystem"
local renderqueue = require "apolloutility.renderqueue"
local apollonode = require "apolloutility.apollonode"
local defined = require "apolloutility.defiend"
local mathfunction = require "mathfunction"
local apolloengine = require "apollocore"
local videodecet = require "videodecet"
local venuscore = require "venuscore"
local venusjson = require "venusjson"
local editorscene = require "editorscene"
local GenericNode = require "apolloengine.nodes.genericnode"

local editormakeupmanager = {}

function editormakeupmanager:Initialize(layer)
  self.scene = {};
  self.baseobjects = {};
  self.layer = layer;
  --[[
  local color = mathfunction.Color(1.0,0.5,0.5,1);
  self.mainrt =  apolloengine.RenderTargetEntity();--创建一个FBO
  self.mainrt:PushMetadata(--设置FBO格式
                apolloengine.RenderTargetMetadata(
                  apolloengine.RenderTargetEntity.RT_RENDER_TARGET_2D,
                  apolloengine.RenderTargetEntity.ST_SWAP_UNIQUE,--标记作用，主要用于底层资源共享
                  apolloengine.Framework:GetViewport(),
                  apolloengine.Framework:GetResolution()));--分辨率
  self.mainrt:MakeBufferAttachment(apolloengine.RenderTargetEntity.TA_DEPTH_STENCIL);--增加color0纹理
  self.outputtex = self.mainrt:MakeTextureAttachment(apolloengine.RenderTargetEntity.TA_COLOR_0);--增加color0纹理
  self.outputtex:PushMetadata(--创建纹理
                apolloengine.TextureRenderMetadata(
                  apolloengine.RenderTargetEntity.ST_SWAP_UNIQUE,--此处的纹理swap和尺寸必须和rt的相同不然将导致未定义的错误
                  apolloengine.Framework:GetResolution()));
  self.mainrt:CreateResource();
  ]]--
end

function editormakeupmanager:LoadConfig(path,makeuptype,rootconfig)
  if rootconfig.scene then
    if self.scene[makeuptype] ~= nil then --加载同类型素材
      self.scene[makeuptype]["scene"]:ReleaseResource();
      self.scene[makeuptype] = nil;
      self.baseobjects[makeuptype] = nil;
    end
    local pathDir= string.match(path, "(.+)/[^/]*%.%w+$");
    local rootdir = pathDir.."/"; 
    venuscore.IFileSystem:SetResourcePath(rootdir);
    local baseobject = self:CreateInstanceFromBundle(venuscore.IFileSystem:PathAssembly(rootconfig.scene));
    --local layer = renderqueue.CAMERA_LAYER_FIRST;
    local layer = self.layer - 1;
    --local newscene = editorscene(layer,self.mainrt);
    local newscene = editorscene(layer,self.mainrt);
    newscene:LoadConfig(baseobject);
    self.scene[makeuptype] = {["index"] = newscene.index,["scene"] = newscene};
    self.baseobjects[makeuptype] = {["index"] = newscene.index,["baseobject"] = baseobject};
  end
  return true;
end


function editormakeupmanager:CreateInstanceFromBundle(path)
  local bundlepath = venuscore.IFileSystem:PathAssembly(path);
  local file = io.open(bundlepath, "rb");
  local str = file:read("*a");
  return BundleSystem:DeSerialize(str);
end

function editormakeupmanager:OnRecordStart()
end

function editormakeupmanager:IsExistMakeup()
  --self.scene是makeuptype的hash表
  if next(self.scene) ~= nil then 
    return true;
  end
  return false;
end


function editormakeupmanager:ReleaseResource(makeuptype)
  if self.scene[makeuptype] ~= nil then
    self.baseobjects[makeuptype] = nil;
    self.scene[makeuptype]["scene"]:ReleaseResource();
    self.scene[makeuptype] = nil;
    collectgarbage();
    return true;
  end
  
  return false;
end


function editormakeupmanager:SetMakeupStrength(strength, maketype)
  if self.scene[maketype] ~= nil then
    self.scene[maketype]["scene"]:SetMakeupStrength(strength, maketype);
    return true;
  end
  
  return false;
end


function editormakeupmanager:Update(def)
  
  for k,v in pairs(self.scene) do 
    v["scene"]:Update(def)
  end
  
end

return editormakeupmanager;
