
local basedetect = require "videodecet.basevideodetect";
local apollonode = require "apolloutility.apollonode"
local filterqueue = require "apolloutility.filterqueue" 

local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local venuscore = require "venuscore"
local videodecet = require "videodecet"
local likeapp = require "likeapp"
local Object = require "classic"



local CustomTexture = {}

function CustomTexture:Initialize()
  self.customtexture_map = {};
  self.customtexture_size = {};
  self.isNew = true;
end

function CustomTexture:Clear()
  self.customtexture_map = {};
  self.customtexture_size = {};
end





function CustomTexture:GetCustomTexture(id)
  
  local isCustomTextureChanged = likeapp.AI:IsCustomTextureChanged(id);
  if self.isNew == true or isCustomTextureChanged == true then
    local ts = likeapp.AI:GetCustomTexture(id);
    if ts then
      LOG("superme change texture, Request id is: " .. tostring(id));
      local custom_texture = apolloengine.TextureEntity();
      custom_texture:PushMetadata(
      apolloengine.TextureBufferMetadata(
          apolloengine.TextureEntity.TU_STATIC,
          1, false,
          apolloengine.TextureEntity.TW_CLAMP_TO_EDGE,
          apolloengine.TextureEntity.TW_CLAMP_TO_EDGE,
          apolloengine.TextureEntity.TF_LINEAR,
          apolloengine.TextureEntity.TF_LINEAR,
          ts));
      custom_texture:SetJobType(venuscore.IJob.JT_SYNCHRONOUS);
      custom_texture:CreateResource();
      self.customtexture_map[id] = custom_texture;  --保存用户纹理
      
      local customtexture_size = ts:GetSize();
      self.customtexture_size[id] =  ts:GetSize();  --保存用户纹理大小
      self.isNew = false;
    else
      LOG("superme texture is null! Request id is: " .. tostring(id));
    end
  end
  
  return self.customtexture_map[id],self.customtexture_size[id];
end



return CustomTexture;



