local venuscore = require "venuscore"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"

local TestBehavior = venuscore.VenusBehavior:extend("TestBehavior"); 

function TestBehavior:new()
  self.size = 1.0;
  self.isactive = true;
  self.offset = mathfunction.vector3();
  self.float = mathfunction.vector1();
  self.uv = mathfunction.vector2();
  self.pos = mathfunction.vector4();
  self.path = "docs:tt.jpg"
  self.rotation = mathfunction.Quaternion();
  self.test = {}
  self.test.rotation = mathfunction.Quaternion();
  self.test.path = "docs:tt.jpg"
  self.Component = nil;
  self.enum = 1;
end

function TestBehavior:Awake()
  --self.Component = self.Node:GetComponent(apolloengine.Node.CT_TRANSFORM);
end

function TestBehavior:Update(def)
end

function TestBehavior:GetCombo()
  --LOG("GetCombo");
  return self.enum;
end

function TestBehavior:SetCombo(value)
  LOG("SetCombo");
  self.enum = value;
end

function TestBehavior:GetComponent()
  return self.Component;
end

function TestBehavior:SetComponent(value)
  self.Component = value;
end

--注册要写在最下面，不然没有TestBehavior.GetCombo这些函数
TestBehavior:MemberRegister("offset");
TestBehavior:MemberRegister("isactive");
TestBehavior:MemberRegister("path");
TestBehavior:MemberRegister("rotation");
TestBehavior:MemberRegister("float");
TestBehavior:MemberRegister("uv");
TestBehavior:MemberRegister("pos");
TestBehavior:MemberRegister("enum",  
  venuscore.ScriptTypes.ComboType(
    {
      {
        key = "Left",
        value = 0
      },
      {
        key = "Right",
        value = 1
      },
    },
    TestBehavior.GetCombo,
    TestBehavior.SetCombo
  ));
TestBehavior:MemberRegister("Component",
  venuscore.ScriptTypes.ReferenceType(
    apolloengine.IComponent:RTTI(),    
    TestBehavior.GetComponent,
    TestBehavior.SetComponent
  )); 

TestBehavior:MemberRegister("ArrayTest",
  venuscore.ScriptTypes.FloatArrayType(2)); 


return TestBehavior;