local vc = require "venuscore"
local ae = require "apolloengine"
local mf = require "mathfunction"

local StickerBehavior = require "behavior.test_venus_sticker_behavior_imp"

--TODO
local objectTypeComboData = 
{
  {
    key = "Base",
    value = StickerBehavior.StickerObjectBase
  },
  {
    key = "Timer",
    value = StickerBehavior.StickerTimer
  },
  {
    key = "Face",
    value = StickerBehavior.StickerTimer
  },
  {
    key = "Hand",
    value = StickerBehavior.StickerTimer
  },
  {
    key = "Logger",
    value = StickerBehavior.StickerLogger
  }
};

-----------------------

local StickerObjectDesc = vc.VenusBehavior:extend("StickerObjectDesc")

function StickerObjectDesc:new(root)
  self._root = root
  self.id = string.format("object%03d", self._root:NextObject())
  self.type = StickerBehavior.StickerObjectBase
end

StickerObjectDesc:MemberRegister("id");
StickerObjectDesc:MemberRegister(
  "type",
  vc.ScriptTypes.ComboType(
    objectTypeComboData
  )
);

local StickerObjectItem = vc.VenusBehavior:extend("StickerObjectItem")

function StickerObjectItem:new(root)
  self._root = root
  self.value = ""
end

StickerObjectItem:MemberRegister(
  "value",
  vc.ScriptTypes.ComboType(
    function(thiz)
      return thiz._root:GetObjectIdCombo();
    end
  )
);

local StickerGroupDesc = vc.VenusBehavior:extend("StickerGroupDesc")

function StickerGroupDesc:new(root)
  self._root = root
  self.id = string.format("group%03d", self._root:NextGroup())
  self.objects = {}
end

StickerGroupDesc:MemberRegister("id");
StickerGroupDesc:MemberRegister(
  "objects",
  vc.ScriptTypes.ArrayType(
    function(thiz)
      return StickerObjectItem(thiz._root)
    end,
    function (thiz)
      return { unpack(thiz.objects) }
    end,
    function (thiz, value)
      thiz.objects = { unpack(value) }
    end
  )
);

------------------

local stickerStateDescTag =
{
  shallShowItem = function(desc, key, value)
    if key == "category" then
      return true
    end
    if desc.category == "all" or
       desc.category == "any" or
       desc.category == "random" then
      return key == "list"
    else
      return key ~= "list"
    end
  end
};

------------------

local stickerBoolStateCombo =
{
  {
    key = "Not Care",
    value = nil,
  },
  {
    key = "False",
    value = false,
  },
  {
    key = "True",
    value = true,
  },
};

local StickerTriggerDesc = vc.VenusBehavior:extend("StickerTriggerDesc")

function StickerTriggerDesc:new(root)
  self._root = root
  self.category = "all"
  self.id = ""
  self.prop = ""
  self.prev = nil
  self.curr = nil
  self.list = {}
end

StickerTriggerDesc:MemberRegister(
  "category",
  vc.ScriptTypes.ComboType(
    {
      {
        key = "All",
        value = "all"
      },
      {
        key = "Any",
        value = "any"
      },
      {
        key = "Object",
        value = "object"
      },
    }
  )
);
StickerTriggerDesc:MemberRegister(
  "id",
  vc.ScriptTypes.ComboType(
    function (thiz)
      if thiz.category == "object" then
        return thiz._root:GetObjectIdCombo()
      else
        return {}
      end
    end
  )
);
StickerTriggerDesc:MemberRegister(
  "prop",
  vc.ScriptTypes.ComboType(
    function (thiz)
      if thiz.category == "object" then
        return thiz._root:GetObjectProps(thiz.id)
      else
        return {}
      end
    end
  )
);

StickerTriggerDesc:MemberRegister(
  "prev",
  vc.ScriptTypes.ComboType(stickerBoolStateCombo)
);
StickerTriggerDesc:MemberRegister(
  "curr",
  vc.ScriptTypes.ComboType(stickerBoolStateCombo)
);

StickerTriggerDesc:MemberRegister(
  "list",
  vc.ScriptTypes.ArrayType(
    function(thiz)
      return StickerTriggerDesc(thiz._root)
    end,
    function (thiz)
      return { unpack(thiz.list) }
    end,
    function (thiz, value)
      thiz.list = { unpack(value) }
    end
  ),
  {
    itemTag = stickerStateDescTag
  }
);

------------------


local StickerActionDesc = vc.VenusBehavior:extend("StickerActionDesc")

function StickerActionDesc:new(root)
  self._root = root
  self.category = "all"
  self.targetGroup = "local"
  self.id = ""
  self.prop = ""
  self.next = nil
  self.list = {}
end

StickerActionDesc:MemberRegister(
  "category",
  vc.ScriptTypes.ComboType(
    {
      {
        key = "All",
        value = "all"
      },
      {
        key = "Any",
        value = "any"
      },
      {
        key = "Random",
        value = "random"
      },
      {
        key = "Object",
        value = "object"
      },
    }
  )
);
StickerActionDesc:MemberRegister(
  "targetGroup",
  vc.ScriptTypes.ComboType(
    {
      {
        key = "Local",
        value = "local"
      },
      {
        key = "All",
        value = "all"
      }
    }
  )
);
StickerActionDesc:MemberRegister(
  "id",
  vc.ScriptTypes.ComboType(
    function (thiz)
      if thiz.category == "object" then
        return thiz._root:GetObjectIdCombo()
      else
        return {}
      end
    end
  )
);
StickerActionDesc:MemberRegister(
  "prop",
  vc.ScriptTypes.ComboType(
    function (thiz)
      if thiz.category == "object" then
        return thiz._root:GetObjectProps(thiz.id)
      else
        return {}
      end
    end
  )
);

StickerActionDesc:MemberRegister(
  "next",
  vc.ScriptTypes.ComboType(stickerBoolStateCombo)
);

StickerActionDesc:MemberRegister(
  "list",
  vc.ScriptTypes.ArrayType(
    function(thiz)
      return StickerActionDesc(thiz._root)
    end,
    function (thiz)
      return { unpack(thiz.list) }
    end,
    function (thiz, value)
      thiz.list = { unpack(value) }
    end
  ),
  {
    itemTag = stickerStateDescTag
  }
);

------------------

local StickerTransitionDesc = vc.VenusBehavior:extend("StickerTransitionDesc");

function StickerTransitionDesc:new(root)
  self._root = root
  self.name = string.format("transition%03d", self._root:NextTransition())
  self.trigger = StickerTriggerDesc(self._root)
  self.action = StickerActionDesc(self._root)
end

StickerTransitionDesc:MemberRegister("name");
StickerTransitionDesc:MemberRegister("trigger", nil, stickerStateDescTag);
StickerTransitionDesc:MemberRegister("action", nil, stickerStateDescTag);

------------------

local StickerBehaviorBtnConfirm = vc.VenusBehavior:extend("StickerBehaviorBtnConfirm");

function StickerBehaviorBtnConfirm:new(root)
  self._root = root;
end

function StickerBehaviorBtnConfirm:OnBtn()
  self._root:OnConfirm();
end

-----------------

local StickerBehaviorDesc = vc.VenusBehavior:extend("StickerBehaviorDesc");

function StickerBehaviorDesc:new()
  self.version = 1
  self.title = ""
  self.objects = {}
  self.groups = {}
  self.transitions = {}
  self.confirm = StickerBehaviorBtnConfirm(self)
  self.objectCounter = 1
  self.groupCounter = 1
  self.transitionCounter = 1
end

function StickerBehaviorDesc:GetObjectIdCombo()
  local objects = self.objects;
  local count = #objects;
  local combo = {}
  for i = 1, count do
    table.insert(
      combo,
      {
        key = objects[i].id,
        value = objects[i].id
      }
    )
  end
  return combo
end

function StickerBehaviorDesc:GetObjectProps(id)
  local objects = self.objects;
  local count = #objects;
  local props = {}
  for i = 1, count do
    local objectDesc = objects[i]
    if objectDesc.id == id then
      props = objectDesc.type:GetProperties()
      break
    end
  end
  local combo = {}
  for i = 1, #props do
    table.insert(
      combo,
      {
        key = props[i],
        value = props[i]
      }
    )
  end
  return combo
end

StickerBehaviorDesc:MemberRegister("version", nil, "dragInt");
StickerBehaviorDesc:MemberRegister("title");
StickerBehaviorDesc:MemberRegister(
  "objects",
  vc.ScriptTypes.ArrayType(
    function(thiz)
      return StickerObjectDesc(thiz)
    end,
    function (thiz)
      return { unpack(thiz.objects) }
    end,
    function (thiz, value)
      thiz.objects = { unpack(value) }
    end
  )
);
StickerBehaviorDesc:MemberRegister(
  "groups",
  vc.ScriptTypes.ArrayType(
    function(thiz)
      return StickerGroupDesc(thiz)
    end,
    function (thiz)
      return{ unpack(thiz.groups) }
    end,
    function (thiz, value)
      thiz.groups = { unpack(value) }
    end
  )
);
StickerBehaviorDesc:MemberRegister(
  "transitions",
  vc.ScriptTypes.ArrayType(
    function(thiz)
      return StickerTransitionDesc(thiz)
    end,
    function (thiz)
      return{ unpack(thiz.transitions) }
    end,
    function (thiz, value)
      thiz.transitions = { unpack(value) }
    end
  )
);

StickerBehaviorDesc:MemberRegister("confirm", nil, "button");

function StickerBehaviorDesc:OnConfirm()
  LOG("SUNTYLOG: OnConfirm")
  self._behavior = StickerBehavior(self)
end

function StickerBehaviorDesc:Update(delta)
  --LOG("SUNTYLOG: StickerBehaviorDesc:Update " .. tostring(delta))
  if self._behavior then
    self._behavior:Update(delta)
  end
end

function StickerBehaviorDesc:NextObject()
  local r = self.objectCounter
  self.objectCounter = self.objectCounter + 1
  return r
end

function StickerBehaviorDesc:NextGroup()
  local r = self.groupCounter
  self.groupCounter = self.groupCounter + 1
  return r
end

function StickerBehaviorDesc:NextTransition()
  local r = self.transitionCounter
  self.transitionCounter = self.transitionCounter + 1
  return r
end

return StickerBehaviorDesc;