local venuscore = require "venuscore"
local venusjson = require "venusjson"
local mathfunction = require "mathfunction"
local apolloengine = require "apolloengine"
local apollocore = require "apollocore"
local define = require "behavior.cosmetic_lipstick.lipstick_layer_defines"
local faceseg = require "videodecet.faceseg"
local facecnndetect = require "videodecet.facecnndetect"
local videodefined = require "videodecet.defined"
local headtarget =  require "facecute.headtarget"
local immortal =  require "facecute.immortal"
local videodecet = require "videodecet"
local detectservice = require "videodecet.mldetection"
local facedefined = require "facecute.facechange.facedefined"
local imageutility = require "imageutility"



local texturetest = venuscore.VenusBehavior:extend("texturetest");



texturetest:MemberRegister("FaceDetection");



--删除的时候如何将识别关闭？
function texturetest:new()
  if _KRATOSEDITOR or _PLATFORM_WINDOWS then
    local detectService = facecnndetect();
    detectService:SetType(videodefined.detectType.Face);
    faceseg:RegisterSeg(videodefined.detectType.Face,detectService);
    faceseg:RegisterSegJudgeFunc(videodefined.detectType.Face,self,self._NeedFaceDetect);--一定要注册
    faceseg:SetSegMark(videodefined.detectType.Face,true);
  end
  self.FaceDetection = true;
  self.isfirst = true; 
  self.people = 1;


  local indexpointset = facedefined.facefull20mouths;
  local mouthindexpoint = {};
  local indexnum = 48;
  for j = 1,self.people do 
    for i = 1,#indexpointset/3 do
      table.insert(mouthindexpoint, (j-1)*indexnum+indexpointset[3*i-2]);
      table.insert(mouthindexpoint, (j-1)*indexnum+indexpointset[3*i-1]);
      table.insert(mouthindexpoint, (j-1)*indexnum+indexpointset[3*i-1]);
      table.insert(mouthindexpoint, (j-1)*indexnum+indexpointset[3*i]);
      table.insert(mouthindexpoint, (j-1)*indexnum+indexpointset[3*i]);
      table.insert(mouthindexpoint, (j-1)*indexnum+indexpointset[3*i-2]);
    end
  end
  self.mouthindexpoint = mouthindexpoint;


  local points = facedefined.faceTexPointsExt2; 
  local mouth = facedefined.facemouth20points;
  local mouthpoint = {};
  for j = 1,self.people do
    for i = 1,40 do
      table.insert(mouthpoint,mouth[i]);
    end
    for i = 13,54 do
      table.insert(mouthpoint,points[i]);
    end
    for i = 75,84 do
      table.insert(mouthpoint,points[i])
    end
    for i = 93,96 do
      table.insert(mouthpoint,points[i])
    end
  end
  self.openmouth = mouthpoint;

 
  


  
end



function texturetest:ChangeDataOnce(vertexCount)  
  local renderComponent = self.Node:GetComponent(apolloengine.Node.CT_RENDER);  
  if renderComponent then  --防止添加了scriptcom之前没有添加rendercom
    -------------------------------------------------------索引只换一次
    self.indexStream  = renderComponent:GetIndexStream();
    self.indexStream:Clear();
    self.indexStream:ReserveBuffer(#self.mouthindexpoint);--嘴巴全部连起来
    for i = 1,#self.mouthindexpoint do
      self.indexStream:PushIndicesData(self.mouthindexpoint[i]-1);
    end
    renderComponent:ChangeIndexBuffer(self.indexStream);
    --------------------------------------------------------估算点更换
    local vertexStream = renderComponent:GetVertexStream();
    vertexStream:Clear();
    vertexStream:ReserveBuffer(vertexCount);
    local points = {};
    for i=1, vertexCount do 
      table.insert(points,{self.openmouth[i*2-1]+facedefined.faceTexPointsOffset[1], self.openmouth[i*2]+facedefined.faceTexPointsOffset[2]}); --第85~104个点  (59,373)
    end
    for i=1, vertexCount do
      local newpoint =  mathfunction.vector2(0, 0);
      newpoint:Set(points[i][1], points[i][2]); 
      vertexStream:PushVertexData(apolloengine.ShaderEntity.ATTRIBUTE_COORDNATE0,newpoint);  
      vertexStream:PushVertexData(apolloengine.ShaderEntity.ATTRIBUTE_POSITION,mathfunction.vector4(0,0,0,0));
    end
    renderComponent:ChangeVertexBuffer(vertexStream);

  end
end






function texturetest:Update(def)

  if self.isfirst == true then
    self.isfirst = false;
    self:ChangeDataOnce(48*self.people);--只配置一次 20+21+5
  end

end







function texturetest:OnDisable()
  faceseg:SetSegMark(videodefined.detectType.Face,false)
end

function texturetest:_NeedFaceDetect()
  return true;
end




return texturetest;











