local venuscore = require "venuscore"
local venusjson = require "venusjson"
local mathfunction = require "mathfunction"
local apolloengine = require "apolloengine"
local apollocore = require "apollocore"
local define = require "behavior.cosmetic_lipstick.lipstick_layer_defines"
local faceseg = require "videodecet.faceseg"
local facecnndetect = require "videodecet.facecnndetect"
local videodefined = require "videodecet.defined"
local headtarget =  require "facecute.headtarget"
local immortal =  require "facecute.immortal"
local videodecet = require "videodecet"
local detectservice = require "videodecet.mldetection"
local facedefined = require "facecute.facechange.facedefined"
local imageutility = require "imageutility"
--local highlight = require "behavior.cosmetic_lipstick.lipstick_highlight"


local Lipstick_SelfHLLayer = venuscore.VenusBehavior:extend("Lipstick_SelfHLLayer");



Lipstick_SelfHLLayer:MemberRegister("FaceDetection");
Lipstick_SelfHLLayer:MemberRegister("Opacity");
Lipstick_SelfHLLayer:MemberRegister("BlendSecond", ---上色图和自设计高光素材混合  
  venuscore.ScriptTypes.ComboType(
    {
      {
        key = "SoftLight",
        value = 1
      },
      {
        key = "Origin",
        value = 2
      },
    }
  ));


--删除的时候如何将识别关闭？
function Lipstick_SelfHLLayer:new()
  if _KRATOSEDITOR or _PLATFORM_WINDOWS then
    local detectService = facecnndetect();
    detectService:SetType(videodefined.detectType.Face);
    faceseg:RegisterSeg(videodefined.detectType.Face,detectService);
    faceseg:RegisterSegJudgeFunc(videodefined.detectType.Face,self,self._NeedFaceDetect);--一定要注册
    faceseg:SetSegMark(videodefined.detectType.Face,true);
  end
  self.FaceDetection = true;
  self.isfirst = true; 
  self.Opacity = 1.0;


  if _KRATOSEDITOR or _PLATFORM_WINDOWS then
    local indexpointset = facedefined.facefull20mouths;
    local mouthindexpoint = {};
    for j = 1,3 do 
      for i = 1,#indexpointset do
        table.insert(mouthindexpoint, (j-1)*48+indexpointset[i]);
      end
    end
    self.mouthindexpoint = mouthindexpoint;
    local points = facedefined.faceTexPointsExt2; 
    local mouth = facedefined.facemouth20points;
    local mouthpoint = {};
    for j = 1,3 do
      for i = 1,40 do
        table.insert(mouthpoint,mouth[i]);
      end
      for i = 13,54 do
        table.insert(mouthpoint,points[i]);
      end
      for i = 75,84 do
        table.insert(mouthpoint,points[i])
      end
      for i = 93,96 do
        table.insert(mouthpoint,points[i])
      end
    end
    self.openmouth = mouthpoint;
  elseif _PLATFORM_ANDROID or _PLATFORM_IOS then
    local indexpointset = facedefined.facefull64mouths;
    local mouthindexpoint = {};
    for j = 1,3 do 
      for i = 1,#indexpointset do
        table.insert(mouthindexpoint, (j-1)*92+indexpointset[i]);
      end
    end
    self.mouthindexpoint = mouthindexpoint;
    local points = facedefined.faceTexPointsExt2; 
    local mouthpoint = {};
    for j = 1,3 do
      for i = 237,364 do
        table.insert(mouthpoint,points[i]);
      end
      for i = 13,54 do
        table.insert(mouthpoint,points[i]);
      end
      for i = 75,84 do
        table.insert(mouthpoint,points[i])
      end
      for i = 93,96 do
        table.insert(mouthpoint,points[i])
      end
    end
    self.openmouth = mouthpoint;
  end
  
  --默认使用柔光模式  
  self.BlendSecond = define.BlendSecond.SoftLight;


  
  
end



function Lipstick_SelfHLLayer:ChangeDataOnce(vertexCount)  
  local renderComponent = self.Node:GetComponent(apolloengine.Node.CT_RENDER);  
  if renderComponent then  --防止添加了scriptcom之前没有添加rendercom
    -------------------------------------------------------索引只换一次
    self.indexStream  = renderComponent:GetIndexStream();
    self.indexStream:Clear();
    self.indexStream:ReserveBuffer(#self.mouthindexpoint);--嘴巴全部连起来
    for i = 1,#self.mouthindexpoint do
      self.indexStream:PushIndicesData(self.mouthindexpoint[i]-1);
    end
    renderComponent:ChangeIndexBuffer(self.indexStream);


    --------------------------------------------------------估算点更换
    local vertexStream = renderComponent:GetVertexStream();
    vertexStream:Clear();
    vertexStream:ReserveBuffer(vertexCount);
    local points = {};
    for i=1, vertexCount do --85~104
      table.insert(points,{self.openmouth[i*2-1]+facedefined.faceTexPointsOffset[1], self.openmouth[i*2]+facedefined.faceTexPointsOffset[2]}); --第85~104个点
    end
    for i=1, vertexCount do
      local newpoint =  mathfunction.vector2(0, 0);
      newpoint:Set(points[i][1], points[i][2]); 
      vertexStream:PushVertexData(apolloengine.ShaderEntity.ATTRIBUTE_COORDNATE0,newpoint);  
      vertexStream:PushVertexData(apolloengine.ShaderEntity.ATTRIBUTE_COORDNATE1,mathfunction.vector2(0,0));
      vertexStream:PushVertexData(apolloengine.ShaderEntity.ATTRIBUTE_POSITION,mathfunction.vector4(0,0,0,0));
    end
    renderComponent:ChangeVertexBuffer(vertexStream);

  end
end




function Lipstick_SelfHLLayer:Update(def)

  self:UpdateParameters();


  if self.isfirst == true then
    self.isfirst = false;
    if _KRATOSEDITOR or _PLATFORM_WINDOWS then 
      self:ChangeDataOnce(48*3);--只配置一次
    elseif _PLATFORM_ANDROID or _PLATFORM_IOS then
      self:ChangeDataOnce(92*3);--只配置一次
    end
  end
  

  faceseg:SetSegMark(videodefined.detectType.Face,self.FaceDetection);
  --得到嘴巴关键点
  local size  = faceseg:GetTexSize();
  local sizeInv = {2.0 / size[1], 2.0 / size[2]};
  --size = {2.0 / size[1], 2.0 / size[2]};
  
  local renderComponent = self.Node:GetComponent(apolloengine.Node.CT_RENDER); 
  if renderComponent then
    if _KRATOSEDITOR or _PLATFORM_WINDOWS  then  
      local points = videodecet:GetPixelFacekeypointArray();  --返回像素坐标  以左上角为原点
      if points:Size() > 1 then    --points不会为nil
        imageutility.ImageUtility:LipsVertex(renderComponent, points, mathfunction.vector2(sizeInv[1], sizeInv[2]));
        renderComponent:SetRenderProperty(apolloengine.RenderComponent.RP_SHOW);
      else
        renderComponent:EraseRenderProperty(apolloengine.RenderComponent.RP_SHOW);
      end
    elseif _PLATFORM_ANDROID or _PLATFORM_IOS then
      local points = videodecet:GetExtraPixelFacekeypointArray();  --返回像素坐标  以左上角为原点
      local sourroundingpoint = videodecet:GetPixelFacekeypointArray(); 
      if points:Size() > 1 then    --points不会为nil
        imageutility.ImageUtility:LipsVertexPhone(renderComponent, sourroundingpoint, points, mathfunction.vector2(sizeInv[1], sizeInv[2]));
        renderComponent:SetRenderProperty(apolloengine.RenderComponent.RP_SHOW);
      else
        renderComponent:EraseRenderProperty(apolloengine.RenderComponent.RP_SHOW);
      end
    end
  end
  
end


function Lipstick_SelfHLLayer:UpdateVertex(points,vertexCount)
  local renderComponent = self.Node:GetComponent(apolloengine.Node.CT_RENDER);  --render只是用来做序列化（上来把render的顶点都换掉）
  if renderComponent then
    local vertexStream = renderComponent:GetVertexStream();
    local newpoint =  mathfunction.vector4(0, 0, 0, 1);
    local index_vertex = vertexStream:GetAttributeIndex(apolloengine.ShaderEntity.ATTRIBUTE_POSITION);
    for i=1, vertexCount do
      newpoint:Set(points[i][1], -points[i][2], 0, 1); 
      vertexStream:ChangeVertexDataWithAttributeFast(
        index_vertex,
        i,
        newpoint);  
    end
    vertexStream:SetReflushInterval(1, vertexCount);
    renderComponent:ChangeVertexBuffer(vertexStream);
  end
end




function Lipstick_SelfHLLayer:UpdateParameters()
  local renderComponent = self.Node:GetComponent(apolloengine.Node.CT_RENDER);  
  if renderComponent then
    local firstmaterialentity = renderComponent.MaterialEntities[1];
    firstmaterialentity:SetParameter("_BlendSecond",mathfunction.vector1(self.BlendSecond));
    firstmaterialentity:SetParameter("_Alpha",mathfunction.vector1(self.Opacity));
  end
end




function Lipstick_SelfHLLayer:OnDisable()
  faceseg:SetSegMark(videodefined.detectType.Face,false)
end

function Lipstick_SelfHLLayer:_NeedFaceDetect()
  return true;
end




return Lipstick_SelfHLLayer;











