local venuscore = require "venuscore"
local mathfunction = require "mathfunction"
local apolloengine = require "apolloengine"
local define = require "behavior.cosmetic_contact_lenses.defines"
local videodecet = require "videodecet"
local faceseg = require "videodecet.faceseg"
local facecnndetect = require "videodecet.facecnndetect"
local videodefined = require "videodecet.defined"


local CosmeticContactLensesMask = venuscore.VenusBehavior:extend("CosmeticContactLensesMask");

CosmeticContactLensesMask:MemberRegister("FaceDetection");
CosmeticContactLensesMask:MemberRegister("IrisDetection");
CosmeticContactLensesMask:MemberRegister("UseVideoTexture");




--删除的时候如何将识别关闭？
function CosmeticContactLensesMask:new()
  --注册瞳孔检测的库
  if _KRATOSEDITOR then
    local detectService = facecnndetect();
    detectService:SetType(videodefined.detectType.Face);
    faceseg:RegisterSeg(videodefined.detectType.Face,detectService);
    faceseg:RegisterSegJudgeFunc(videodefined.detectType.Face,self,self._NeedFaceDetect);--一定要注册
    faceseg:SetSegMark(videodefined.detectType.Face,true);
  end


  self.FaceDetection = true;
  self.isfirst = true;

  local maskindextriangle = {};
  if _KRATOSEDITOR or _PLATFORM_WINDOWS then
    local maskidx = define.Eyes16Index;
    for i = 1, 3 do
      for j = 1, #maskidx do
        table.insert(maskindextriangle, (i-1)*16+maskidx[j]);
      end
    end
  elseif _PLATFORM_ANDROID or _PLATFORM_IOS then
    local maskidx = define.Eyes44Index;
    for i = 1, 3 do
      for j = 1, #maskidx do
        table.insert(maskindextriangle, (i-1)*44+maskidx[j]);
      end
    end
  end

  self.maskindextriangle = maskindextriangle;
  apolloengine.ShaderEntity.TEXTURE_DIFFUSE = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM, "TEXTURE_DIFFUSE");
end


function CosmeticContactLensesMask:ChangeDataOnce(vertexCount)
  local renderComponent = self.Node:GetComponent(apolloengine.Node.CT_RENDER);  
  if renderComponent then  --防止添加了scriptcom之前没有添加rendercom
    -------------------------------------------------------索引只换一次
    self.indexStream  = renderComponent:GetIndexStream();
    self.indexStream:Clear();
    self.indexStream:ReserveBuffer(#self.maskindextriangle);--眼眶全连接成一个mask
    for i = 1,#self.maskindextriangle do
      self.indexStream:PushIndicesData(self.maskindextriangle[i]);
    end
    renderComponent:ChangeIndexBuffer(self.indexStream);


    --------------------------------------------------------估算点更换
    local vertexStream = renderComponent:GetVertexStream();
    vertexStream:Clear();
    vertexStream:ReserveBuffer(vertexCount);
    for i=1, vertexCount do
      vertexStream:PushVertexData(apolloengine.ShaderEntity.ATTRIBUTE_COORDNATE0,mathfunction.vector2(0,0));
      vertexStream:PushVertexData(apolloengine.ShaderEntity.ATTRIBUTE_POSITION,mathfunction.vector4(0,0,0,0));
    end
    renderComponent:ChangeVertexBuffer(vertexStream);

  end
end


function CosmeticContactLensesMask:Update(def)
  
  if self.isfirst == true then
    self.isfirst = false;
    if _KRATOSEDITOR or _PLATFORM_WINDOWS then 
      self:ChangeDataOnce(16*3);
    elseif _PLATFORM_ANDROID or _PLATFORM_IOS then
      self:ChangeDataOnce(44*3);
    end
  end


  
  faceseg:SetSegMark(videodefined.detectType.Face,self.FaceDetection);
  



  local renderComponent = self.Node:GetComponent(apolloengine.Node.CT_RENDER); 
  if renderComponent then

    local points = videodecet:GetPixelFacekeypointArray();  --返回像素坐标  以左上角为原点
    local index = {53,54,73,55,56,57,74,58,62,61,76,60,59,64,77,63}; --mask点索引
    --local pointsnum = 16; --眼眶左右一共16个点
    local totalpointsnum = 106;
    local texpoints = {};
    local size  = faceseg:GetTexSize(); --帧大小
    

    if points:Size() > 1 then    --points不会为nil
      renderComponent:SetRenderProperty(apolloengine.RenderComponent.RP_SHOW);
      if _PLATFORM_ANDROID or _PLATFORM_IOS then
        points = videodecet:GetExtraPixelFacekeypointArray();
        local indexnew = {};
        for i = 1,44 do
          table.insert(indexnew,i);
        end
        index = indexnew;
        --pointsnum = 44;
        totalpointsnum = 134;
      end

      for i = 1, 3 do
        for j = 1,#index do
          local point = points:Get(totalpointsnum*(i-1)+index[j]);
          table.insert(texpoints,{point:x()/size[1]*2.0-1.0,point:y()/size[2]*2.0-1.0});
        end
      end
      self:UpdateVertex(texpoints,#index*3);

    else
      renderComponent:EraseRenderProperty(apolloengine.RenderComponent.RP_SHOW);   
    end
  end
  
end


function CosmeticContactLensesMask:UpdateVertex(points,vertexCount)
  local renderComponent = self.Node:GetComponent(apolloengine.Node.CT_RENDER);  --render只是用来做序列化（上来把render的顶点都换掉）
  local vertexStream = renderComponent:GetVertexStream();
  local newpoint =  mathfunction.vector4(0, 0, 0, 1);
  local index_vertex = vertexStream:GetAttributeIndex(apolloengine.ShaderEntity.ATTRIBUTE_POSITION);
  for i=1, vertexCount do
    newpoint:Set(points[i][1], -points[i][2], 0, 1); 
    vertexStream:ChangeVertexDataWithAttributeFast(
      index_vertex,
      i,
      newpoint);  
  end
  vertexStream:SetReflushInterval(1, vertexCount);
  renderComponent:ChangeVertexBuffer(vertexStream);

end


function CosmeticContactLensesMask:OnDisable()
  faceseg:SetSegMark(videodefined.detectType.Face,false)
end

--开启瞳孔检测需要这样的一个回调接口
function CosmeticContactLensesMask:_NeedFaceDetect()
  return true;
end



return CosmeticContactLensesMask;