local venuscore = require "venuscore"
local mathfunction = require "mathfunction"
local apolloengine = require "apolloengine"
local define = require "behavior.cosmetic_contact_lenses.defines"
local videodecet = require "videodecet"
local faceseg = require "videodecet.faceseg"
local facecnndetect = require "videodecet.facecnndetect"
local videodefined = require "videodecet.defined"


local CosmeticContactLenses = venuscore.VenusBehavior:extend("CosmeticContactLenses");

CosmeticContactLenses:MemberRegister("FaceDetection");
CosmeticContactLenses:MemberRegister("IrisDetection");
CosmeticContactLenses:MemberRegister("UseVideoTexture");
CosmeticContactLenses:MemberRegister("Type", 
  venuscore.ScriptTypes.ComboType(
    {
      {
        key = "Left",
        value = 0
      },
      {
        key = "Right",
        value = 1
      }
    }
  ));
CosmeticContactLenses:MemberRegister("PeopleID",
  venuscore.ScriptTypes.ComboType(
    {
      {
        key = "First",
        value = 1
      },
      {
        key = "Second",
        value = 2
      },
      {
        key = "Third",
        value = 3
      },
    }
  ));
CosmeticContactLenses:MemberRegister("Opacity");
CosmeticContactLenses:MemberRegister("RadiusScale");
--叠加模式
CosmeticContactLenses:MemberRegister("BlendMode",
  venuscore.ScriptTypes.ComboType(
    {
      {
        key = "Normal",
        value = 1
      },
      {
        key = "Add",
        value = 2
      },
      {
        key = "Lighten",
        value = 3
      },
      {
        key = "Multiply",
        value = 4
      },
      {
        key = "Overlay",
        value = 5
      },
      {
        key = "Screen",
        value = 6
      },
      {
        key = "Lighter",
        value = 7
      },
    }
  ));


CosmeticContactLenses.ModelCenterIndex = 2;
CosmeticContactLenses.ModelVertexCount = 19;
CosmeticContactLenses.KeypointCount = 20;

--删除的时候如何将识别关闭？
function CosmeticContactLenses:new()
  --注册瞳孔检测的库
  if _KRATOSEDITOR then
    local detectService = facecnndetect();
    detectService:SetType(videodefined.detectType.IrisDetection);
    faceseg:RegisterSeg(videodefined.detectType.IrisDetection,detectService);
  end

  self.UseVideoTexture = true;
  self.Opacity = 0.63;
  self.RadiusScale = 1.0;
  self.FaceDetection = true;
  self.IrisDetection = true;
  self.BlendMode = define.BlendMode.Lighter;  --叠加模式
  self.Type = define.LensesType.LT_LEFT;  --默认是左眼
  self.PeopleID = 1; --默认是第一个人
  faceseg:RegisterSegJudgeFunc(videodefined.detectType.IrisDetection,self,self._NeedIrisDetect);
  faceseg:SetSegMark(videodefined.detectType.IrisDetection,true);  --开启瞳孔识别
  --faceseg:SetSegMark(videodefined.detectType.Face,true)
  --self.last20data = {0.0,0.0};
  --self.last19data = {0.0,0.0};
  
  --apolloengine.ShaderEntity.MASK_TEXTURE =apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,"MASK_TEXTURE");
  --原视频纹理，用来做各种叠加模式
  apolloengine.ShaderEntity.TEXTURE_BASE = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM, "TEXTURE_BASE");
  apolloengine.ShaderEntity.TEXTURE_MASK = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM, "TEXTURE_MASK");
  apolloengine.ShaderEntity.BLEND_MODE = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,"BLEND_MODE");
  apolloengine.ShaderEntity.BLEND_OPACITY = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,"BLEND_OPACITY");
end

function CosmeticContactLenses:Update(def)
  
  faceseg:SetSegMark(videodefined.detectType.IrisDetection,self.IrisDetection);  --开启瞳孔识别
  local irisPoints = {};
  local irisConfidence = {};
  if _KRATOSEDITOR then
    --faceseg:GetSegKeypointArray(videodefined.detectType.Face);  --编辑器下hack下
    faceseg:SetSegMark(videodefined.detectType.Face,self.FaceDetection);
    irisPoints,irisConfidence = faceseg:GetSegKeypointArray(videodefined.detectType.IrisDetection);
  else
    irisPoints,irisConfidence = faceseg:GetCachedSegKeypointArray(videodefined.detectType.IrisDetection);
  end
  
  --得到瞳孔关键点
  --GetCachedSegKeypointArray
  --local irisPoints,irisConfidence= faceseg:GetCachedSegKeypointArray(videodefined.detectType.IrisDetection);
  if irisPoints == nil then  --没有得到识别点
    LOG("Iris detect result is null");
    return;
  end
  
  local irisPointsCnt = #irisPoints;
  local peoplecnt = irisPointsCnt / 40;  --每个眼球20个关键点
  local pupil_points = {};  --存储眼球关键点
  local pupil_confidence = {};  --存储眼球关键点的置信度

  if irisPointsCnt > 0 then
    if self.PeopleID >=1 and self.PeopleID <= peoplecnt then
      if self.Type == define.LensesType.LT_LEFT then  --左眼
        for pointindex = (self.PeopleID - 1) * 40 + 1, (self.PeopleID - 1) * 40 + 20 do
          local pupil_point = irisPoints[pointindex];
          local pupil_point_confidence = irisConfidence[pointindex];
          table.insert(pupil_points,pupil_point);
          table.insert(pupil_confidence,pupil_point_confidence);
        end
      elseif self.Type == define.LensesType.LT_RIGHT then  --左眼
        for pointindex = (self.PeopleID - 1) * 40 + 21 ,(self.PeopleID - 1) * 40 + 40 do
          local pupil_point = irisPoints[pointindex];
          local pupil_point_confidence = irisConfidence[pointindex];
          table.insert(pupil_points,pupil_point);
          table.insert(pupil_confidence,pupil_point_confidence);
        end
      end
      self:UpdateVertex(pupil_points,pupil_confidence);  --更新顶点
      --self:MakeMask(pupil_confidence);
      --self:MakeIndex(); --更新索引
      self:UpdateIndex();
      --self:UpdateBaseTexture();  --简单的把base底图传过去
      self:UpdateVisibility(pupil_confidence); --更新显示状态
    else
      local renderComponent = self.Node:GetComponent(apolloengine.Node.CT_RENDER);  --
      if renderComponent then
        renderComponent:EraseRenderProperty(apolloengine.RenderComponent.RP_SHOW);  --检测不到关键点，隐藏瞳孔的显示
      end
      WARNING("Invalid PeopleID");
    end
  else
    local renderComponent = self.Node:GetComponent(apolloengine.Node.CT_RENDER);  --
    if renderComponent then
      renderComponent:EraseRenderProperty(apolloengine.RenderComponent.RP_SHOW);  --检测不到关键点，隐藏瞳孔的显示
    end
    --LOG("Iris point count is 0");
  end
  

end

function CosmeticContactLenses:UpdateVertex(points,confidence)
  --因为眼球的识别点是有置信度的，有些关键点是要忽略掉的，所以应该重新组织连接关系
  local renderComponent = self.Node:GetComponent(apolloengine.Node.CT_RENDER);  --render只是用来做序列化（上来把render的顶点都换掉）
  if renderComponent then
    self.indexStream = apolloengine.IndicesStream();
    local vertexStream = renderComponent:GetVertexStream();
    if vertexStream then
      local vertexarray = points;  --由识别点构建三角形
      local newpoint =  mathfunction.vector4(0, 0, 0, 1);
      local index_vertex = vertexStream:GetAttributeIndex(apolloengine.ShaderEntity.ATTRIBUTE_POSITION);

     -----
      --local num19point = points[#vertexarray-1];
      local normalizedpoint = points[#vertexarray];
      --[[local size  = faceseg:GetTexSize();
      if self.Type == define.LensesType.LT_LEFT then
        --LOG("left eye point is ");
        local data1 = (normalizedpoint[1]-self.last20data[1])/2.0*size[1];
        local data2 = (normalizedpoint[2]-self.last20data[2])/2.0*size[2];
        local data3 = (num19point[1]-self.last19data[1])/2.0*size[1];
        local data4 = (num19point[2]-self.last19data[2])/2.0*size[2];
        self.last20data = {normalizedpoint[1], normalizedpoint[2]};
        self.last19data = {num19point[1], num19point[2]};
        LOG("size "..size[1].." "..size[2]);
        LOG("center delta "..data1.." "..data2.." num 19 delta"..data3.." "..data4);
      end]]--
      -----

      for i=1, #vertexarray do
        local modelIndex = self:_MakeMatch(i);
        if not (modelIndex < 0) then
          local point = vertexarray[i];
          local point_scale = {normalizedpoint[1]+(point[1]-normalizedpoint[1])*self.RadiusScale,normalizedpoint[2]+(point[2]-normalizedpoint[2])*self.RadiusScale};
          --通过Z值来将顶点的可见性传递进去
          --if confidence[i] == true then
            newpoint:Set(point_scale[1],point_scale[2],1.0,1.0);
          --else
          --  newpoint:Set(point[1],point[2],0.0,1.0);
          --end
          
          vertexStream:ChangeVertexDataWithAttributeFast(
            index_vertex,
            modelIndex + 1,
            newpoint);
        end
      end
      vertexStream:SetReflushInterval(1, #vertexarray -1);
      renderComponent:ChangeVertexBuffer(vertexStream);
    end
  end
end

--测试三角划分的方案
function CosmeticContactLenses:MakeIndex()
  local renderComponent = self.Node:GetComponent(apolloengine.Node.CT_RENDER);  --render只是用来做序列化（上来把render的顶点都换掉）
  if renderComponent then
    self.indexStream = apolloengine.IndicesStream();
    self.indexStream:SetIndicesType(apolloengine.IndicesBufferEntity.IT_UINT16);
    self.indexStream:ReserveBuffer(48);
    local modelIndexConstant = {{15,16},{14,17},{13,18},{12,1},{11,0},{10,3},{9,4},{8,5},{7,6}};
    --重新连接下三角面
    local modelCnt = #modelIndexConstant;
    for i = 1, modelCnt - 1 do
      local indexRow = modelIndexConstant[i];
      local indexNextRow = modelIndexConstant[i + 1];
      self.indexStream:PushIndicesDataFast(indexRow[1]);
      self.indexStream:PushIndicesDataFast(indexNextRow[1]);
      self.indexStream:PushIndicesDataFast(indexNextRow[2]);
      
      self.indexStream:PushIndicesDataFast(indexRow[1]);
      self.indexStream:PushIndicesDataFast(indexRow[2]);
      self.indexStream:PushIndicesDataFast(indexNextRow[2]);
    end
    renderComponent:ChangeIndexBuffer(self.indexStream);
    renderComponent:SetDrawCount(48);
  end
end


--测试赵老板的方案
--因为是人工对出的点的位置，所以点的索引写死。。。
--根据可见性生成一张mask图片
function CosmeticContactLenses:MakeMask(confidence)
  local renderComponent = self.Node:GetComponent(apolloengine.Node.CT_RENDER);  --render只是用来做序列化（上来把render的顶点都换掉）
  if renderComponent then
    self.maskTS = apolloengine.TextureStream();
    self.maskTS:SetStreamType(
      mathfunction.vector2(2,9),
      apolloengine.TextureEntity.PF_L8);
    self.maskTEX = apolloengine.TextureEntity();
    --根据模型点位，分为左右两部分
    local pixelIndex = {{15,16},{14,17},{13,18},{12,1},{11,0},{10,3},{9,4},{8,5},{7,6}};
    for i = 1, #pixelIndex do
      local row = pixelIndex[i];
      for j = 1, #row do
        local modelIndex = row[j];
        local keypointIndex = self:_ModelIndex2KeypointIndex(modelIndex);
        local visibility = confidence[keypointIndex];
        if visibility == true then
          self.maskTS:SetPixel(j,i, mathfunction.vector1(255.0));
        else
          self.maskTS:SetPixel(j,i,mathfunction.vector1(0.0));
        end
      end
    end
    self.maskTEX:PushMetadata(
    apolloengine.TextureBufferMetadata(
      apolloengine.TextureEntity.TU_WRITE,
      1, false,
      apolloengine.TextureEntity.TW_CLAMP_TO_EDGE,
      apolloengine.TextureEntity.TW_CLAMP_TO_EDGE,
      apolloengine.TextureEntity.TF_LINEAR,
      apolloengine.TextureEntity.TF_LINEAR,
      self.maskTS));
    self.maskTEX:CreateResource();
    
    renderComponent:SetParameter(apolloengine.ShaderEntity.MASK_TEXTURE,self.maskTEX);

  end
end

function CosmeticContactLenses:UpdateVisibility(confidence)
  local renderComponent = self.Node:GetComponent(apolloengine.Node.CT_RENDER);  --render只是用来做序列化（上来把render的顶点都换掉）
  if renderComponent then
    local pointCnt = #confidence;
    local isCenterPointEnablel = false;
    local peripheryIndex = {};
    
    --取到模型中心点和边缘点
    for i = 1, pointCnt do
      if confidence[i] == true then
        local modelIndex = self:_MakeMatch(i);
        if not (modelIndex < 0) then
          if modelIndex == CosmeticContactLenses.ModelCenterIndex then
            isCenterPointEnablel = true;
          else
            table.insert(peripheryIndex,modelIndex);
          end
        end
      end
    end
    
    --根据点的状态控制显示与否
    if isCenterPointEnablel == false or #peripheryIndex == 0 then  --闭眼状态
      renderComponent:EraseRenderProperty(apolloengine.RenderComponent.RP_SHOW);
    else  --睁眼状态
      renderComponent:SetRenderProperty(apolloengine.RenderComponent.RP_SHOW);
    end
    renderComponent:SetParameter(apolloengine.ShaderEntity.BLEND_MODE, mathfunction.vector1(self.BlendMode));
    renderComponent:SetParameter(apolloengine.ShaderEntity.BLEND_OPACITY, mathfunction.vector1(self.Opacity));
  end
end

function CosmeticContactLenses:UpdateBaseTexture()
  local renderComponent = self.Node:GetComponent(apolloengine.Node.CT_RENDER);  --render只是用来做序列化（上来把render的顶点都换掉）
  if renderComponent then
    if _KRATOSEDITOR then
      local PluginSystem = require "window.editor.system.pluginsystem"
      local pluginList = PluginSystem:GetPluginList();
      for key,value in pairs(pluginList) do
        local plugin = value;
        local pluginName = value:GetName();
        if pluginName == "Priview" then --hack 拿到preview插件
          local pluginInst = value:GetInstance();
          if pluginInst then
            local videoTexture = pluginInst:GetVideoTexture();
            if videoTexture then
              if self.UseVideoTexture == true then
                renderComponent:SetParameter(apolloengine.ShaderEntity.TEXTURE_BASE,videoTexture);
              end
              renderComponent:SetParameter(apolloengine.ShaderEntity.BLEND_MODE, mathfunction.vector1(self.BlendMode));
              renderComponent:SetParameter(apolloengine.ShaderEntity.BLEND_OPACITY, mathfunction.vector1(self.Opacity));
            end
          end
        end
      end
    else
      local videoDetect = require "videodecet"
      local videoTexture = videoDetect:GetVideoTexture();
      if videoTexture then
        renderComponent:SetParameter(apolloengine.ShaderEntity.BASE_TEXTURE,videoTexture);
        renderComponent:SetParameter(apolloengine.ShaderEntity.BLEND_MODE, self.BlendMode); --设置叠加模式
      end
    end
  end
  

  
end



function CosmeticContactLenses:UpdateIndex()
  local renderComponent = self.Node:GetComponent(apolloengine.Node.CT_RENDER);  --render只是用来做序列化（上来把render的顶点都换掉）
  if renderComponent then
    local indexStream = renderComponent:GetIndexStream();
    --local pointCnt = #confidence;
    local isCenterPointEnablel = false;
    local peripheryIndex = {};
    for i = 1, 20 do
      --if confidence[i] == true then
        local modelIndex = self:_MakeMatch(i);
        if not (modelIndex < 0) then
          if modelIndex == 2 then
            isCenterPointEnablel = true;
          else
            table.insert(peripheryIndex,modelIndex);
          end
        end
      --end
    end
    
    --避免硬边需要补充一些点
    
    local indexCnt = #peripheryIndex
    self.indexStream = apolloengine.IndicesStream();
    self.indexStream:SetIndicesType(apolloengine.IndicesBufferEntity.IT_UINT16);
    self.indexStream:ReserveBuffer(indexCnt * 3);
    for i = 1, #peripheryIndex -1 do
      self.indexStream:PushIndicesDataFast(peripheryIndex[i]);
      self.indexStream:PushIndicesDataFast(peripheryIndex[i + 1]);
      self.indexStream:PushIndicesDataFast(2);  --这里是Fbx眼球片的中心点
    end
    self.indexStream:PushIndicesDataFast(peripheryIndex[indexCnt]);
    self.indexStream:PushIndicesDataFast(peripheryIndex[1]);
    self.indexStream:PushIndicesDataFast(2);
    renderComponent:ChangeIndexBuffer(self.indexStream);
    renderComponent:SetRenderProperty(apolloengine.RenderComponent.RP_SHOW);
    renderComponent:SetDrawCount(indexCnt * 3);

  end
end



function CosmeticContactLenses:OnDisable()
  faceseg:SetSegMark(videodefined.detectType.IrisDetection,false);  --开启瞳孔识别
  faceseg:SetSegMark(videodefined.detectType.Face,false)
end

--开启瞳孔检测需要这样的一个回调接口
function CosmeticContactLenses:_NeedIrisDetect()
  return true;
end

--经过模型导出插件导出的顶点顺序会乱掉
--这里用来和模型中的顶点排列对齐
--经过观测，模型中把第二个作为中心点了
function CosmeticContactLenses:_MakeMatch(irisIndex)
  local modelOrder = {0,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,1,-1,2};  -- -1表示一个无效的值
  return modelOrder[irisIndex];
end

function CosmeticContactLenses:_ModelIndex2KeypointIndex(modelIndex)
  local keypointOrder = {0,17,19,1,2,3,4,5,16,7,8,9,10,11,12,13,14,15,16};  -- -1表示一个无效的值
  return keypointOrder[modelIndex];
end


function CosmeticContactLenses:_MakeTriangelArray(pointarray)
  
  local cnt = #pointarray;
  local vertexarray = {};
  --简单拷贝下
  
  for i = 1, cnt do
    table.insert(vertexarray,pointarray[i]); 
  end
  return vertexarray;
end


return CosmeticContactLenses;