local venuscore = require "venuscore"
local mathfunction = require "mathfunction"
local apolloengine = require "apolloengine"


local AutoPlay = venuscore.VenusBehavior:extend("Animation_AutoPlay");
AutoPlay:MemberRegister("Delay");



function AutoPlay:new()
  self.Delay = 0;
  self.assets = {}
end

function AutoPlay:_Find(ct)
  if self.Node:HaveComponent(ct) then
    local com = self.Node:GetComponent(ct);
    table.insert(self.assets, com);
  end
end

function AutoPlay:_Play()
  for _, com in ipairs(self.assets) do
    com:Play()
  end
end

function AutoPlay:Awake()
  self:_Find(apolloengine.Node.CT_ANIMATION);
  self:_Find(apolloengine.Node.CT_FRAME_PLAYER);
  self:_Play();
end

function AutoPlay:Update(timespan)
end


return AutoPlay;