require "venusdebug"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local videodecet = require "videodecet"
local facecute = require "facecute"
local face = require "videodecet.faceinfo";
local apollonode = require "apolloutility.apollonode"
local renderqueue = require "apolloutility.renderqueue"
local utility = require "apolloutility.nodeutility"
local defined = require "apolloutility.defiend"
local makeup = require"beauty.facecute_makeup"
require "utility"

local newfacelift  = {}

local faceonepara = {{0.3744,0.018},{0.3744,0.0216},{0.3744,0.0252},{0.3744,0.0216},{0.3744,0.0216},{0.3744,0.0216},{0.3744,0.0216},{0.3744,0.0216},{0.3744,0.0216}};
local facetwopara = {{0.3708,0.01854},{0.36,0.018},{0.342,0.0171},{0.36,0.0171},{0.3708,0.01836},{0.432,0.022248},{0.432,0.022248}};
local mousepara   = {{0.6,0.0114},{0.6,0.0252},{0.6,0.0252},{0.6,0.0252},{0.6,0.0114},{0.6,0.036},{0.6,0.0372},{0.6,0.0372},{0.6,0.0372},{0.6,0.036},{0.66,0.0228},{0.66,0.0228},{0.66,0.0228},{0.66,0.0228},{0.66,0.0228}};

function newfacelift:Initialize(camera)
  self.newframecallback = nil;
  self.maxFaceNum = 3;
  --大眼参数
  self.eyecoef = 1.0;
  --瘦脸参数
  self.facecoef = 0.0;
  --瘦下巴参数
  self.chincoef = 0.0;
  self.rate = 1.0;

  self.isShow = true;
  self.facenode = {};
  self.camera = {};
  self.rt = {};
  self.tex = {};
  self.backnode = {};
   
  self.near = camera:GetNear();
  self.far = camera:GetFar();
  self.pos = camera:GetWorldPosition();
  self.lookat = self.pos + camera:GetForward();
  self.up = camera:GetUp();
  self.color = mathfunction.Color(1.0,0.0,0.0,0.0); --清屏颜色
  
  self.resolution = apolloengine.Framework:GetResolution();
  self.aspect_ratio = self.resolution:y() / self.resolution:x();
  
  self.mainquadnode = apollonode.QuadNode();
  self.mainquadnode:SetShow(false);
  self.mainquadnode:CreateResource("docs:material/imageblit_queue_overlay.material",true,false);
  --self.mainquadnode:CreateResource(defined.flip_material_path,true,false);
  self.mainquadnode:SetSequence(camera:GetSequence());
  
  apolloengine.ShaderEntity.UNIFORM_LEFT_EYE = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,"UNIFORM_LEFT_EYE");
  apolloengine.ShaderEntity.UNIFORM_RIGHT_EYE = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,"UNIFORM_RIGHT_EYE");
  apolloengine.ShaderEntity.UNIFORM_RADIUS = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,"UNIFORM_RADIUS");
  apolloengine.ShaderEntity.UNIFORM_FACECOEF = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,"UNIFORM_FACECOEF");
  apolloengine.ShaderEntity.UNIFORM_CHINCOEF = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,"UNIFORM_CHINCOEF");
  apolloengine.ShaderEntity.UNIFORM_LEFT_PTS = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,"UNIFORM_LEFT_PTS");
  apolloengine.ShaderEntity.UNIFORM_RIGHT_PTS = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,"UNIFORM_RIGHT_PTS");
  apolloengine.ShaderEntity.UNIFORM_NOSE = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,"UNIFORM_NOSE");
  apolloengine.ShaderEntity.UNIFORM_MOUSE = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,"UNIFORM_MOUSE");
  apolloengine.ShaderEntity.UNIFORM_CHIN = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,"UNIFORM_CHIN");
  apolloengine.ShaderEntity.UNIFORM_SCALERATIO = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,"UNIFORM_SCALERATIO");
  
  apolloengine.ShaderEntity.FACEONEPARA = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,"FACEONEPARA");
  apolloengine.ShaderEntity.FACETWOPARA = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,"FACETWOPARA");
  apolloengine.ShaderEntity.MOUSEPARA = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,"MOUSEPARA");
  apolloengine.ShaderEntity.UNIFORM_RATIOASPECT = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,"UNIFORM_RATIOASPECT");
  apolloengine.ShaderEntity.UNIFORM_ZOOMSCALE = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,"UNIFORM_ZOOMSCALE");
 
      
  local  facePara1 = mathfunction.vector2array();
  local  facePara2 = mathfunction.vector2array();
  local  mousePara0 = mathfunction.vector2array();
  
  local  lefteyes = mathfunction.vector2(0,0);
  local  righteyes = mathfunction.vector2(0,0);
  local  leftPointArray = mathfunction.vector2array();
  local  rightPointArray = mathfunction.vector2array();
  local  nose = mathfunction.vector2array();
  local  mouse = mathfunction.vector2array();
  local  chin = mathfunction.vector2(0,0);
  local  radiuses = mathfunction.vector2(0,0);
  local  zoomscale = mathfunction.Matrix33(0, 0, 0,
                                               0, 0, 0,
                                               0, 0, 0);
  
  for i = 1, 9, 1 do
    facePara1:PushBack(self:arrayToVec2(faceonepara[i]));
  end
  for i = 1, 7, 1 do
    facePara2:PushBack(self:arrayToVec2(facetwopara[i]));
  end
  for i = 1, 15, 1 do
    mousePara0:PushBack(self:arrayToVec2(mousepara[i]));
  end
  local vs,is = utility.TesslateGivenPart(96, 66, false, true,{-0.25,0.25},{-0.25,0.25});
  --一张脸一个quadnode
  for i = 1,self.maxFaceNum,1 do
    self:_CreateCamera(camera:GetSequence()-i+defined.pre_facelift_camera_sequence,true);
    local quadnode = apollonode.QuadNode();
    --local vs,is = utility.TesslateGivenPart(96, 66, false, true,{-0.25,0.25},{-0.25,0.25});
    quadnode:CreateResourceSpecific("docs:material/biggereyesnew.material", vs, is);
    quadnode:SetSequence(camera:GetSequence()-i+defined.pre_facelift_camera_sequence);
    quadnode:SetShow(false);
    
    quadnode:SetParameter(apolloengine.ShaderEntity.FACEONEPARA, facePara1);
    quadnode:SetParameter(apolloengine.ShaderEntity.FACETWOPARA, facePara2);
    quadnode:SetParameter(apolloengine.ShaderEntity.MOUSEPARA, mousePara0);
    quadnode:SetParameter(apolloengine.ShaderEntity.UNIFORM_RATIOASPECT, mathfunction.vector1(self.aspect_ratio));
    
    quadnode:SetParameter(apolloengine.ShaderEntity.UNIFORM_LEFT_EYE, lefteyes);
    quadnode:SetParameter(apolloengine.ShaderEntity.UNIFORM_RIGHT_EYE, righteyes);
    quadnode:SetParameter(apolloengine.ShaderEntity.UNIFORM_LEFT_PTS, leftPointArray);
    quadnode:SetParameter(apolloengine.ShaderEntity.UNIFORM_RIGHT_PTS, rightPointArray);
    quadnode:SetParameter(apolloengine.ShaderEntity.UNIFORM_NOSE, nose);
    quadnode:SetParameter(apolloengine.ShaderEntity.UNIFORM_MOUSE, mouse);
    quadnode:SetParameter(apolloengine.ShaderEntity.UNIFORM_CHIN, chin);
    quadnode:SetParameter(apolloengine.ShaderEntity.UNIFORM_RADIUS, radiuses);
    
    quadnode:SetParameter(apolloengine.ShaderEntity.UNIFORM_FACECOEF, mathfunction.vector1(0.0));
    quadnode:SetParameter(apolloengine.ShaderEntity.UNIFORM_CHINCOEF, mathfunction.vector1(0.0));
    quadnode:SetParameter(apolloengine.ShaderEntity.UNIFORM_SCALERATIO, mathfunction.vector1(0.5));
    
    quadnode:SetParameter(apolloengine.ShaderEntity.UNIFORM_ZOOMSCALE, zoomscale);
    
    
    table.insert(self.facenode,quadnode);
  end
 -- self:_CreateCamera(camera:GetSequence()-4+defined.pre_facelift_camera_sequence,false);
  camera:Activate();
end

function newfacelift:_CreateCamera(sequence,flip)
  local camera = apollonode.CameraNode();
  camera:Activate();
  camera:CreateRealCameraProjection(self.near, self.far);
  camera:LookAt(self.pos, self.lookat, self.up);
  camera:SetSequence(sequence);
  camera:SetClearColor(self.color);
  local rt = apolloengine.RenderTargetEntity();
  rt:PushMetadata(--设置FBO格式
    apolloengine.RenderTargetMetadata(
      apolloengine.RenderTargetEntity.RT_RENDER_TARGET_2D,
      apolloengine.RenderTargetEntity.ST_SWAP_UNIQUE,
      apolloengine.Framework:GetViewport(),
      apolloengine.Framework:GetResolution()));--分辨率
  local tex = rt:MakeTextureAttachment(apolloengine.RenderTargetEntity.TA_COLOR_0);
  tex:PushMetadata(--创建纹理
    apolloengine.TextureRenderMetadata(
      apolloengine.RenderTargetEntity.ST_SWAP_UNIQUE,
      apolloengine.Framework:GetResolution()));

  rt:CreateResource();
  camera:AttachRenderTarget(rt);
  
  local quadnode = apollonode.QuadNode();
  quadnode:SetShow(false);
  quadnode:CreateResource(defined.blit_material_path,flip,false);
  quadnode:SetSequence(sequence);
  
  table.insert(self.camera,camera);
  table.insert(self.rt,rt);
  table.insert(self.tex,tex);
  table.insert(self.backnode,quadnode);
end


local sqrt = math.sqrt;

function newfacelift:GetVector2dLength(vec)
  return sqrt(vec:x() * vec:x() + vec:y() * vec:y());
end

--[[function newfacelift:GetDistance(src, dst)
  local dx = src[1] - dst[1];
  local dy = src[2] - dst[2];
  return sqrt(dx * dx + dy * dy);
end]]--
local GetDistance = function(src, dst)
  local dx = src[1] - dst[1];
  local dy = src[2] - dst[2];
  return sqrt(dx * dx + dy * dy);
end

function newfacelift:arrayToVec2(pt)
  return mathfunction.vector2(pt[1], pt[2]);
end

function newfacelift:ChangeRange(pt)
  return {pt[1]*2.0-1.0,pt[2]*2.0-1.0}
end


--脸周
function newfacelift:_UpdateFaceKeypoints(currentPoint, src, dst, radius, delta)
    local currentPointToUse = {currentPoint[1], currentPoint[2] * self.aspect_ratio};
    local srcToUse = {src[1], src[2] * self.aspect_ratio};  
    local r = GetDistance(currentPointToUse, srcToUse);
     
    local positionToUse = currentPoint;

    if r > radius then
       return currentPoint, 0;
    end
    local dir = mathfunction.vector2(src[1] - dst[1], src[2] - dst[2]);
    dir:NormalizeSelf();   
    local dist = radius * radius - r * r;
    local alpha = dist / (dist + (r-delta) * (r-delta));
    alpha = alpha * alpha;
    positionToUse[1] = positionToUse[1] - alpha * delta * dir:x();
    positionToUse[2] = positionToUse[2] - alpha * delta * dir:y();
    return positionToUse, 1;
  
end


--眼睛
function newfacelift:_UpdateEyesKeypoints(currentPoint, center, radius)
  
    local scaleRatio = 0.5; 
    
    local currentPositionToUse = {currentPoint[1], currentPoint[2] * self.aspect_ratio};
    local centerPostionToUse = {center[1], center[2] * self.aspect_ratio};
    local r = GetDistance(currentPositionToUse, centerPostionToUse);
    
    if r > radius then
      return currentPoint, 0;
    end
    
    local alpha = 1.0 + scaleRatio * (r / radius - 1.0) * (r / radius - 1.0);
    local positionToUse = currentPoint;
    positionToUse[1] = center[1] + alpha * (currentPoint[1] - center[1]);
    positionToUse[2] = center[2] + alpha * (currentPoint[2] - center[2]);
    return positionToUse, 1;
end

function newfacelift:_UpdateFaceKeypoints2(currentPoint, src, dst, radius, delta)
    local currentPointToUse = {currentPoint[1], currentPoint[2] * self.aspect_ratio};
    local srcToUse = {src[1], src[2] * self.aspect_ratio};  
    local r = GetDistance(currentPointToUse, srcToUse);
    local r2 = GetDistance(src,dst);
    local rmax = r2 * r2 * radius * radius ;

    if r*r > rmax then
      return currentPoint, 0;
    end
    
    local positionToUse = currentPoint;
    local dir = mathfunction.vector2(src[1] - dst[1], src[2] - dst[2]);
    dir:NormalizeSelf();

    local dist = rmax - r * r;
    local delta2 = delta * r2;
    local tmp = r - delta2
    local alpha = dist / (dist + tmp * tmp);
    alpha = alpha * alpha;
    positionToUse[1] = positionToUse[1] - alpha * delta2 * dir:x();
    positionToUse[2] = positionToUse[2] - alpha * delta2 * dir:y();
    return positionToUse, 1;  

end


function newfacelift:NewframeCallback()
  if self.newframecallback ~= nil then
    return self.newframecallback
  end
  self.newframecallback = function()

    for i = 1,self.maxFaceNum,1 do
      self.facenode[i]:SetShow(false);
      self.backnode[i]:SetShow(false);
      self.camera[i]:Deactivate();
    end
    --self.backnode[4]:SetShow(false);
    --self.camera[4]:Deactivate();
    
    local faces = videodecet:GetFaces();
    if not faces or #faces<1 or self.isShow == false then
      self.mainquadnode:SetShow(false);
      return;
    end
    if self.eyecoef == 1.0 then
      for i = 1,self.maxFaceNum,1 do
        self.facenode[i]:SetParameter(apolloengine.ShaderEntity.UNIFORM_SCALERATIO,mathfunction.vector1(0.0));
      end
    else
      for i = 1,self.maxFaceNum,1 do
        self.facenode[i]:SetParameter(apolloengine.ShaderEntity.UNIFORM_SCALERATIO,mathfunction.vector1(0.5));
      end
    end
    
    local faceNum = math.min(self.maxFaceNum, #faces);
    if faceNum < 1 then
       return;
    end
    for k= 1, faceNum, 1 do
      --local lefteyes  = mathfunction.vector2array();
      --local righteyes = mathfunction.vector2array();
      local leftPointArray  = mathfunction.vector2array();
      local rightPointArray = mathfunction.vector2array();
      local nose  = mathfunction.vector2array();
      local mouse = mathfunction.vector2array();
      --local chin  = mathfunction.vector2array();
      --local radiuses = mathfunction.vector2array();
      
      local faceinfo = faces[k];
      self.keypoints = faceinfo:GetKeypointArray();
      self.extrapoints = faceinfo:GetExtraKeypointArray();

      --修正侧脸问题
      self.rotate = faceinfo:GetRotation();
      self.rate = (1.0 - math.abs(self.rotate[3]/40));
      if(self.rate < 0) then
        self.rate = 0.0;
      end
      --为口红解决低头效果问题
      self.pitch = (1.0 + math.max(0.0,self.rotate[1]/14));
      
      local keypoints = faces[k]:GetKeypointArray();
      local min_x =  1;
      local max_x = -1;
      local min_y =  1;
      local max_y = -1;

      for id, pt in pairs(keypoints) do
        min_x = math.min(min_x, pt[1]);
        max_x = math.max(max_x, pt[1]);
        min_y = math.min(min_y, pt[2]);
        max_y = math.max(max_y, pt[2]);
      end
  
      local paddingRatio = 0.2;
      local width = max_x - min_x;
      local height = max_y - min_y;
      local xymin = {min_x - paddingRatio*width, min_y - paddingRatio*height};
      local xymax = {max_x + paddingRatio*width, max_y + paddingRatio*height};
      local centerx = (xymin[1]+xymax[1])*0.5;
      local centery = (xymin[2]+xymax[2])*0.5;
      local zoomscalex = (xymax[1]-xymin[1])*2.0;
      local zoomscaley = (xymax[2]-xymin[2])*2.0;
      local zoomescale = mathfunction.Matrix33(zoomscalex, 0, centerx,
                                               0, zoomscaley, centery,
                                               0, 0, 0);
      local shiftscale = mathfunction.vector2(centerx,centery);
      
      self.facenode[k]:SetParameter(apolloengine.ShaderEntity.UNIFORM_ZOOMSCALE,zoomescale);

      --左眼
      local c1 = self:arrayToVec2(self.keypoints[75]);
      local pt2 = self:arrayToVec2(self.keypoints[55]);
      self.r1 = self:GetVector2dLength(pt2 - c1) ;
      local lefteyes = c1;
      
      --右眼 
      local c2 = self:arrayToVec2(self.keypoints[78]);
      pt2 = self:arrayToVec2(self.keypoints[60]);
      self.r2 = self:GetVector2dLength(pt2 - c2);
      local righteyes = c2;
      
      --大眼系数
      local radiuses = mathfunction.vector2(self.r1 * self.eyecoef * 0.72, self.r2 * self.eyecoef * 0.72);
      
      --左脸     
      for i = 1,16,1 do
        leftPointArray:PushBack(self:arrayToVec2(self.keypoints[i]));
      end

      --右脸
      for i = 33,18,-1 do
        rightPointArray:PushBack(self:arrayToVec2(self.keypoints[i]));
      end
      
      --鼻子
      self.ns = self.keypoints[44];      
      nose:PushBack(self:arrayToVec2(self.keypoints[46]));
      for i = 81,84,1 do
        nose:PushBack(self:arrayToVec2(self.keypoints[i]));
      end 
      nose:PushBack(self:arrayToVec2(self.keypoints[50]));
      nose:PushBack(self:arrayToVec2(self.keypoints[44]));

      --嘴
      mouse:PushBack(self:arrayToVec2(self.keypoints[85]));
      mouse:PushBack(self:arrayToVec2(self.keypoints[91]));--it changes the mouse point order 
      for i = 86,101,1 do
        if i ~= 91 then
          mouse:PushBack(self:arrayToVec2(self.keypoints[i]));
        end
      end

      --下巴
      local chin = self:arrayToVec2(self.keypoints[17]);
      self.flag = 0;
      
      self:_getWarpedKeyPoints();
      faceinfo:UpdateKeypoints(self.keypoints); 
      faceinfo:UpdateExtraKeypoints(self.extrapoints);  
      videodecet:PushNewFaceLandMark();
      
      self.facenode[k]:SetParameter(apolloengine.ShaderEntity.UNIFORM_LEFT_EYE,lefteyes);
      self.facenode[k]:SetParameter(apolloengine.ShaderEntity.UNIFORM_RIGHT_EYE,righteyes);
      self.facenode[k]:SetParameter(apolloengine.ShaderEntity.UNIFORM_RADIUS,radiuses);
      self.facenode[k]:SetParameter(apolloengine.ShaderEntity.UNIFORM_FACECOEF,mathfunction.vector1(self.facecoef*self.rate));
      self.facenode[k]:SetParameter(apolloengine.ShaderEntity.UNIFORM_CHINCOEF,mathfunction.vector1(self.chincoef*self.rate));
      self.facenode[k]:SetParameter(apolloengine.ShaderEntity.UNIFORM_LEFT_PTS,leftPointArray);
      self.facenode[k]:SetParameter(apolloengine.ShaderEntity.UNIFORM_RIGHT_PTS,rightPointArray);
      self.facenode[k]:SetParameter(apolloengine.ShaderEntity.UNIFORM_NOSE,nose);
      self.facenode[k]:SetParameter(apolloengine.ShaderEntity.UNIFORM_MOUSE,mouse);
      self.facenode[k]:SetParameter(apolloengine.ShaderEntity.UNIFORM_CHIN,chin);
      
      self.facenode[k]:SetShow(true);
    end
    local cameraComponent = (renderqueue:GetCamera(renderqueue.CAMERA_LAYER_FIRST+1)).camera;
    if cameraComponent.Active == true then
      self.facenode[faceNum]:SetParameter(apolloengine.ShaderEntity.TEXTURE_DIFFUSE,renderqueue:GetTexture(renderqueue.CAMERA_LAYER_FIRST+1));
      self.backnode[faceNum]:SetParameter(apolloengine.ShaderEntity.TEXTURE_DIFFUSE,renderqueue:GetTexture(renderqueue.CAMERA_LAYER_FIRST+1));
    else
      self.facenode[faceNum]:SetParameter(apolloengine.ShaderEntity.TEXTURE_DIFFUSE,renderqueue:GetTexture(renderqueue.CAMERA_LAYER_FIRST));
      self.backnode[faceNum]:SetParameter(apolloengine.ShaderEntity.TEXTURE_DIFFUSE,renderqueue:GetTexture(renderqueue.CAMERA_LAYER_FIRST));
    end
    
    self.backnode[faceNum]:SetShow(true);
    self.camera[faceNum]:Activate();
    
    --self.backnode[4]:SetParameter(apolloengine.ShaderEntity.TEXTURE_DIFFUSE,videodecet:GetVideoTexture());
    --self.backnode[4]:SetParameter(apolloengine.ShaderEntity.TEXTURE_DIFFUSE,renderqueue:GetTexture(renderqueue.CAMERA_LAYER_FIRST));
    --self.backnode[4]:SetShow(true);
    --self.camera[4]:Activate();
      
    for i = faceNum-1,1,-1 do
      self.facenode[i]:SetParameter(apolloengine.ShaderEntity.TEXTURE_DIFFUSE,self.tex[i+1]);
      self.backnode[i]:SetParameter(apolloengine.ShaderEntity.TEXTURE_DIFFUSE,self.tex[i+1]);
      self.backnode[i]:SetShow(true);
      self.camera[i]:Activate();
    end
    self.mainquadnode:SetParameter(apolloengine.ShaderEntity.TEXTURE_DIFFUSE,self.tex[1]);
    self.mainquadnode:SetShow(true);
  end
  return self.newframecallback;
end


function newfacelift:GetNewframeCallback()
    return self.newframecallback
end

function newfacelift:setWarpLevel(coefeye,coefface,coefchin)
  
  self.eyecoef = 1.0 + coefeye * 0.05 * 0.22;
  self.facecoef = math.sqrt(coefface * 0.05 * 0.2) * 0.48;
  self.chincoef = math.sqrt(coefchin * 0.05 * 0.2) * 0.48;
  
end

function newfacelift:setEyeParam(coefeye)
  self.eyecoef = 1.0 + coefeye * 0.05 * 0.22;
end

function newfacelift:setFaceParam(coefface)
  self.facecoef = math.sqrt(coefface * 0.05 * 0.2) * 0.48;
end

function newfacelift:setChinParam(coefchin)
  self.chincoef = math.sqrt(coefchin * 0.05 * 0.2) * 0.48;
end


function newfacelift:_getWarpedKeyPoints()

  --更新眼周关键点位置
  --眼眶中心可不更新
  local j = 1;
  for i=53,77,1 do
    if i ~= 75 and (i <= 64 or i >= 73) then
      local pt = self.keypoints[i];
      pt,self.flag = self:_UpdateEyesKeypoints(pt, self.keypoints[75], self.r1 * self.eyecoef * 0.72);         
      pt,self.flag = self:_UpdateEyesKeypoints(pt, self.keypoints[78], self.r2 * self.eyecoef * 0.72);
      self.keypoints[i] = pt;
    end
  end
        
  --更新脸周位置 
  --左脸
  self.ns = self.keypoints[44];
  for i = 1,9,1 do
    local pt = self.keypoints[i];        
    pt,self.flag = self:_UpdateFaceKeypoints(pt, self.keypoints[i], self.ns, faceonepara[i][1], faceonepara[i][2]*self.facecoef*1.2);  
    self.keypoints[i] = pt;
  end
  
  j = 1;
  --右脸
  for i = 33,25,-1 do
    local pt = self.keypoints[i];      
    pt,self.flag = self:_UpdateFaceKeypoints(pt, self.keypoints[i], self.ns, faceonepara[j][1], faceonepara[j][2]*self.facecoef*1.2);  
    j = j + 1;
    self.keypoints[i] = pt;
  end
  
  j = 1;
  --左下巴
  for i = 10,16,1 do
    local pt = self.keypoints[i];      
    local faceindex = 30;  
    --pt,self.flag = self:_UpdateFaceKeypoints(pt, self.keypoints[i], self.ns, facetwopara[j][1], facetwopara[j][2]*self.chincoef);  
    pt,self.flag = self:_UpdateFaceKeypoints(pt, self.keypoints[i], self.keypoints[faceindex], facetwopara[j][1], facetwopara[j][2]*self.chincoef*2.3);
    faceindex = faceindex - 1;  
    j = j + 1;
    self.keypoints[i] = pt;
  end
  
  j = 1;
  --右下巴
  for i = 24,18,-1 do
    local pt = self.keypoints[i]; 
    local faceindex = 4;  
   -- pt,self.flag = self:_UpdateFaceKeypoints(pt, self.keypoints[i], self.ns, facetwopara[j][1], facetwopara[j][2]*self.chincoef);  
    pt,self.flag = self:_UpdateFaceKeypoints(pt, self.keypoints[i], self.keypoints[faceindex], facetwopara[j][1], facetwopara[j][2]*self.chincoef*2.3);
    faceindex = faceindex + 1;  
    j = j + 1;
    self.keypoints[i] = pt;
  end
  
  --下巴尖
  local pt = self.keypoints[17];       
  pt,self.flag = self:_UpdateFaceKeypoints(pt, self.keypoints[17], self.ns, 0.396, 0.0198*self.chincoef*1.2);  
  --pt,self.flag = self:_UpdateFaceKeypoints(pt, self.keypoints[17], self.ns, 0.396, 0.0198*self.chincoef); 
  self.keypoints[17] = pt;
  --嘴巴
  --self.keypoints[85],self.flag = self:_UpdateFaceKeypoints2(self.keypoints[85], self.keypoints[85], self.keypoints[78], 0.165, 0.0228*self.facecoef*1.1);
  --self.keypoints[91],self.flag = self:_UpdateFaceKeypoints2(self.keypoints[91], self.keypoints[91], self.keypoints[75], 0.165, 0.0228*self.facecoef*1.1);
  --self.ns3 = self.keypoints[46];
  --for i = 86,90,1 do
      --self.keypoints[i],self.flag = self:_UpdateFaceKeypoints2(self.keypoints[i], self.keypoints[i], self.ns3, mousepara[i-85][1], mousepara[i-85][2]*self.facecoef*1.1); 
  --end
  --for i = 92,101,1 do
      --self.keypoints[i],self.flag = self:_UpdateFaceKeypoints2(self.keypoints[i], self.keypoints[i], self.ns3, mousepara[i-86][1], mousepara[i-86][2]*self.facecoef*1.1);
  --end
   

  --鼻子
  self.ns2 = {self.keypoints[44][1],self.keypoints[44][2]*1.05};
  local d3 = GetDistance(self.keypoints[83],self.keypoints[84]);
  --self.keypoints[46],self.flag = self:_UpdateFaceKeypoints(self.keypoints[46], self.keypoints[46], self.ns2, 0.72*d3, 0.036*d3*self.facecoef);
  self.keypoints[81],self.flag = self:_UpdateFaceKeypoints(self.keypoints[81], self.keypoints[81], self.keypoints[82], 0.72*d3, 0.054*d3*self.facecoef*1.1);
  self.keypoints[82],self.flag = self:_UpdateFaceKeypoints(self.keypoints[82], self.keypoints[82], self.keypoints[81], 0.72*d3, 0.054*d3*self.facecoef*1.1);
  self.keypoints[83],self.flag = self:_UpdateFaceKeypoints(self.keypoints[83], self.keypoints[83], self.keypoints[84], 0.72*d3, 0.054*d3*self.facecoef*1.1);
  self.keypoints[84],self.flag = self:_UpdateFaceKeypoints(self.keypoints[84], self.keypoints[84], self.keypoints[83], 0.72*d3, 0.054*d3*self.facecoef*1.1);
  --self.keypoints[50],self.flag = self:_UpdateFaceKeypoints(self.keypoints[50], self.keypoints[50], self.ns2, 0.72*d3, 0.018*d3*self.facecoef*1.1);

  --美妆调整嘴部关键点 71~134
  
  if #self.extrapoints == 134 and #makeup.makeupList>0 then 
    for i = 71,134 do
      local pt = self:ChangeRange(self.extrapoints[i]);
      --左下巴
      if (i>=71 and i<=79) or (i>=88 and i<=90) or (i>=105 and i<=106) or (i>=120 and i<=134) then
        local src = self:ChangeRange(self.keypoints[13]);
        local dst = self:ChangeRange(self.keypoints[28]);
        pt,self.flag = self:_UpdateFaceKeypoints2(pt, src, dst, facetwopara[5][1], facetwopara[5][2]*self.chincoef*2.0*self.pitch*self.rate);
      end
      
      if (i>=79 and i<=87) or (i>=102 and i<=104) or (i>=118 and i<=119) or (i>=120 and i<=134) then
        --右下巴
        local src = self:ChangeRange(self.keypoints[21]);
        local dst = self:ChangeRange(self.keypoints[6]);
        pt,self.flag = self:_UpdateFaceKeypoints2(pt, src, dst, facetwopara[5][1], facetwopara[5][2]*self.chincoef*2.0*self.pitch*self.rate);
      end
      
      if i>=120 and i<=134 then
        --下巴尖
        local src = self:ChangeRange(self.keypoints[17]);
        local dst = self:ChangeRange(self.ns);
        pt,self.flag = self:_UpdateFaceKeypoints2(pt, src, dst, 0.396, 0.0198*self.chincoef*self.pitch*self.rate*1.8);
      end
      self.extrapoints[i] = {pt[1]*0.5+0.5,pt[2]*0.5+0.5};
    end
  end
  
end


function newfacelift:Disable()
  self.isShow = false;
end
 
function newfacelift:Enable()
 self.isShow = true;
end

function newfacelift:OnResizeView(w,h)
  self.aspect_ratio = h/w;
  if not self.facenode or #self.facenode < 1 then
    return;
  end
  for i = 1,self.maxFaceNum,1 do
    self.facenode[i]:SetParameter(apolloengine.ShaderEntity.UNIFORM_RATIOASPECT, mathfunction.vector1(self.aspect_ratio));
  end
end

function newfacelift:Release()
  self.facenode = {};
  self.camera = {};
  self.rt = {};
  self.tex = {};
  self.backnode = {};
  self.mainquadnode = nil;
  self.newframecallback = nil;
end

return newfacelift;
