--require "venusdebug"
local posture = require "facecute.estimates.transposture";
--local posture = require "facecute.estimates.pnpposture";
local apollonode = require "apolloutility.apollonode"
local headtarget =  require "facecute.headtarget";
local immortal =  require "facecute.immortal";
local mathfunction = require "mathfunction"
local apolloengine = require "apolloengine"
local defined = require "facecute.defined"
local videodecet = require "videodecet"
local venusjson = require "venusjson"
local bitop = require "bit"
local cutebehavior = require "facecute.behavior.cutebehavior"
local facedefined = require "facecute.facechange.facedefined"
local faceinfo = require "videodecet.faceinfo"
local cnnseg= require "videodecet.cnnseg"
local transition = require "beauty.transition_makeup"

local likeapp = require "likeapp"
local videodefined = require "videodecet.defined"
local transitiondefine = require "facecute.transitions.transitiondefine"
local faceseg = require "videodecet.faceseg"
local renderqueue = require "apolloutility.renderqueue"
local blendshape = require "emoji.emoji"

--入口文件，解析配置表，调用和组装变形、3d、2d等功能
local makeup = {}
local typeNum = 7;

--初始化系统，传递主摄像机
function makeup:Initialize(maincamera)
  
  self.makeupList = {};
  self.makeupStrength = {};
  for i = 1,typeNum,1 do
    self.makeupStrength[i] = 0.8;
  end
  
  self.maincamera = maincamera;
  --初始化人头姿态估计
  posture:Initialize(maincamera);
  --创建常驻资源
  self.immortal = immortal(self.maincamera);
  self.immortal.groupID = nil
  --美妆人头
  self.makeupheadtargets = {}
  --美妆状态机
  self.makeuptransitionlist = {}
  
  for i = 1, defined.max_head_target_count do
    local ht = headtarget(renderqueue:GetCamera(renderqueue.CAMERA_LAYER_FIRST));
    ht.headIndex = i+3;
    ht.groupID = i+3 - 1
    table.insert(self.makeupheadtargets, ht);
    --创建状态机
    local ts = transition(ht,nil);
    table.insert(self.makeuptransitionlist,ts);
  end
  
  
  self.maxHeadCount = defined.max_head_target_count
  self.headtargetInfo = {
    {rect = nil,keypoint = nil},
    {rect = nil,keypoint = nil},
    {rect = nil,keypoint = nil}
  };
  self.idxlut = {nil,nil,nil};--根据action中的rect重排idxlut
end

function makeup:OnResizeView(w,h)
  posture:OnResizeView(w,h)
  --[[if(cnnseg)
  then
   cnnseg:OnResizeView(w,h);
  end]]
  faceseg:OnResizeView(w,h)
end

--分割配置表
function makeup:_SplitConfig(rootconfig)  
  local fbconfig = {};
  fbconfig.compress_root = rootconfig.compress_root;
  fbconfig.version = rootconfig.version;
  fbconfig.stickerType = rootconfig.stickerType;
  return rootconfig, fbconfig
end

--处理trigger，得出当前动作，遇到需要背景分割的，将分割位置去掉
function makeup:_ProcesssActions(rootconfig)  
  local actions = {}
  --[[if(videodecet.SetCnnSegMark)
  then
    videodecet:SetCnnSegMark(false);
  end
  faceseg:SetSegMark(videodefined.faceSegType.CNNSEG_FULL,false);  
  if(likeapp.AI.ActiveCnnseg)
  then
    likeapp.AI:ActiveCnnseg(false);
  end]]--

  local function _ite(config)
    for key, value in pairs(config) do
      if type(value) == "table" then
        _ite(value);
      elseif key == "triggerType" and value ~= 0 then
        if bitop.band( value, defined.background_segment_flag ) ~= 0 then
          value = value - defined.background_segment_flag;
          config[key] = value;
          if(videodecet.SetCnnSegMark)
          then
              videodecet:SetCnnSegMark(true);
          end
          faceseg:SetSegMark(videodefined.faceSegType.CNNSEG_FULL,true);
          if(likeapp.AI.ActiveCnnseg)
          then
            likeapp.AI:ActiveCnnseg(true);
          end
        end        
        actions[value] = true;
      end      
    end   
  end

  local function _ite_version3(config)
    if config.version == "3.0" and config.transitions then 
      for name , defconfig in pairs(config.transitions) do
        --解析conditions得到触发事件
        if next(defconfig["conditions"]) ~= nil then 
          for _,v in pairs(defconfig["conditions"]) do
            if v["triggers"] ~= nil then 
              local event=v["triggers"]
              local value = transitiondefine.triggerTypeList[event];
              if value ~= nil then actions[value] = true end
            end
          end
        end
      end
    end
  end

  if(rootconfig.version=="3.0")
  then
    self.version = 3;
  else
    self.version = tonumber(rootconfig.version);
  end
  _ite(rootconfig);
  _ite_version3(rootconfig);
  self.activeactions = actions;
  local actionarray = {}
  for key,_ in pairs(actions) do
    table.insert(actionarray, key)
  end
  videodecet:ActiveActions(actionarray);
end

function makeup:GetNilFaceInfo()
  
    if(self.nilface)
    then
      return self.nilface;
    end
    local fo = faceinfo(facedefined.cavasSize);
    local faceTex = facedefined.faceTexPoints;
    local len =facedefined.facePointCount;
    local nilkeyPoints={};
    for i=1,len do
       table.insert( nilkeyPoints,{faceTex[2*i-1]/facedefined.cavasSize[1]-10,faceTex[2*i]/facedefined.cavasSize[2]-10});
      --table.insert( nilkeyPoints,{0,0});
    end
    fo:PushRotation(0,0,0,0);
    fo.rect={0,0,0,0};
    fo:UpdateKeypoints(nilkeyPoints);
    self.nilface = fo
    return fo;
    
end

function makeup:_ActiveActionCount(actions)
  local count = 0;
  for _, pepole in ipairs(actions) do
    for _, action in ipairs(pepole) do
      local id = action:GetActionID();
      if self.activeactions[id] then
        count = count + 1;
        break;
      end      
    end    
  end  
  return count;
end

local emptyaction = {}
local defpos = mathfunction.vector3(0,0,-0.5);
local defrot = mathfunction.Quaternion();
local definfpos = mathfunction.vector3(-10000,-10000,-10000);


function makeup:Update(timespan, maincamera)
  
  if #self.makeupList < 1 then
    return;
  end
  
  local faces = videodecet:GetFaces();

  local actions = videodecet:GetActions();--返回当前识别出来的动作

  if faces then

    posture:Update(faces,maincamera);

    local postures = posture:GetPostures();
    local actioncount = self:_ActiveActionCount(actions);
    local showcount = math.max(#postures, actioncount);

    showcount = math.min(showcount, self.maxHeadCount)

    --预处理识别出来的动作，将第一个人动作列表中动作码>=2^9的动作拷贝至全部人头中
    --动作码>=2^9即为手部动作，默认全部触发。
    if actions[1] then 
      for i = 1, #actions[1] do
        if actions[1][i].actionid >= 2^9 then
          for j = 2, showcount do
            if actions[j] ~= nil then
              table.insert(actions[j], actions[1][i])
            end
          end
        end
      end
    end

    --将keypoint[47]与action.rect相互匹配，使用headtargetInfo记录前一帧中人脸中心的位置
    --根据当前帧中人脸的位置重排序当前帧中人脸的idx，然后更新headtargetInfo
    local headtargetInfo_tmp = { 
      {nil}, --人头的方框（由两个关键点组成，左上角和右下角keypoint[1],keypoint[25]），人头的中心点。
      {nil},
      {nil}
    }

    self.idxlut = {nil,nil,nil};
    
    -- 更新self.idxlut，仅更新能在储存人头信息中能找到的人头
    for i = 1, showcount do --第i个识别的人头
      local idx_tmp = -1

      if faces[i] == nil then
        break
      end

      for j = 1,showcount do -- 第j个储存的人头
        --GetTheNearest self.headtargetInfo[j] with videodecet.faces[i].Keypoint
        --if ( xxx ) then idx_tmp = j end --第i个识别的人头距离第j个储存的人头最近
        --并且第i个识别的人头在第j个储存的人头方框里面。
        if self.headtargetInfo[j] ~= nil and self.headtargetInfo[j].rect then --第j个储存的人头不为空
          local rect = self.headtargetInfo[j].rect
          local point = faces[i].Keypoint[47]
          if PointInRect(rect[1],rect[4],rect[3],rect[2],point[1],point[2]) then --若第i个识别的人头在第j个储存的人头方框里面
            idx_tmp = j
            break
          end
        end
      end

      if idx_tmp ~= -1 then --若在实际储存的人头信息中可以找到识别的人头信息，更新储存的副本信息
        self.idxlut[i] = idx_tmp;--第i个识别出来的人头，对应第idx_tmp个储存的人头
        --更新实际储存的人头信息副本，包括关键点与人脸矩形
        headtargetInfo_tmp[idx_tmp].Keypoint = faces[i].Keypoint[47]
        local face_point_tmp = faces[i].Keypoint
        headtargetInfo_tmp[idx_tmp].rect =  {
          face_point_tmp[1][1],
          face_point_tmp[1][2],
          face_point_tmp[25][1],
          face_point_tmp[25][2]
        };
        --将实际储存的人头信息副本更新完成之后复制到实际储存的人头信息中：
      end
    end

    -- 更新self.idxlut.仅更新不能在储存人头信息中能找到的人头
    for i = 1, showcount do --第i个识别的人头
      local idx_tmp = -1

      if faces[i] == nil then
        break
      end

      for j = 1, showcount do -- 第j个储存的人头
        --GetTheNearest self.headtargetInfo[j] with videodecet.faces[i].Keypoint
        --if ( xxx ) then idx_tmp = j end --第i个识别的人头距离第j个储存的人头最近
        --并且第i个识别的人头在第j个储存的人头方框里面。
        if self.headtargetInfo[j] ~= nil and self.headtargetInfo[j].rect then --第j个储存的人头不为空
          local rect = self.headtargetInfo[j].rect
          local point = faces[i].Keypoint[47]
          if PointInRect(rect[1],rect[4],rect[3],rect[2],point[1],point[2]) then --若第i个识别的人头在第j个储存的人头方框里面
            idx_tmp = j
            break
          end
        end
      end
  
      if idx_tmp == -1 then --若在实际储存的人头信息中没有找到识别的人头信息，说明识别的人头信息是新加入的，需要将识别的人头信息加入到实际储存的人头信息副本中
        for i_1 = 1, #headtargetInfo_tmp do
          if next(headtargetInfo_tmp[i_1]) == nil then
            idx_tmp = i_1
            break
          end
          --在headtargetInfo_tmp中得到第一个为空的人头的id
        end
        self.idxlut[i] = idx_tmp;--第i个识别出来的人头，对应第idx_tmp个储存的人头
        --更新实际储存的人头信息副本，包括关键点与人脸矩形
        headtargetInfo_tmp[idx_tmp].Keypoint = faces[i].Keypoint[47]
        local face_point_tmp = faces[i].Keypoint
        headtargetInfo_tmp[idx_tmp].rect = {
          face_point_tmp[1][1],
          face_point_tmp[1][2],
          face_point_tmp[25][1],
          face_point_tmp[25][2]
        };
        --将实际储存的人头信息副本更新完成之后复制到实际储存的人头信息中：
      end
      
    end

    self.headtargetInfo = headtargetInfo_tmp --能够赋值为临时变量吗？

    --判断关键点(px,py)是否在框内
    --          (x1,y1) ---(x2,y1)
    --                  | |
    --          (x1,y2) ---(x2,y2)
    function PointInRect(x1,y1,x2,y2,px,py)
      local isPointIn = GetCorssPoint(x1,y1,x2,y1,px,py)*GetCorssPoint(x2,y2,x1,y2,px,py) >=0 and GetCorssPoint(x1,y2,x1,y1,px,py)*GetCorssPoint(x2,y1,x2,y2,px,py) >=0
      return isPointIn
    end

    --return  |p1 p2| X |p1 p|
    function GetCorssPoint(p1x,p1y,p2x,p2y,px,py)
      return (p2x - p1x) * (py - p1y) - (px - p1x) * (p2y - p1y)
    end
    
    
    for i = 1, showcount do
      local hn = self.makeupheadtargets[i]
      local ts = self.makeuptransitionlist[i]
      hn:SetShow(true);
      ts:SetShow(true);
    end
    for i = showcount + 1, #self.makeupheadtargets do
      local hn = self.makeupheadtargets[i]
      local ts = self.makeuptransitionlist[i]
      hn:SetShow(false);
      ts:SetShow(false);
    end
    --再修改需要的
    --若没有人头
    if 0 == #postures then
      --更新公共资源
      local nilface = self:GetNilFaceInfo();
      self.immortal:Update(timespan, nilface, nil, nil, actions[1] or emptyaction);
      for i = 1, showcount do
        --更新人头资源
        local mphn = self.makeupheadtargets[i]
        local mpts = self.makeuptransitionlist[i]
        if mphn then
          mphn:Update(timespan, nilface, definfpos, defrot, actions[i]);
        end
        if mpts then
          mpts:Update(actions[i], i);
        end
      end
    else--若有人头
      for index, est in ipairs(postures) do
        if 1 == index then
          --按照第一个人的数据更新公共资源
          self.immortal:Update(timespan, faces[index], est.position, est.rotation, actions[index]);
        end 
          
        local mphn = self.makeupheadtargets[self.idxlut[index]];
        local mpts = self.makeuptransitionlist[self.idxlut[index]];

        if mphn then
          mphn:SetShow(true);
          mphn:Update(timespan, faces[index], est.position, est.rotation, actions[index]);
        end

        if mpts then 
          mpts:SetShow(true)
          mpts:Update(actions[index],index);
        end
      end
      
    end  
    
  end
  
  if #faces < 1 or blendshape.emoji3d ~= nil then
    for key,value in pairs(self.makeupList) do
      for _, ht in ipairs(self.makeupheadtargets) do
        ht:SetShow(false);
      end
      for _, ts in ipairs(self.makeuptransitionlist) do
        ts:SetShow(false);
      end
    end
  end
end

function makeup:LoadMakeup(makeuptype,path,rootconfig)
  local tempchangeList = self.makeupList;
  for i=1,#tempchangeList,1 do
    if tempchangeList[i] == makeuptype then
      self:ReleaseMakeup(makeuptype)
      break;
    end
  end
  
  local res = true;
  local addlayer = nil;

  local pathDir, configName = string.match(path, "(.+)[:/]([^/]*)%.%w+$");
  
  self:_ProcesssActions(rootconfig);
  
  --local rootconfig, fbconfig = self:_SplitConfig(rootconfig);

  local paramters = {
    pathDir,
    tonumber(rootconfig["version"])
  };
  
  --美妆用商汤贴纸同名tag下的混合方式出来效果与线上不同，因此在此使其指向美妆混合方式
  local faceroot = rootconfig["faceMorph"];
  if (faceroot~=nil) then
    local faceMakeUps = faceroot["makeups"];
    local faceLen = table.getn(faceMakeUps);
    for i=1,faceLen do
      if faceMakeUps[i]["tag"] == "EYE_SHADOW" then
        rootconfig["faceMorph"]["makeups"][i]["tag"] = "MAKEUP_"..faceMakeUps[i]["tag"];
      end
    end
  end
  
  if makeuptype == 2 then --腮红
    local Morph = rootconfig["faceMorph"];
    if (Morph~=nil) then
      local faceMakeUps = Morph["makeups"];
      local faceLen = table.getn(faceMakeUps);
      for i=1,faceLen do
        rootconfig["faceMorph"]["makeups"][i]["name"] = rootconfig["faceMorph"]["makeups"][i]["name"].."blush";
      end
    end
    
    local Trans = rootconfig["transitions"]["Transition1"];
    if (Trans~=nil) then
      local targets = Trans["targets"];
      local targetLen = table.getn(targets);
      for i=1,targetLen do
        rootconfig["transitions"]["Transition1"]["targets"][i]["targetPart"] = rootconfig["transitions"]["Transition1"]["targets"][i]["targetPart"].."blush";
      end
    end
  end
  
  if makeuptype == 4 then --修容
    addlayer = 5;
  elseif makeuptype == 2 then --腮红
    addlayer = 4;
  end
  
     
  local maxHeadCount = rootconfig["maxHeadCount"]
  if maxHeadCount ~= nil then
    self.maxHeadCount = math.min(maxHeadCount, self.maxHeadCount);
  end
  
  local isallpoint = true;
  --[[local pointtable = likeapp.AI:GetExtraFacePoints();
  if pointtable == nil then
    LOG("106POINT!!!!!!!");
    isallpoint = false;
  end]]--
    
  local modellevel = likeapp.AI:GetMakeUpLevel();
  if modellevel == 1 then --机型判断，1为低端机，其余为中高端机型
    isallpoint = false;
    LOG("makeup use 106 point");
  else
    LOG("makeup use 240 point");
  end
  
  if makeuptype == 3 then --口红一律是240点
    isallpoint = true;
  end
  
  
  for i = 1, self.maxHeadCount do
    local ht = self.makeupheadtargets[i];
    res = res and ht:ParseMakeupConfig(rootconfig, paramters, makeuptype, isallpoint, self.makeupStrength[makeuptype]);
  end
  

  if rootconfig.transitions then
    for _,ts in ipairs(self.makeuptransitionlist) do
      --ts:SetMakeup(true,type);
      ts:MakeupParseConfig(rootconfig,makeuptype);
    end
  end

  renderqueue:UpdateObjQueue(addlayer);
  renderqueue:Activate(renderqueue.CAMERA_LAYER_FIRST);
  
  table.insert(self.makeupList,makeuptype);
  return res;
end

function makeup:ReleaseMakeup(makeuptype)
  for _, ht in ipairs(self.makeupheadtargets) do
    ht:ReleaseMakeup(makeuptype);
  end
  for _, ts in ipairs(self.makeuptransitionlist) do
    ts:ReleaseMakeup(makeuptype);
  end
  
  for key,value in pairs(self.makeupList) do
    if value == makeuptype then
      table.remove(self.makeupList,key)
    end
  end
  
  self.makeupStrength[makeuptype] = 1.0;
  return self.makeupList;
  --self.maxHeadCount = defined.max_head_target_count
end

function makeup:SetMakeupStrength(strength,makeuptype)
  self.makeupStrength[makeuptype] = strength;
  for _, ht in ipairs(self.makeupheadtargets) do
    ht:SetMakeupStrength(strength,makeuptype);
  end
end

function makeup:UpdateMakeupLayer()
  for _, ht in ipairs(self.makeupheadtargets) do
    local assets = ht.assets;
    for key,value in ipairs(assets) do
      local addlayer = nil;
      value:AddToRenderQueue();
      if value.type == 4 then
        addlayer = 5
      elseif value.type == 2 then
        addlayer = 4;
      end
      renderqueue:UpdateObjQueue(addlayer);
    end
  end
end

return makeup;
