require "utility"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local videodecet = require "videodecet"
local venuscore = require "venuscore"

local smooth = {}

smooth.renderObject = nil;
smooth.queue = 100;

function smooth:Initialize(host, size)

  self.Stepsize1 = mathfunction.vector2(5, 5);
  self.Stepsize2 = mathfunction.vector2(2, 2);
  self.intensity = 1.0;
  self.size = size;
  
  self.maskPath = "docs:beauty/yuvdst.png";
  self.tex = apolloengine.TextureEntity();
  self.tex:PushMetadata(apolloengine.TextureFileMetadata(
        apolloengine.TextureEntity.TU_STATIC,
        apolloengine.TextureEntity.PF_AUTO,1, false,
        apolloengine.TextureEntity.TW_CLAMP_TO_EDGE,
        apolloengine.TextureEntity.TW_CLAMP_TO_EDGE,
        apolloengine.TextureEntity.TF_NEAREST,
        apolloengine.TextureEntity.TF_NEAREST,
        self.maskPath));
  self.tex:SetJobType(venuscore.IJob.JT_SYNCHRONOUS);
  self.tex:CreateResource();
  
  self.GAUSSIAN_STEP = apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,
      "GAUSSIAN_STEP");
  self.GAUSSUAN_COORDNATE = apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.INTERNAL,
      "GAUSSUAN_COORDNATE");
  self.TEXTURE_ORIGIN = apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,
      "TEXTURE_ORIGIN");
  self.TEXTURE_BLUR = apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,
      "TEXTURE_BLUR");
  self.TEXTURE_MASK = apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,
      "TEXTURE_MASK");
  self.UNIFORM_INTENSITY = apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,
      "UNIFORM_INTENSITY");
  
  local GuassStep1 = self.Stepsize1 / size;
  local GuassStep2 = self.Stepsize2 / size;

  
  self.HighPass = host:CreateRenderObject( "docs:beauty/material/highpass.material" );
  
  self.Blend = host:CreateRenderObject( "docs:beauty/material/smoothblend.material" );
  self.Blend:SetParameter( self.UNIFORM_INTENSITY, mathfunction.vector1(self.intensity) );
  self.Blend:SetParameter( self.TEXTURE_MASK, self.tex);
  
  self.GaussXY = host:CreateRenderObject( "docs:beauty/material/gaussianblurbeauty.material" );
  self.GaussXY:SetParameter( self.GAUSSIAN_STEP, mathfunction.vector2( GuassStep1:x(), GuassStep1:y()) );
  
  self.OriBlurRT = host:CreateRenderTarget( apolloengine.RenderTargetEntity.ST_SWAP_A, size );
  self.DetectRT = host:CreateRenderTarget( apolloengine.RenderTargetEntity.ST_SWAP_B, size );
  self.HpBlurRT = host:CreateRenderTarget( apolloengine.RenderTargetEntity.ST_SWAP_C, size );
  
  return self.queue;
end

function smooth:Resizeview(size)
  local GuassStep1 = self.Stepsize1 / size;
  self.size = size;
  self.GaussXY:SetParameter( self.GAUSSIAN_STEP, mathfunction.vector2( GuassStep1:x(), GuassStep1:y()) );
end

function smooth:Process(pipeline, Original, Scene, Output)
  local origintexture =  Scene:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 )
  self.HighPass:SetParameter(self.TEXTURE_ORIGIN, origintexture);
  self:_UpdateParameters();
  
  self.OriBlurRT:PushRenderTarget();
	self.OriBlurRT:ClearBuffer( apolloengine.RenderTargetEntity.CF_COLOR );
	self.GaussXY:SetParameter(
		apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
		Scene:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
	self.GaussXY:Draw(pipeline);
  
  local blurtex = self.OriBlurRT:GetAttachment(apolloengine.RenderTargetEntity.TA_COLOR_0);
  self.DetectRT:PushRenderTarget();
  self.DetectRT:ClearBuffer(apolloengine.RenderTargetEntity.CF_COLOR);
  self.HighPass:SetParameter(
          apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
          self.OriBlurRT:GetAttachment(apolloengine.RenderTargetEntity.TA_COLOR_0));
  self.HighPass:Draw(pipeline);
  
  self.HpBlurRT:PushRenderTarget();
  self.HpBlurRT:ClearBuffer(apolloengine.RenderTargetEntity.CF_COLOR);
  self.GaussXY:SetParameter(
		apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
		self.DetectRT:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
  self.GaussXY:Draw(pipeline);
  
  self.Blend:SetParameter( self.TEXTURE_ORIGIN,origintexture);
  self.Blend:SetParameter( self.TEXTURE_BLUR,blurtex);
  Output:PushRenderTarget();
  Output:ClearBuffer(apolloengine.RenderTargetEntity.TA_COLOR_0);
  self.Blend:SetParameter(
		apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
		self.HpBlurRT:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
  self.Blend:Draw(pipeline);
end

function smooth:_UpdateParameters()
 self.Blend:SetParameter( self.UNIFORM_INTENSITY, mathfunction.vector1(self.intensity) );
end

return smooth;