local venusjson = require "venusjson"
local venuscore = require "venuscore"
local object = require "classic"
local torch = require "torch"
local mathfunction = require "mathfunction"

local CameraCorrection = {}

--[[
1.LeftShoulder
2.RightShoulder
3.LeftHip
4.RightHip
]]--


function CameraCorrection:Initialize(focallength, cx, cy)
  self.focallength = focallength
  self.cx = cx
  self.cy = cy
  self.viewmat = torch.Tensor(3,3):fill(0);
  self.viewmat[1][1] = self.focallength;
  self.viewmat[2][2] = self.focallength;
  self.viewmat[3][1] = self.cx;
  self.viewmat[3][2] = self.cy;
  self.viewmat[3][3] = 1;
end

function CameraCorrection:GetTorsoJoints(pos2d, pos3d)
  local torso2d = {}
  local torso3d = {}
  
  torso2d[1] = pos2d[4]
  torso2d[2] = pos2d[1]
  torso2d[3] = pos2d[10]
  torso2d[4] = pos2d[7]
  
  torso3d[1] = pos3d[4]
  torso3d[2] = pos3d[1]
  torso3d[3] = pos3d[10]
  torso3d[4] = pos3d[7]
  
return torso2d, torso3d;
end

function CameraCorrection:Estimate(pos2d, pos3d)
  local torso2d = {}
  local torso3d = {}
  -- torso2d, torso3d = self:GetTorsoJoints(pos2d, pos3d)

  table.insert(torso2d, mathfunction.vector2(pos2d[4][1], pos2d[4][2]))
  table.insert(torso2d, mathfunction.vector2(pos2d[1][1], pos2d[1][2]))
  table.insert(torso2d, mathfunction.vector2(pos2d[10][1], pos2d[10][2]))
  table.insert(torso2d, mathfunction.vector2(pos2d[7][1], pos2d[7][2]))
  table.insert(torso3d, mathfunction.vector3(pos3d[4][1], pos3d[4][2], pos3d[4][3]))
  table.insert(torso3d, mathfunction.vector3(pos3d[1][1], pos3d[1][2], pos3d[1][3]))
  table.insert(torso3d, mathfunction.vector3(pos3d[10][1], pos3d[10][2], pos3d[10][3]))
  table.insert(torso3d, mathfunction.vector3(pos3d[7][1], pos3d[7][2], pos3d[7][3]))
  
  local height2d =  (torso2d[1]-torso2d[3]):Length()+ (torso2d[2]-torso2d[4]):Length();
  local height3d =  (torso3d[1]-torso3d[3]):Length()+ (torso3d[2]-torso3d[4]):Length();
  local zoffset = self.focallength*height3d/height2d;
  
  local m3dpos = torch.Tensor(#torso3d,3);
  for i=1,#torso3d do
    m3dpos[i][1] = torso3d[i]:x();
    m3dpos[i][2] = torso3d[i]:y();
    m3dpos[i][3] = torso3d[i]:z()+zoffset;
  end
  
  
  local m2dtemp = m3dpos*self.viewmat;
  local m2dpose = torch.Tensor(#torso3d,2);
   for i=1,#torso3d do
    m2dpose[i][1] = m2dtemp[i][1]/m2dtemp[i][3];
    m2dpose[i][2] = m2dtemp[i][2]/m2dtemp[i][3];
  end  
  local m2dtarget = torch.Tensor(#torso2d,2);
  for i=1,#torso2d do
    m2dtarget[i][1] = torso2d[i]:x();
    m2dtarget[i][2] = torso2d[i]:y();
  end  
  
  local offset = m2dtarget - m2dpose;
  
  local r2doffset = {0,0};

  for i=1, offset:size()[1] do
    r2doffset[1] = r2doffset[1]+offset[i][1];
    r2doffset[2] = r2doffset[2]+offset[i][2];
  end
  r2doffset[1] = r2doffset[1]/4;
  r2doffset[2] = r2doffset[2]/4;
  return {r2doffset[1], r2doffset[2], zoffset};
end

return CameraCorrection;