local mathfunction = require "mathfunction"


local simpleretarget = {}

function simpleretarget:Initialize(targetbonepose)
  self.bonepose = {}
 
  
  self.targetbonepose = {}
  for i = 1,14 do
      self.targetbonepose [i]= mathfunction.vector3(targetbonepose[i][1],targetbonepose[i][2],targetbonepose[i][3]) ;
  end
  
  
  
  self.targetheight = self:GetTotalHeight(self.targetbonepose);
  self.targetwidth = self:GetBodyWidth(self.targetbonepose);
  
 
end

function simpleretarget:UpdateBoneData(bonepose)
   for i = 1,14 do
      self.bonepose [i]= mathfunction.vector3(bonepose[i][1],bonepose[i][2],bonepose[i][3]) ;
  end
  self.height = self:GetTotalHeight(self.bonepose);
  self.width = self:GetBodyWidth(self.bonepose);
  
  self.heighttime = self.targetheight/self.height;
  self.widtthtime = self.targetwidth/self.width;
  self.heightscale = self.heighttime /self.widtthtime
end

function simpleretarget:GetTotalHeight(bonepose)
  local nechead = bonepose[14] - bonepose[13]
  
  local rupbody =bonepose[1] -  bonepose[7]
  local rupleg = bonepose[7] -  bonepose[8]
  local rlowleg =bonepose[8] -  bonepose[9]

  local lupbody =bonepose[2] -  bonepose[10]
  local lupleg = bonepose[10] - bonepose[11]
  local llowleg =bonepose[11] - bonepose[12]
  
  local rlen = rupbody:Length()+rupleg:Length()+rlowleg:Length();
  local llen = lupbody:Length()+lupleg:Length()+llowleg:Length();
  
  return (rlen+llen)/2;
end

function simpleretarget:GetBodyWidth(bonepose)
  local wvec = bonepose[10] - bonepose[7];
  return wvec:Length();
end


function simpleretarget:Retarget(position)
  self:UpdateBoneData(position);
  for i=1,#position do
    local vv = position[i][2]*self.heightscale
    position[i][2] = vv
  end
  return position;
end

return simpleretarget;
