local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local venuscore = require "venuscore"
local Object = require "classic"


local maskRender = Object:extend();

function maskRender:new(vertexcount, indexcount, indexstream, color,tex)
  self.node = apolloengine.Node();--创建基础节点
  self.render = self.node:CreateComponent(apolloengine.Node.CT_RENDER);--创建基础渲染组建
  self.vertexstream = apolloengine.VertexStream();--创建顶点流
  --设置顶点流提供位置以及纹理坐标两个属性，且原始数据格式为float格式，目标格式（显存中的数据格式）为半浮点，数据的个数为4个float和2个float
  
  self.vertexstream:SetVertexType(apolloengine.ShaderEntity.ATTRIBUTE_POSITION,
    apolloengine.VertexBufferEntity.DT_FLOAT,
    apolloengine.VertexBufferEntity.DT_HALF_FLOAT,2);
  self.vertexstream:SetVertexType(apolloengine.ShaderEntity.ATTRIBUTE_COORDNATE0,
		apolloengine.VertexBufferEntity.DT_FLOAT,
		apolloengine.VertexBufferEntity.DT_HALF_FLOAT,2);
  self.vertexstream:ReserveBuffer(vertexcount);--预先分配4个顶点的内存
  
  self.indexstream = apolloengine.IndicesStream(); 
  self.indexstream:SetIndicesType(apolloengine.IndicesBufferEntity.IT_UINT16);
  self.indexstream:ReserveBuffer(indexcount);
  
  for i=1, vertexcount do
      self.vertexstream:PushVertexData(apolloengine.ShaderEntity.ATTRIBUTE_POSITION, mathfunction.vector2(0,0));
      self.vertexstream:PushVertexData(apolloengine.ShaderEntity.ATTRIBUTE_COORDNATE0,mathfunction.vector2(0,0));
  end 
  self.indexstream = indexstream;
  
  self.render:PushMetadata(--传入材质原始数据
    apolloengine.RenderObjectMaterialMetadata(
      apolloengine.PathMetadata("comm:documents/material/maskrender.material")));

  self.render:PushMetadata(--创建可以渲染的顶点流
		apolloengine.RenderObjectMeshMetadate( 
			apolloengine.RenderComponent.RM_TRIANGLES,
      apolloengine.ReferenceVertexMetadata(
        apolloengine.VertexBufferEntity.MU_DYNAMIC,
        self.vertexstream),
    apolloengine.ReferenceIndicesMetadata(
        apolloengine.VertexBufferEntity.MU_STATIC,--索引不需要修改
        self.indexstream)));  
  
  
  self.render:CreateResource();
  
  
  self.render:SetParameter(
    apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
    tex);
  
end

function maskRender:SetShow(isshow)
  if isshow then
    self.render:SetRenderProperty(apolloengine.RenderComponent.RP_SHOW);
  else
    self.render:EraseRenderProperty(apolloengine.RenderComponent.RP_SHOW);
  end  
end

function maskRender:Update(vertexstream)
  --[[local newpoint =  mathfunction.vector2(0, 0);
  local index = self.vertexstream:GetAttributeIndex(apolloengine.ShaderEntity.ATTRIBUTE_POSITION);
  for i=1, #points_table do
    local point = points_table[i];
    newpoint:Set(point[1], point[2], 0, 1);
    self.vertexstream:ChangeVertexDataWithAttributeFast(
      index,
      i,
      newpoint);
  end
  self.vertexstream:SetReflushInterval(1, #points_table);]]--
  --self.vertexstream = vertexstream;
  
  self.render:ChangeVertexBuffer(vertexstream);
end

function maskRender:SetSequence(s)
  self.render:SetSequence(s);
end

function maskRender:SetParameter(slot, value)
  if value then
    self.render:SetParameter(slot, value);
  end  
end

return maskRender;