local TransNode = require "apolloutility.apollonode.trasnnode"
local CameraNode = require "apolloutility.apollonode.cameranode"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"


--灯光节点
local LightNode = TransNode:extend();

function LightNode:new(lightType)
  LightNode.super.new(self)
  self.node:SetName("LightNode")
  self.light = self.node:CreateComponent(apolloengine.Node.CT_LIGHT);
  self.light.LightType = lightType;
end


function LightNode:SetColor(c)
  self.light:SetColor(c);
end

function LightNode:SetLocalDirection(d)
  self.light:SetLocalDirection(d);
end

function LightNode:SetRange(r)
  self.light:SetRange(r);
end

function LightNode:SetLightAngle(angle)
  self.light:SetLightAngle(angle);
end


function LightNode:EnableShadowCaster(shadowtype)
  self.light:EnableShadowCaster(shadowtype);
end

function LightNode:DisableShadowCaster()
  self.light:DisableShadowCaster();
end


function LightNode:GetShadowCamera()
  if not self.shadowcamera then
    local res = self.light:GetShadowCamera();
    self.shadowcamera = {}
    self.shadowcamera = CameraNode:cast(self.shadowcamera);
    self.shadowcamera.camera = res;
    self.shadowcamera.node = self.node;
    self.shadowcamera.trans = self.trans;
    self.shadowcamera.position = self.position;
    self.shadowcamera.scale = self.scale;
  end
  if not self.transparentshadowcamera then
    local res = self.light:GetTransparentShadowCamera();
    self.transparentshadowcamera = {}
    self.transparentshadowcamera = CameraNode:cast(self.transparentshadowcamera);
    self.transparentshadowcamera.camera = res;
    self.transparentshadowcamera.node = self.node;
    self.transparentshadowcamera.trans = self.trans;
    self.transparentshadowcamera.position = self.position;
    self.transparentshadowcamera.scale = self.scale;
  end
  return self.shadowcamera, self.transparentshadowcamera;
end



return LightNode;
