local TransNode = require "apolloutility.apollonode.trasnnode"
local PostEffect = require "apolloutility.apollonode.posteffect"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"

--渲染节点
local CameraNode = TransNode:extend();

function CameraNode:new(resolution, color)
  CameraNode.super.new(self)
  self.node:SetName("CameraNode")
  self.camera = self.node:CreateComponent(apolloengine.Node.CT_CAMERA);
  self.camera:SetSequenceCulling(true);
  if resolution then
    self.camera:FixedResolution(resolution);
  end
end

function CameraNode:AttachRenderTarget(fbo)
  self.camera:AttachRenderTarget(fbo);
end

function CameraNode:CreatePostEffect()
  local post = self.camera:CreatePostEffect();
  return PostEffect(post);
end

function CameraNode:DeletePostEffect(pe)
  self.camera:DeletePostEffect(pe:GetPostEffect());
  pe.post = nil;
end

function CameraNode:Activate()
  self.camera:Activate();
end

function CameraNode:Deactivate()
  self.camera:Deactivate();
end

function CameraNode:SetSequence(seq)
  self.camera:SetSequence(seq);
end

function CameraNode:GetSequence()
  return self.camera:GetSequence();
end

function CameraNode:AddLayerMask(mask)
  self.camera:AddLayerMask(mask);
end

function CameraNode:EraseLayerMask(mask)
  self.camera:EraseLayerMask(mask);
end

function CameraNode:CreateRealCameraProjection(n, f)
  self.camera:CreateRealCameraProjection(n, f);
end

function CameraNode:CreatePerspectiveProjection(r, a, n, f)
  if nil == n or nil == f then
    self.camera:CreatePerspectiveProjection(r, a);
  else    
    self.camera:CreatePerspectiveProjection(r, a, n, f);
  end  
end

function CameraNode:CreateOrthographiProjection(w, h, n, f)
    if nil == n or nil == f then
    self.camera:CreateOrthographiProjection(w, h);
  else    
    self.camera:CreateOrthographiProjection(w, h, n, f);
  end  
end

function CameraNode:LookAt(pos, at, up)
  self.camera:LookAt(pos, at, up);
end

function CameraNode:SetPosition(pos)
  self.camera:SetPosition(pos);
end

function CameraNode:SetForward(f)
  self.camera:SetForward(f);
end

function CameraNode:GetNear()
  return self.camera:GetNear();
end

function CameraNode:GetFar()
  return self.camera:GetFar();
end

function CameraNode:PickRay(point)
  return self.camera:PickRay(point);
end

function CameraNode:GetView()
  return self.camera:GetView();
end

function CameraNode:GetProject()
  return self.camera:GetProject();
end

function CameraNode:GetViewProj()
  return self.camera:GetViewProj();
end

function CameraNode:isVisible(aabb)
  return self.camera:isVisible(aabb);
end

function CameraNode:GetForward()
  return self.camera:GetForward();
end

function CameraNode:GetUp()
  return self.camera:GetUp();
end

function CameraNode:GetPosition()
  return self.camera:GetPosition();
end

function CameraNode:Recalculate()
  return self.camera:Recalculate();
end

function CameraNode:GetNode()
  return self.camera;
end

function CameraNode:GetCameraResolution()
  return self.camera:GetCameraResolution();
end

function CameraNode:SetClearFlag(flag)
  return self.camera:SetClearFlag(flag);
end


function CameraNode:SetClearColor(color)
  self.camera:SetClearColor(color);
end
return CameraNode;
